#include "commonheaders.h"
#include "cls-window.h"
#include "window.h"
#include "processing.h"

short tempX3 = -1;
short tempY3 = -1;

void RoomPlace(short xLocation, short yLocation) {
    if(roomamount > 0) {
        if(yLocation >= 0 && xLocation >= 0){
            if(yLocation < roomTiles[selectedroom].ySize  && xLocation < roomTiles[selectedroom].xSize){
                roomTiles[selectedroom].tiles[yLocation][xLocation].flip = selectedflip;
                roomTiles[selectedroom].tiles[yLocation][xLocation].rotation = selectedrot;
                roomTiles[selectedroom].tiles[yLocation][xLocation].tileval = selectedtile;
                roomTiles[selectedroom].tiles[yLocation][xLocation].clip = selectedclip - 1;
				roomTiles[selectedroom].tiles[yLocation][xLocation].foreground = foreground;
				roomTiles[selectedroom].tiles[yLocation][xLocation].fade = transitional;
                //printf("%i->%i,%i\n", room_tiles[selectedroom][yLocation][xLocation], yLocation,xLocation);
            }
        }
    }
}

void RoomErase(short xLocation, short yLocation) {
    if(roomamount > 0) {
        if(yLocation >= 0 && xLocation >= 0){
            if(yLocation < roomTiles[selectedroom].ySize && xLocation < roomTiles[selectedroom].xSize){
				roomTiles[selectedroom].tiles[yLocation][xLocation].flip = 0;
				roomTiles[selectedroom].tiles[yLocation][xLocation].rotation = 0;
				roomTiles[selectedroom].tiles[yLocation][xLocation].foreground = 0;
				roomTiles[selectedroom].tiles[yLocation][xLocation].fade = 0;
				roomTiles[selectedroom].tiles[yLocation][xLocation].clip = 0;
				roomTiles[selectedroom].tiles[yLocation][xLocation].tileval = 0;
                //printf("%i->%i,%i\n", room_tiles[selectedroom][yLocation][xLocation], yLocation,xLocation);
            }
        }
    }
}

void RoomHover(short xLocation, short yLocation) {
	tempX3 = xLocation;
	tempY3 = yLocation;
}

void RoomDraw(BITMAP *output, short gridSize) {
    if(tempX3 > -1 && tempY3 > -1) {
    short y = Windows[RWin("Room Editor")]->Viewports[0]->yScroll;
    short x = Windows[RWin("Room Editor")]->Viewports[0]->xScroll;
	if(mouse_b & 1)
		set_trans_blender(0,0,0,255);
	else
		set_trans_blender(0,0,0,128);
	draw_trans_sprite(output, TileImages[selectedtile - 1], (tempX3 - x) * gridSize + 1, (tempY3 - y) * gridSize + 1);
    }
}

BITMAP *RoomViewport(short xLocation, short yLocation) {
    BITMAP *temp = create_bitmap(16, 16);
    clear_to_color(temp, makecol(32, 32, 32));
    BITMAP *ex = create_bitmap(16, 16);
    clear_to_color(ex, makecol(255, 0, 255));
    if(roomamount > 0) {
        if(yLocation >= 0 && xLocation >= 0){
            if(yLocation < roomTiles[selectedroom].ySize && xLocation < roomTiles[selectedroom].xSize){
                if(roomTiles[selectedroom].tiles[yLocation][xLocation].tileval > 0 && roomTiles[selectedroom].tiles[yLocation][xLocation].tileval <= tileamount) {
                    if(roomTiles[selectedroom].tiles[yLocation][xLocation].fade == 0 && showfades) {
                        set_trans_blender(0,0,0,128);
                        BITMAP *trans = create_bitmap(16, 16);
                        clear_to_color(trans, makecol(32, 32, 32));
                        draw_trans_sprite(trans, TileImages[roomTiles[selectedroom].tiles[yLocation][xLocation].tileval - 1], 0, 0);
                        rotate_sprite(temp, trans, 0, 0, roomTiles[selectedroom].tiles[yLocation][xLocation].rotation * 32 << 16);
                        destroy_bitmap(trans);
                    } else {
                        rotate_sprite(temp, TileImages[roomTiles[selectedroom].tiles[yLocation][xLocation].tileval - 1], 0, 0, roomTiles[selectedroom].tiles[yLocation][xLocation].rotation * 32 << 16);
                    }
					if(roomTiles[selectedroom].tiles[yLocation][xLocation].flip == 0)
						draw_sprite(ex, temp, 0, 0);
                    else if(roomTiles[selectedroom].tiles[yLocation][xLocation].flip == 1)
						draw_sprite_h_flip(ex, temp, 0, 0);
					else if(roomTiles[selectedroom].tiles[yLocation][xLocation].flip == 2)
						draw_sprite_v_flip(ex, temp, 0, 0);
					else if(roomTiles[selectedroom].tiles[yLocation][xLocation].flip == 3)
						draw_sprite_vh_flip(ex, temp, 0, 0);
					if(showclips && roomTiles[selectedroom].tiles[yLocation][xLocation].clip < clipamount) {
                        set_trans_blender(0,0,0,128);
                        draw_trans_sprite(ex, ClipImages[roomTiles[selectedroom].tiles[yLocation][xLocation].clip], 0, 0);
                    }
                }
            }
        }
    }
    //textprintf(ex, font, 0, 0, -1, "%i", roomTiles[selectedroom].tiles[yLocation][xLocation].tileval);
    //textprintf(ex, font, 0, 8, -1, "%i", roomTiles[selectedroom].tiles[yLocation][xLocation].clip);
	destroy_bitmap(temp);
    return ex;
}

