#include "commonheaders.h"
#include "cls-window.h"
#include "window.h"
#include "processing.h"


#ifndef PROCESSING_CPP
#define PROCESSING_CPP

void RefreshTilePreview(void) 
{
    BITMAP *temp = create_bitmap(16, 16);
    clear_to_color(temp, makecol(255,0,255));
    BITMAP *ex = create_bitmap(16, 16);
    clear_to_color(ex, makecol(255, 0, 255));
    if(selectedtile > 0 && selectedtile <= tileamount) {
        printf("ST%i\n", selectedtile - 1);
        rotate_sprite(temp, TileImages[selectedtile - 1], 0, 0, selectedrot * 32 << 16);
		if(selectedflip == 0)
		  draw_sprite(ex, temp, 0, 0);
		else if(selectedflip == 1)
			draw_sprite_h_flip(ex, temp, 0, 0);
		else if(selectedflip == 2)
			draw_sprite_v_flip(ex, temp, 0, 0);
		else if(selectedflip == 3)
			draw_sprite_vh_flip(ex, temp, 0, 0);
    }
    //textprintf(ex, font, 0, 0, -1, "%i", roomTiles[selectedroom].tiles[yLocation][xLocation].tileval);
    //textprintf(ex, font, 0, 8, -1, "%i", roomTiles[selectedroom].tiles[yLocation][xLocation].clip);
	destroy_bitmap(temp);
    Windows[RWin("Tiles")]->Selectors[16]->FreeImage();
    Windows[RWin("Tiles")]->Selectors[16]->SetImage(ex);
}
void ProcessTiles(void) {
    if(selectedtile < (tilerow - 1) * 16 + 1 || selectedtile > (tilerow - 1) * 16 + 16) {
        //printf("TILE: %i\n", selectedtile);
        tilerow = ((selectedtile - 1) / 16) + 1;
        for(short i = 0; i < 16; i ++) {
            //printf("%i", (tilerow - 1) * 16 + i);
            if(TileImages[(tilerow - 1) * 16 + i] != NULL) {
                Windows[RWin("Tiles")]->Selectors[i]->Show();
                Windows[RWin("Tiles")]->Selectors[i]->SetImage(TileImages[(tilerow - 1) * 16 + i]);
                Windows[RWin("Tiles")]->Selectors[i]->SetTrigger((tilerow - 1) * 16 + i + 1);
            } else {
                //selectedtile ++;
                //ProcessTiles();
                Windows[RWin("Tiles")]->Selectors[i]->Hide();
            }
        }
    }
    RefreshTilePreview();
}
void ProcessRows(void) {
    if(selectedtile < (tilerow - 1) * 16 + 1) {
        selectedtile = (tilerow - 1) * 16 + (selectedtile % 16 == 0 ? 16 : selectedtile % 16);
    } else if(selectedtile > (tilerow - 1) * 16 + 16) {
        selectedtile = (tilerow - 1) * 16 + (selectedtile % 16 == 0 ? 16 : selectedtile % 16);
    }
    for(short i = 0; i < 16; i ++) {
        if(TileImages[(tilerow - 1) * 16 + i] != NULL) {
                Windows[RWin("Tiles")]->Selectors[i]->Show();
            Windows[RWin("Tiles")]->Selectors[i]->SetImage(TileImages[(tilerow - 1) * 16 + i]);
            Windows[RWin("Tiles")]->Selectors[i]->SetTrigger((tilerow - 1) * 16 + i + 1);
        } else {
            Windows[RWin("Tiles")]->Selectors[i]->Hide();
        }
    }
    RefreshTilePreview();
}

void ProcessClips(void) {
    if(selectedclip < (clippage - 1) * 16 + 1 || selectedclip > (clippage - 1) * 16 + 16) {
        clippage = ((selectedclip - 1) / 16) + 1;
        for(short i = 0; i < 16; i ++) {
            if((clippage - 1) * 16 + i < clipamount) {
                if(ClipImages[(clippage - 1) * 16 + i] != NULL) {
                    Windows[RWin("Clips")]->Selectors[i]->Show();
                    Windows[RWin("Clips")]->Selectors[i]->SetImage(ClipImages[(clippage - 1) * 16 + i]);
                    Windows[RWin("Clips")]->Selectors[i]->SetTrigger((clippage - 1) * 16 + i + 1);
                } else {
                    Windows[RWin("Clips")]->Selectors[i]->Hide();
                }
            }
            else {
                Windows[RWin("Clips")]->Selectors[i]->Hide();
            }
        }
    }
}
void ProcessClipRows(void) {
    if(selectedclip < (clippage - 1) * 16 + 1) {
        selectedclip = (clippage - 1) * 16 + (selectedclip % 16 == 0 ? 16 : selectedclip % 16);
    } else if(selectedclip > (clippage - 1) * 16 + 16) {
        selectedclip = (clippage - 1) * 16 + (selectedclip % 16 == 0 ? 16 : selectedclip % 16);
    }
    selectedclip = selectedclip > clipamount ? clipamount : selectedclip;
    for(short i = 0; i < 16; i ++) {
        if((clippage - 1) * 16 + i < clipamount) {
            if(ClipImages[(clippage - 1) * 16 + i] != NULL) {
                Windows[RWin("Clips")]->Selectors[i]->Show();
                Windows[RWin("Clips")]->Selectors[i]->SetImage(ClipImages[(clippage - 1) * 16 + i]);
                Windows[RWin("Clips")]->Selectors[i]->SetTrigger((clippage - 1) * 16 + i + 1);
            } else {
                Windows[RWin("Clips")]->Selectors[i]->Hide();
            }
        }
        else {
            Windows[RWin("Clips")]->Selectors[i]->Hide();
        }
    }
}
#endif
