
#include "commonheaders.h"
#include "cls-menu.h"
#include "cls-window.h"
#include "initialization.h"
#include "menufunctions.h"
#include "window.h"

void OpenImportDialog(void) {
    OpenWindow(RWin("Import Room"));
    Windows[RWin("Import Room")]->Set_Pos(main_width / 2 - 160, main_height / 2 - 90);
    Windows[RWin("Import Room")]->TextBoxes[0]->StartInput();
    dialogmode = true;
    dialogwindow = RWin("Import Room");
}
void OpenExportDialog(void) {
    OpenWindow(RWin("Export Room"));
    Windows[RWin("Export Room")]->Set_Pos(main_width / 2 - 160, main_height / 2 - 90);
    Windows[RWin("Export Room")]->TextBoxes[0]->StartInput();
    dialogmode = true;
    dialogwindow = RWin("Export Room");
}
void OpenMapEdit(void) {
    if(!Window_is_open(RWin("Map Editor"))) {
        OpenWindow(RWin("Map Editor"));
        if(Window_is_open(RWin("Room Editor"))) {
            CloseWindow(RWin("Room Editor"));
            winRoomEdit = false;
        }
        winMapEdit = true;
    } else {
        CloseWindow(RWin("Map Editor"));
        winMapEdit = false;
    }
}
void CloseMapEdit(void) {
    winMapEdit = false;
}
void OpenOpts(void) {
    if(!Window_is_open(RWin("Options"))) {
        OpenWindow(RWin("Options"));
        winOpts = true;
    } else {
        CloseWindow(RWin("Options"));
        winOpts = false;
    }
}
void CloseOpts(void) {
    winOpts = false;
}

void OpenTiles(void) {
    if(!Window_is_open(RWin("Tiles"))) {
        OpenWindow(RWin("Tiles"));
        winTiles = true;
    } else {
        CloseWindow(RWin("Tiles"));
        winTiles = false;
    }
}
void CloseTiles(void) {
    winTiles = false;
}

void OpenRoomEdit(void) {
    if(roomamount > 0) {
        if(!Window_is_open(RWin("Room Editor"))) {
            OpenWindow(RWin("Room Editor"));
            if(Window_is_open(RWin("Map Editor"))) {
                CloseWindow(RWin("Map Editor"));
                winMapEdit = false;
            }
            winRoomEdit = true;
        } else {
            CloseWindow(RWin("Room Editor"));
            winRoomEdit = false;
        }
    }
}
void CloseRoomEdit(void) {
    winRoomEdit = false;
}

void ViewGrids(void) {
    if(Windows[RWin("Map Editor")]->Viewports[0]->Grid(-1)) {
        Windows[RWin("Map Editor")]->Viewports[0]->Grid(0);
        Windows[RWin("Room Editor")]->Viewports[0]->Grid(0);
        Windows[RWin("Place Imported Room")]->Viewports[0]->Grid(0);
        showgrids = false;
    } else {
        Windows[RWin("Map Editor")]->Viewports[0]->Grid(1);
        Windows[RWin("Room Editor")]->Viewports[0]->Grid(1);
        Windows[RWin("Place Imported Room")]->Viewports[0]->Grid(1);
        showgrids = true;
    }
}
void ViewFades(void) {
    showfades = showfades == true ? false : true;
    Windows[RWin("Room Editor")]->Viewports[0]->Refresh();
}
void ViewClips(void) {
    showclips = showclips == true ? false : true;
    Windows[RWin("Room Editor")]->Viewports[0]->Refresh();
}

void Exit(void) {
    quit = true;
}
void NULLF(void) {;}
void NULLF(char*) {;}
