#include <conio.h>
#include "commonheaders.h"
#include "cls-menu.h"
#include "cls-window.h"
#include "window.h"
#include "menufunctions.h"
#include "winfunctions.h"
#include "initialization.h"
#include "processing.h"

extern int speed_counter;

int main(int argc, char *argv[]) {
    
    Initialize_Allegro();
    
    int arg;
    bool bgshow = false;
    bool bgstretch = false;
    BITMAP *background;
    for (arg = 1; arg < argc; arg++) {
        /*----- Debug Shit -----*/
        if(stricmp(argv[arg], "-debug") == 0) {
            debug = true;
        }
        /*----- Working Background -----*/
        if(stricmp(argv[arg], "-bg") == 0) {
            if(argv[arg + 1] != NULL) {
                background = load_bitmap(argv[arg + 1], NULL);
                if(background != NULL) {
                    bgshow = true;
                }
            }
        }
        /*----- Working Background Stretch -----*/
        if(stricmp(argv[arg], "-bgstretch") == 0) {
            bgstretch = true;
        }
    }
    //unsigned long yoyo = 0;
    //yoyo += 1 << 30;
    printf("struct tile size: %i\n", sizeof(tile));
    
	set_window_title("SMTC Level Editor v0.8");  //Set Window Title
	set_window_close_hook(Exit);
	Initial_Load();
	
	Load_Tiles();
	
	Load_Clips();
    
    WinInit();

    Initialize_Menus();
    
    Initialize_Windows();
    
    while(!quit) {                               //Control Loop
        
        while(speed_counter > 0) {
            if(key[KEY_ESC]) quit = true;
            if(key[KEY_TILDE] && debug) {
                ListWindows();
                readkey();
            }
            if(key[KEY_TILDE]) {
                printf("%i", selectedroom);
            }
            
            if(!dialogmode){
                if(!grab) {
                    if(!(MainMenu->Check())) {
                        PollKeyBuffer();
                        ProcessWindows();
                    }
                } else {
                    ProcessWindows();
                }
            } else {
                PollKeyBuffer();
                ProcessWindows();
            }
            speed_counter --;
        }    
        clear_to_color(buffer, BLACK);
    
        if(bgshow) {
            if(bgstretch) {
                stretch_blit(background, buffer, 0, 0, background->w, background->h, 0, 0, main_width, main_height);
            } else {
                blit(background, buffer, 
                ((main_width - background->w) / 2 < 0 ? abs(main_width - background->w) / 2 : 0), 
                ((main_height - background->h) / 2 < 0 ? abs(main_height - background->h) / 2 : 0),
                ((main_width - background->w) / 2 < 0 ? 0 : (main_width - background->w) / 2),
                ((main_height - background->h) / 2 < 0 ? 0 : (main_height - background->h) / 2),
                main_width, main_height);
            }
        }
        if(!dialogmode){
            DrawWindows(buffer);
            MainMenu->Draw(buffer);
        } else {
            if(frozenbuf == NULL) {
                MainMenu->Draw(buffer);
                DrawWindows(buffer);
                frozenbuf = create_bitmap(main_width, main_height);
                blit(buffer, frozenbuf, 0, 0, 0, 0, main_width, main_height);
            }        
            blit(frozenbuf, buffer, 0, 0, 0, 0, main_width, main_height);
            DrawWindows(buffer);
        }
        draw_sprite(buffer, mouse_spr, mouse_x, mouse_y);
        
        textprintf(buffer, TinyFont, mouse_x + 13, mouse_y + 13, BLACK, "(%3i:%3i)", mouse_x, mouse_y);
        textprintf(buffer, TinyFont, mouse_x + 12, mouse_y + 12, WHITE, "(%3i:%3i)", mouse_x, mouse_y);
        
        acquire_screen();
        
        blit(buffer, screen, 0, 0, 0, 0, main_width, main_height);
        
        release_screen();
    }
    destroy_bitmap(buffer);
    destroy_bitmap(mouse_spr);
    delete(MainMenu);
    delete(Windows);
    free(WindowStack);
    
    allegro_exit();
    
    return(0);
}
END_OF_MAIN();
