#include "commonheaders.h"
#include "cls-menu.h"
#include "initialization.h"
#include "editor.h"

int Load_Tiles(void) {
	if(TileImages != NULL) {
		free(TileImages);
		TileImages = NULL;
	}
    // Load the datafile containing the tile images
    TileFile = load_datafile("Tiles.dat");
    if(TileFile == NULL)
    {
        allegro_message("File Error:\n    'Tiles.dat' could not be found.\n    Please verify its location and version.\n\nAborting Program");
        exit(1);
    }
    else
    {
        //Create an empty black tile
        BITMAP *BlackTile = create_bitmap(16, 16);
        if(BlackTile == NULL) {
			allegro_message("Image Error:\n    Error Number: &T0B\n\nAborting Program");
        	exit(1);
		}
        clear_to_color(BlackTile, 0);
    
        // Check to see if the file was found
        short i = 0;
        tilerow = 1;
        tileamount = 0;
        selectedtile = 1;
        //Read tile images until at the end of the file
        while(TileFile[i + 1].type != DAT_END)
        {
            //Allocate and load the tile
            TileImages = (BITMAP **)qualloc(TileImages, sizeof(BITMAP *) * (i + 1));
            if(TileImages == NULL) {
				allegro_message("Memory Error:\n    Error Number: &T%i\n    Memory could not be allocated for the tiles.\n\nAborting Program", i);
        		exit(1);
			}
            TileImages[i] = (BITMAP *)TileFile[i].dat;
        	if(TileImages[i] == NULL) {
				allegro_message("Loading Error:\n    Error Number: &TI%i\n    A tile could not be loaded from Tiles.dat.\n\nAborting Program", i);
        		exit(1);
			}
            
            // Replace white tiles with black tiles
            short y = 0;
            short x = 0;
            while(y < 15 && _getpixel16(TileImages[i], x, y) == 65535) {
                x = 0;
                while(x < 15 && _getpixel16(TileImages[i], x, y) == 65535) {
                    x++;
                }
                y++;
            }
            if(y == 15 && x == 15) {
                destroy_bitmap(TileImages[i]);
                TileImages[i] = BlackTile;
            }
            
            i ++;
            tileamount ++;
        }
    }
    return(0);
}
