#include "commonheaders.h"
#include "cls-menu.h"
#include "cls-window.h"
#include "initialization.h"
#include "winfunctions.h"
#include "window.h"

int Import_Level(char *levelname) 
{
    FILE *level;
    char *leveldir = NULL;
    char *tempString = NULL;
    
    printf("\nLevel Load:\n\n");
    
    if((levelname[strlen(levelname) - 4] == '.') &&
        (levelname[strlen(levelname) - 3] == 'l') &&
        (levelname[strlen(levelname) - 2] == 'e') &&
        (levelname[strlen(levelname) - 1] == 'v')) 
    {
        printf("NoAdd \"%s\"\n", levelname);
        leveldir = (char*)realloc(leveldir, sizeof(char) * strlen(levelname) + strlen("Levels\\"));
        strcpy(leveldir, "Levels\\");
        strcat(leveldir, levelname);
    } 
    else 
    {
        printf("Add \"%s\" + \".lev\"\n", levelname);
        leveldir = (char*)realloc(leveldir, sizeof(char) * strlen(levelname) + strlen("Levels\\.lev"));
        strcpy(leveldir, "Levels\\");
        strcat(leveldir, levelname);
        strcat(leveldir, ".lev");
    }
    printf("Opening: \"%s\"...", leveldir);
    level = fopen(leveldir, "r+");
    if(level != NULL) 
    {
        printf("Level Opened.\n");
        roomamount ++;
    	roomTiles = (ROOM *)realloc(roomTiles, sizeof(ROOM) * roomamount);
        if((levelname[strlen(levelname) - 4] == '.') &&
            (levelname[strlen(levelname) - 3] == 'l') &&
            (levelname[strlen(levelname) - 2] == 'e') &&
            (levelname[strlen(levelname) - 1] == 'v')) 
        {
            levelname[strlen(levelname) - 4] = '\0';
    	    Windows[RWin("Map Editor")]->ListBoxes[0]->AddItem(levelname);
            Windows[RWin("Room Editor")]->ScrollBoxes[0]->AddItem(levelname);
            levelname[strlen(levelname) - 4] = '.';
        }
        else 
        {
            Windows[RWin("Map Editor")]->ListBoxes[0]->AddItem(levelname);
            Windows[RWin("Room Editor")]->ScrollBoxes[0]->AddItem(levelname);
        }
        printf("Room Amount Increased\n");
    	
    	if(roomTiles == NULL) {
			allegro_message("Memory Error:\n    Memory for the room could not be allocated\n\nAborting Program");
			exit(1);
		}
		
    	roomTiles[roomamount - 1].xSize = 0;
    	roomTiles[roomamount - 1].ySize = 0;
    	roomTiles[roomamount - 1].tiles = NULL;
    	printf("x%i", roomTiles[roomamount - 1].tiles);
    	
    	tempString = (char*)realloc(tempString, sizeof(char) * 20);
        fread(tempString, sizeof(char), 20, level);
        printf("Version: %s\n", tempString);
    	printf("x%i", roomTiles[roomamount - 1].tiles);
        
        if(strcasecmp(tempString, "SMTCLevEdit v0.75a") == 0)
        {
            fclose(level);
            level = fopen(leveldir, "rb+");
            
            int tempInt = 0;
    	    tempString = (char*)realloc(tempString, sizeof(char) * 50);
            fread(tempString, sizeof(char), 50, level);
            
            fread(&tempInt, sizeof(int), 1, level);
            roomTiles[roomamount - 1].xSize = (short)tempInt;
            roomTiles[roomamount - 1].xSize += (roomTiles[roomamount - 1].xSize % 16 > 0 ? 16 - roomTiles[roomamount - 1].xSize % 16 : 0);
            fread(&tempInt, sizeof(int), 1, level);
            roomTiles[roomamount - 1].ySize = (short)tempInt;
            roomTiles[roomamount - 1].ySize += (roomTiles[roomamount - 1].ySize % 12 > 0 ? 12 - roomTiles[roomamount - 1].ySize % 12 : 0);
	        printf("\nDimensions: %ix%i %i\n", roomTiles[roomamount - 1].xSize, roomTiles[roomamount - 1].ySize, roomTiles[roomamount -1].tiles);
            roomTiles[roomamount - 1].tiles = (struct tile **)realloc(roomTiles[roomamount - 1].tiles, sizeof(struct tile *) * roomTiles[roomamount - 1].ySize);
			if(roomTiles[roomamount - 1].tiles == NULL) {
				printf("Memory Error");
				readkey();
				exit(1);
			}
			printf("grrr");
            memset(roomTiles[roomamount - 1].tiles, 0, sizeof(unsigned short *) * roomTiles[roomamount - 1].ySize);
            for(short i = 0; i < roomTiles[roomamount - 1].ySize; i ++)
            {
                roomTiles[roomamount - 1].tiles[i] = (struct tile *)realloc(roomTiles[roomamount - 1].tiles[i], sizeof(struct tile) * roomTiles[roomamount - 1].xSize);
                memset(roomTiles[roomamount - 1].tiles[i], 0, sizeof(struct tile *) * roomTiles[roomamount - 1].xSize);
            }
            printf("rawr\n");
            fread(tempString, sizeof(char), 1 + sizeof(int) * 2, level);
            
            for(short yloop = 0; yloop < roomTiles[roomamount - 1].ySize; yloop++)
            {
                for(short xloop = 0; xloop < roomTiles[roomamount - 1].xSize; xloop++)
                {
					tempInt = 0;
                    fread(&tempInt, sizeof(int), 1, level);
                    if(tempInt > 130000)
                    {
                        printf("ST%i\n", tempInt);
                        tempInt -= 130000;
                        if(tempInt > 40) 
                        {
                            roomTiles[roomamount - 1].tiles[yloop][xloop].fade = 1;
                            tempInt -= 40;
                            printf("F%i\n", tempInt % 10);
                        }
                        roomTiles[roomamount - 1].tiles[yloop][xloop].rotation = tempInt / 10;
                        roomTiles[roomamount - 1].tiles[yloop][xloop].flip = tempInt % 10;
                        fread(&tempInt, sizeof(int), 1, level);
                    }
                    roomTiles[roomamount - 1].tiles[yloop][xloop].tileval = tempInt;
					tempInt = 0;
                    fread(&tempInt, sizeof(short), 1, level);
                    roomTiles[roomamount - 1].tiles[yloop][xloop].clip = tempInt;
                	//printf("%3i,", roomTiles[selectedroom].tiles[yloop][xloop].tileval);
            	}
            	//printf("\n");
            }
            printf("\nDimensions: %ix%i\n", roomTiles[roomamount - 1].xSize, roomTiles[roomamount - 1].ySize);
            CloseWindow(dialogwindow);
            dialogwindow = RWin("Place Imported Room");
            fclose(level);
            
            return(0);
        }
    } 
    else 
    {
        CloseWindow(dialogwindow);
        dialogwindow = RWin("Import Error");
        printf("\nUnable to open level.\n");
    }
    return(1);
}
int Export_Level(char *levelname) 
{
	if(roomamount > 0) {
    FILE *level;
    char *leveldir = NULL;
    char *tempString = NULL;
    
    printf("\nLevel Load:\n\n");
    
    if((levelname[strlen(levelname) - 4] == '.') &&
        (levelname[strlen(levelname) - 3] == 'l') &&
        (levelname[strlen(levelname) - 2] == 'e') &&
        (levelname[strlen(levelname) - 1] == 'v')) 
    {
        printf("NoAdd \"%s\"\n", levelname);
        leveldir = (char*)realloc(leveldir, sizeof(char) * strlen(levelname) + strlen("Levels\\"));
        strcpy(leveldir, "Levels\\");
        strcat(leveldir, levelname);
    } 
    else 
    {
        printf("Add \"%s\" + \".lev\"\n", levelname);
        leveldir = (char*)realloc(leveldir, sizeof(char) * strlen(levelname) + strlen("Levels\\.lev"));
        strcpy(leveldir, "Levels\\");
        strcat(leveldir, levelname);
        strcat(leveldir, ".lev");
    }
    printf("Opening: \"%s\"...", leveldir);
    level = fopen(leveldir, "wb+");
    if(level != NULL) 
    {
        printf("Level Opened.\n");
        
    	tempString = (char*)realloc(tempString, sizeof(char) * 50);
    	memset(tempString, 0, sizeof(char) * 50);
        strcpy(tempString, "SMTCLevEdit v0.75a");
        printf("Version: %s\n", tempString);
        
        fwrite(tempString, sizeof(char), 20, level);
        fwrite(tempString, sizeof(char), 30, level);
            
        fwrite(&roomTiles[selectedroom].xSize, sizeof(int), 1, level);
        fwrite(&roomTiles[selectedroom].ySize, sizeof(int), 1, level);
            
        fwrite(&tempString[0], sizeof(char), 1, level);
        fwrite(&roomTiles[selectedroom].ySize, sizeof(int), 1, level);
        fwrite(&roomTiles[selectedroom].ySize, sizeof(int), 1, level);
        //fseek(level, checker + 1, SEEK_SET);
        
        printf("Dimensions: %ix%i", roomTiles[selectedroom].xSize, roomTiles[selectedroom].ySize);
            
        int tempInt = 0;
        for(short yloop = 0; yloop < roomTiles[selectedroom].ySize; yloop++)
        {
            for(short xloop = 0; xloop < roomTiles[selectedroom].xSize; xloop++)
            {
                tempInt = (int)roomTiles[selectedroom].tiles[yloop][xloop].fade * 40;
                tempInt += (int)roomTiles[selectedroom].tiles[yloop][xloop].rotation * 10;
                tempInt += (int)roomTiles[selectedroom].tiles[yloop][xloop].flip;
                if(tempInt > 0)
                {
                    tempInt += 130000;
                    fwrite(&tempInt, sizeof(int), 1, level);
                }
                tempInt = (int)roomTiles[selectedroom].tiles[yloop][xloop].tileval;
                fwrite(&tempInt, sizeof(int), 1, level);
                tempInt = (int)roomTiles[selectedroom].tiles[yloop][xloop].clip;
                fwrite(&tempInt, sizeof(short), 1, level);
                //printf("%3i,", roomTiles[selectedroom].tiles[yloop][xloop].tileval);
            }
            //printf("\n");
        }
        tempInt = 0;
        for(short i = 0; i < 10; i ++)
        {
            fwrite(&tempInt, sizeof(int), 1, level);
            fwrite(&tempInt, sizeof(int), 1, level);
            fwrite(&tempInt, sizeof(int), 1, level);
            fwrite(&tempInt, sizeof(int), 1, level);
            fwrite(&tempInt, sizeof(int), 1, level);
            fwrite(&tempInt, sizeof(int), 1, level);
            fwrite(&tempInt, sizeof(int), 1, level);
        }
        for(short i = 0; i < 5; i ++)
        {
            fwrite(&tempInt, sizeof(int), 1, level);
            fwrite(&tempInt, sizeof(int), 1, level);
            fwrite(&tempInt, sizeof(int), 1, level);
        }
        for(short i = 0; i < 128; i ++)
        {
            fwrite(&tempInt, sizeof(int), 1, level);
            fwrite(&tempInt, sizeof(int), 1, level);
            fwrite(&tempInt, sizeof(int), 1, level);
            fwrite(&tempInt, sizeof(int), 1, level);
        }
        fwrite(&tempInt, sizeof(int), 1, level);
        fwrite(&tempInt, sizeof(int), 1, level);
        fwrite(&tempInt, sizeof(int), 1, level);
        fwrite(&tempInt, sizeof(int), 1, level);
        fwrite(&tempInt, sizeof(int), 1, level);
        fwrite(&tempInt, sizeof(int), 1, level);
        
        bool tempBool = false;
        tempInt = -1;
        fwrite(&tempBool, sizeof(bool), 1, level);
        fwrite(&tempInt, sizeof(int), 1, level);
        fwrite(&tempInt, sizeof(int), 1, level);
        fwrite(&tempInt, sizeof(int), 1, level);
        fwrite(&tempInt, sizeof(int), 1, level);
        fwrite(&tempInt, sizeof(int), 1, level);
        
        for(short i = 0; i < 15; i ++)
        {
            fwrite(&tempInt, sizeof(int), 1, level);
        }
        ExitDialog();
        fclose(level);
        
        return(0);
    }
    else
    {
        CloseWindow(dialogwindow);
        dialogwindow = RWin("Export Error");
        printf("\nUnable to open level.\n");
        printf("\nUnable to open level.\n");
    }
	}
    return(1);
}
