#include "commonheaders.h"
#include "cls-menu.h"
#include "initialization.h"
#include "editor.h"
    
void Initial_Load(void) {
    // Load the datafile conataining interface images
    Editor = load_datafile("Editor.dat");
    if(Editor == NULL)
    {
        allegro_message("File Error:\n    'Editor.dat' could not be found.\n    Please verify its location and version.\n\nAborting Program.");
        exit(1);
    }
    else
    {
    	mouse_spr = (BITMAP *)Editor[MOUSE].dat;
    	if(mouse_spr == NULL) {
			allegro_message("Loading Error:\n    The mouse sprite could not be loaded from 'Editor.dat'\n\nAborting Program.");
        	exit(1);
		}
    	Delete = (BITMAP *)Editor[DELETE].dat;
    	if(Delete == NULL) {
			allegro_message("Loading Error:\n    The deletion sprite could not be loaded from 'Editor.dat'\n\nAborting Program.");
        	exit(1);
		}
    	BoxCheck = (BITMAP *)Editor[BOXCHECK].dat;
    	if(BoxCheck == NULL) {
			allegro_message("Loading Error:\n    The checkbox sprite could not be loaded from 'Editor.dat'\n\nAborting Program.");
        	exit(1);
		}
    	checkmark = (BITMAP *)Editor[CHECKMARK].dat;
    	if(checkmark == NULL) {
			allegro_message("Loading Error:\n    The checkmark sprite could not be loaded from 'Editor.dat'\n\nAborting Program.");
        	exit(1);
		}
        WinClose = (BITMAP *)Editor[WINCLOSE].dat;
    	if(WinClose == NULL) {
			allegro_message("Loading Error:\n    The close button sprite could not be loaded from 'Editor.dat'\n\nAborting Program.");
        	exit(1);
		}
        WinClosePush = (BITMAP *)Editor[WINCLOSEPUSH].dat;
    	if(WinClosePush == NULL) {
			allegro_message("Loading Error:\n    The close button sprite could not be loaded from 'Editor.dat'\n\nAborting Program.");
        	exit(1);
		}
        WinShade = (BITMAP *)Editor[WINSHADE].dat;
    	if(WinShade == NULL) {
			allegro_message("Loading Error:\n    The shade button sprite could not be loaded from 'Editor.dat'\n\nAborting Program.");
        	exit(1);
		}
        WinShadePush = (BITMAP *)Editor[WINSHADEPUSH].dat;
    	if(WinShadePush == NULL) {
			allegro_message("Loading Error:\n    The shade button sprite could not be loaded from 'Editor.dat'\n\nAborting Program.");
        	exit(1);
		}
        WinRestore = (BITMAP *)Editor[WINRESTORE].dat;
    	if(WinRestore == NULL) {
			allegro_message("Loading Error:\n    The restore button sprite could not be loaded from 'Editor.dat'\n\nAborting Program.");
        	exit(1);
		}
        WinRestorePush = (BITMAP *)Editor[WINRESTOREPUSH].dat;
    	if(WinRestorePush == NULL) {
			allegro_message("Loading Error:\n    The restore button sprite could not be loaded from 'Editor.dat'\n\nAborting Program.");
        	exit(1);
		}
        Slider = (BITMAP *)Editor[SLIDERIMG].dat;
    	if(Slider == NULL) {
			allegro_message("Loading Error:\n    The slider sprite could not be loaded from 'Editor.dat'\n\nAborting Program.");
        	exit(1);
		}
        SliderEnd = (BITMAP *)Editor[SCROLLEND].dat;
    	if(SliderEnd == NULL) {
			allegro_message("Loading Error:\n    The slider arrow sprite could not be loaded from 'Editor.dat'\n\nAborting Program.");
        	exit(1);
		}
        SliderPush = (BITMAP *)Editor[SCROLLENDPUSH].dat;
    	if(SliderPush == NULL) {
			allegro_message("Loading Error:\n    The slider arrow sprite could not be loaded from 'Editor.dat'\n\nAborting Program.");
        	exit(1);
		}
        Arrow = (BITMAP *)Editor[ARROW].dat;
    	if(Arrow == NULL) {
			allegro_message("Loading Error:\n    The arrow sprite could not be loaded from 'Editor.dat'\n\nAborting Program.");
        	exit(1);
		}
        ScrollArrow = (BITMAP *)Editor[SCROLLARROW].dat;
    	if(ScrollArrow == NULL) {
			allegro_message("Loading Error:\n    The scroll arrow sprite could not be loaded from 'Editor.dat'\n\nAborting Program.");
        	exit(1);
		}
        ScrollArrowPush = (BITMAP *)Editor[SCROLLARROWPUSH].dat;
    	if(ScrollArrowPush == NULL) {
			allegro_message("Loading Error:\n    The scroll arrow sprite could not be loaded from 'Editor.dat'\n\nAborting Program.");
        	exit(1);
		}
        ScrollDown = (BITMAP *)Editor[DOWNARROW].dat;
    	if(ScrollDown == NULL) {
			allegro_message("Loading Error:\n    The drop sprite could not be loaded from 'Editor.dat'\n\nAborting Program.");
        	exit(1);
		}
        ListUp = (BITMAP *)Editor[LISTUP].dat;
    	if(ListUp == NULL) {
			allegro_message("Loading Error:\n    The listbox arrow sprite could not be loaded from 'Editor.dat'\n\nAborting Program.");
        	exit(1);
		}
        ListUpPush = (BITMAP *)Editor[LISTUPPUSH].dat;
    	if(ListUpPush == NULL) {
			allegro_message("Loading Error:\n    The listbox arrow sprite could not be loaded from 'Editor.dat'\n\nAborting Program.");
        	exit(1);
		}
        ListDn = (BITMAP *)Editor[LISTDN].dat;
    	if(ListDn == NULL) {
			allegro_message("Loading Error:\n    The listbox arrow sprite could not be loaded from 'Editor.dat'\n\nAborting Program.");
        	exit(1);
		}
        ListDnPush = (BITMAP *)Editor[LISTDNPUSH].dat;
    	if(ListDnPush == NULL) {
			allegro_message("Loading Error:\n    The listbox arrow sprite could not be loaded from 'Editor.dat'\n\nAborting Program.");
        	exit(1);
		}
        
        ViewU = (BITMAP *)Editor[VIEWU].dat;
    	if(ViewU == NULL) {
			allegro_message("Loading Error:\n    The viewport arrow sprite could not be loaded from 'Editor.dat'\n\nAborting Program.");
        	exit(1);
		}
        ViewUP = (BITMAP *)Editor[VIEWUP].dat;
    	if(ViewUP == NULL) {
			allegro_message("Loading Error:\n    The viewport arrow sprite could not be loaded from 'Editor.dat'\n\nAborting Program.");
        	exit(1);
		}
        ViewD = (BITMAP *)Editor[VIEWD].dat;
    	if(ViewD == NULL) {
			allegro_message("Loading Error:\n    The viewport arrow sprite could not be loaded from 'Editor.dat'\n\nAborting Program.");
        	exit(1);
		}
        ViewDP = (BITMAP *)Editor[VIEWDP].dat;
    	if(ViewDP == NULL) {
			allegro_message("Loading Error:\n    The viewport arrow sprite could not be loaded from 'Editor.dat'\n\nAborting Program.");
        	exit(1);
		}
        ViewR = (BITMAP *)Editor[VIEWR].dat;
    	if(ViewR == NULL) {
			allegro_message("Loading Error:\n    The viewport arrow sprite could not be loaded from 'Editor.dat'\n\nAborting Program.");
        	exit(1);
		}
        ViewRP = (BITMAP *)Editor[VIEWRP].dat;
    	if(ViewRP == NULL) {
			allegro_message("Loading Error:\n    The viewport arrow sprite could not be loaded from 'Editor.dat'\n\nAborting Program.");
        	exit(1);
		}
        ViewL = (BITMAP *)Editor[VIEWL].dat;
    	if(ViewL == NULL) {
			allegro_message("Loading Error:\n    The viewport arrow sprite could not be loaded from 'Editor.dat'\n\nAborting Program.");
        	exit(1);
		}
        ViewLP = (BITMAP *)Editor[VIEWLP].dat;
    	if(ViewLP == NULL) {
			allegro_message("Loading Error:\n    The viewport arrow sprite could not be loaded from 'Editor.dat'\n\nAborting Program.");
        	exit(1);
		}
        
        MapBox = (BITMAP *)Editor[BOX].dat;
    	if(MapBox == NULL) {
			allegro_message("Loading Error:\n    The map box sprite could not be loaded from 'Editor.dat'\n\nAborting Program.");
        	exit(1);
		}
        MapItem = (BITMAP *)Editor[ITEM].dat;
    	if(MapItem == NULL) {
			allegro_message("Loading Error:\n    The map item sprite could not be loaded from 'Editor.dat'\n\nAborting Program.");
        	exit(1);
		}
        MapSlice1 = (BITMAP *)Editor[SLICE].dat;
    	if(MapSlice1 == NULL) {
			allegro_message("Loading Error:\n    The map slice sprite could not be loaded from 'Editor.dat'\n\nAborting Program.");
        	exit(1);
		}
        MapSlice2 = (BITMAP *)Editor[SLICE2].dat;
    	if(MapSlice2 == NULL) {
			allegro_message("Loading Error:\n    The map slice sprite could not be loaded from 'Editor.dat'\n\nAborting Program.");
        	exit(1);
		}
        MapSlice3 = (BITMAP *)Editor[SLICE3].dat;
    	if(MapSlice3 == NULL) {
			allegro_message("Loading Error:\n    The map slice sprite could not be loaded from 'Editor.dat'\n\nAborting Program.");
        	exit(1);
		}
        MapSlice4 = (BITMAP *)Editor[SLICE4].dat;
    	if(MapSlice4 == NULL) {
			allegro_message("Loading Error:\n    The map slice sprite could not be loaded from 'Editor.dat'\n\nAborting Program.");
        	exit(1);
		}
        MapElevator = (BITMAP *)Editor[ELEVATOR].dat;
    	if(MapElevator == NULL) {
			allegro_message("Loading Error:\n    The map elevator sprite could not be loaded from 'Editor.dat'\n\nAborting Program.");
        	exit(1);
		}
        MapDStretch = (BITMAP *)Editor[STRETCH].dat;
    	if(MapDStretch == NULL) {
			allegro_message("Loading Error:\n    The map stretch sprite could not be loaded from 'Editor.dat'\n\nAborting Program.");
        	exit(1);
		}
        MapBStretch = (BITMAP *)Editor[BOXSTRETCH].dat;
    	if(MapBStretch == NULL) {
			allegro_message("Loading Error:\n    The map stretch sprite could not be loaded from 'Editor.dat'\n\nAborting Program.");
        	exit(1);
		}
    }

    Fonts = load_datafile("Fonts.dat");
	if(Fonts == NULL)
    {
        allegro_message("File Error:\n    'Fonts.dat' could not be found.\n    Please verify its location and version.\n\nAborting Program");
        exit(1);
    }
	TinyFont = (FONT *)Fonts[0].dat;
    if(TinyFont == NULL) {
		allegro_message("Loading Error:\n    The small font could not be loaded from 'Fonts.dat'\n\nAborting Program.");
    	exit(1);
	}
}
