#include "commonheaders.h"
#include "cls-menu.h"
#include "initialization.h"
#include "olddata.h"

/////////////////////
// CUSTOM CLIPPING //
////////////////////////////////////////////////////////////////////////////////
BITMAP* custom_clip(int customnumber)
{
    FILE *file;
    char pathset[8];
    char fullpath[64];
    char clipval[18];
    char charnum[8];
    
    strclr(fullpath);
    strclr(charnum);
    strcat(fullpath, "Custom\\");
    strcat(fullpath, "clip");
    itoa(customnumber - 11, charnum, 10);
    strcat(fullpath, charnum);
    strcat(fullpath, ".clp");
    
    printf("Clip: %s\n", fullpath);
    if((file = fopen(fullpath, "r")) == NULL)
    {
        return NULL;
    }
    else
    {
        BITMAP * temp = create_bitmap(16, 16);
        if(temp == NULL) {
			allegro_message("Image Error:\n    Error Number: &C0T\n\nAborting Program");
        	exit(1);
		}
        clear_to_color(temp, makecol(255,0,255));
        for(short yloop = 0; yloop < 16; yloop ++)
        {
            fgets(clipval, sizeof(char) * 18, file);
            for(short xloop = 0; xloop < 16; xloop ++)
            {
                if(clipval[xloop] == 49)
                    _putpixel16(temp, xloop, yloop, makecol(128, 0, 128));
            }
        }
	    fclose(file);
	    return temp;
    }
}
int Load_Clips(void) {
	short i = 14;
	if(ClipImages != NULL) {
		free(ClipImages);
		ClipImages = NULL;
	}
	ClipImages = (BITMAP **)qualloc(ClipImages, sizeof(BITMAP *) * (i + 1));
    if(ClipImages == NULL) {
		allegro_message("Memory Error:\n    Error Number: &CAA\n    Memory could not be allocated for the clipping.\n\nAborting Program");
    	exit(1);
	}
	
    DATAFILE *OldData = load_datafile("OldData.dat");  //Load the Editor Datafile
    if(OldData == NULL)
    {
        allegro_message("File Error:\n    'OldData.dat' could not be found.\n    Please verify its location and version.\n\nAborting Program");
        exit(1);
    }
    ClipImages[0] = create_bitmap(16, 16);
    if(ClipImages[0] == NULL) {
		allegro_message("Image Error:\n    Error Number: &CC0\n\nAborting Program");
    	exit(1);
	}
    clear_to_color(ClipImages[0], makecol(255, 0, 255));
    ClipImages[1] = create_bitmap(16, 16);
    if(ClipImages[1] == NULL) {
		allegro_message("Image Error:\n    Error Number: &CC1\n\nAborting Program");
    	exit(1);
	}
    clear_to_color(ClipImages[1], makecol(128, 0, 128));
    ClipImages[2]  = (BITMAP *)OldData[ClipSlpelr].dat;
    if(ClipImages[2] == NULL) {
		allegro_message("Loading Error:\n    Error Number: &CL2\n    A clip could not be loaded from OldData.dat.\n\nAborting Program");
    	exit(1);
	}
	ClipImages[3]  = (BITMAP *)OldData[ClipSlpell].dat;
    if(ClipImages[3] == NULL) {
		allegro_message("Loading Error:\n    Error Number: &CL3\n    A clip could not be loaded from OldData.dat.\n\nAborting Program");
    	exit(1);
	}
	ClipImages[4]  = (BITMAP *)OldData[ClipSlpetr].dat;
    if(ClipImages[4] == NULL) {
		allegro_message("Loading Error:\n    Error Number: &CL4\n    A clip could not be loaded from OldData.dat.\n\nAborting Program");
    	exit(1);
	}
	ClipImages[5]  = (BITMAP *)OldData[ClipSlpetl].dat;
    if(ClipImages[5] == NULL) {
		allegro_message("Loading Error:\n    Error Number: &CL5\n    A clip could not be loaded from OldData.dat.\n\nAborting Program");
    	exit(1);
	}
	ClipImages[6]  = (BITMAP *)OldData[ClipHalft].dat;
    if(ClipImages[6] == NULL) {
		allegro_message("Loading Error:\n    Error Number: &CL6\n    A clip could not be loaded from OldData.dat.\n\nAborting Program");
    	exit(1);
	}
	ClipImages[7]  = (BITMAP *)OldData[ClipHalfb].dat;
    if(ClipImages[7] == NULL) {
		allegro_message("Loading Error:\n    Error Number: &CL7\n    A clip could not be loaded from OldData.dat.\n\nAborting Program");
    	exit(1);
	}
	ClipImages[8]  = (BITMAP *)OldData[ClipHalfr].dat;
    if(ClipImages[8] == NULL) {
		allegro_message("Loading Error:\n    Error Number: &CL8\n    A clip could not be loaded from OldData.dat.\n\nAborting Program");
    	exit(1);
	}
	ClipImages[9]  = (BITMAP *)OldData[ClipHalfl].dat;
    if(ClipImages[9] == NULL) {
		allegro_message("Loading Error:\n    Error Number: &CL9\n    A clip could not be loaded from OldData.dat.\n\nAborting Program");
    	exit(1);
	}
	ClipImages[10] = (BITMAP *)OldData[ClipQuartl].dat;
    if(ClipImages[10] == NULL) {
		allegro_message("Loading Error:\n    Error Number: &CL10\n    A clip could not be loaded from OldData.dat.\n\nAborting Program");
    	exit(1);
	}
	ClipImages[11] = (BITMAP *)OldData[ClipQuarll].dat;
    if(ClipImages[11] == NULL) {
		allegro_message("Loading Error:\n    Error Number: &CL11\n    A clip could not be loaded from OldData.dat.\n\nAborting Program");
    	exit(1);
	}
	ClipImages[12] = (BITMAP *)OldData[ClipQuartr].dat;
    if(ClipImages[12] == NULL) {
		allegro_message("Loading Error:\n    Error Number: &CL12\n    A clip could not be loaded from OldData.dat.\n\nAborting Program");
    	exit(1);
	}
	ClipImages[13] = (BITMAP *)OldData[ClipQuarlr].dat;
    if(ClipImages[13] == NULL) {
		allegro_message("Loading Error:\n    Error Number: &CL13\n    A clip could not be loaded from OldData.dat.\n\nAborting Program");
    	exit(1);
	}
    
	while((ClipImages[i] = custom_clip(i)) != NULL) {
		i ++;
	}
	clipamount = i;
	printf("Loaded %i Clips\n", clipamount);
}
