
#include "commonheaders.h"
#include "cls-menu.h"
#include "cls-window.h"
#include "initialization.h"
#include "menufunctions.h"
#include "window.h"

Menu *MainMenu = NULL;

void Initialize_Menus(void) {
    
    MainMenu = new Menu;
    if(MainMenu == NULL) {
		allegro_message("Memory Error:\n    Error Number: &M0M\n    Memory could not be allocated for the menus.\n\nAborting Program");
        exit(1);
	}
    
    MainMenu->AddDir("File");
    MainMenu->AddItem("#New", NULLF);
    MainMenu->AddItem("#Load...", NULLF);
    MainMenu->AddItem("&sep", NULLF);
    MainMenu->AddItem("#Save", NULLF);
    MainMenu->AddItem("#Save As...", NULLF);
    MainMenu->AddItem("&sep", NULLF);
    MainMenu->AddItem("Import Room...", OpenImportDialog);
    MainMenu->AddItem("Export Room...", OpenExportDialog);
    MainMenu->AddItem("&sep", NULLF);
    MainMenu->AddItem("Exit", Exit);
    MainMenu->AddDir("Edit");
    MainMenu->AddItem("#Cut", NULLF);
    MainMenu->AddItem("#Copy", NULLF);
    MainMenu->AddItem("#Paste", NULLF);
    MainMenu->AddItem("&sep", NULLF);
    MainMenu->AddItem("#Clear", NULLF);
    MainMenu->AddDir("Display");
    MainMenu->AddItem("Grid Lines", ViewGrids);
    MainMenu->Flagged(false, &showgrids);
    MainMenu->AddItem("Fading Tile Transparency", ViewFades);
    MainMenu->Flagged(false, &showfades);
    MainMenu->AddItem("#Camera Bounds", NULLF);
    MainMenu->Flagged(false, NULL);
    MainMenu->AddItem("#Door Highlights", NULLF);
    MainMenu->Flagged(false, NULL);
    MainMenu->AddItem("Clipping", ViewClips);
    MainMenu->Flagged(false, &showclips);
    MainMenu->AddItem("#Water Levels", NULLF);
    MainMenu->Flagged(true, NULL);
    MainMenu->AddDir("Windows");
    MainMenu->AddItem("Map Editor", OpenMapEdit);
    MainMenu->Flagged(true, &winMapEdit);
    MainMenu->AddItem("Room Editor", OpenRoomEdit);
    MainMenu->Flagged(false, &winRoomEdit);
    MainMenu->AddItem("Tiles", OpenTiles);
    MainMenu->Flagged(false, &winTiles);
    MainMenu->AddItem("Options", OpenOpts);
    MainMenu->Flagged(true, &winOpts);
    
}
