#include "commonheaders.h"
#include "cls-menu.h"
#include "initialization.h"

int speed_counter;
void increment_speed_counter() {
    speed_counter++;
}
END_OF_FUNCTION(increment_speed_counter);

void Initialize_Allegro(void) {
    allegro_init();
    install_mouse();                          //Initialize Mouse routines
    install_timer();                          //Initialize Timer routines
    install_keyboard();                       //Initialize Keyboard routines

    set_keyboard_rate(0,0);                   //Set Keyboard Repeat Rate
    set_volume_per_voice(0);
    install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL);
    
    /*----- Set the graphics mode and colour depth -----*/
    set_color_depth(16);
    Set_Screen();
    
    LOCK_VARIABLE(speed_counter);             //Used to set the timer - which
    LOCK_FUNCTION(increment_speed_counter);   //regulates the game's speed.

    install_int_ex(increment_speed_counter, BPS_TO_TIMER(120)); //Set the BPS
    
    text_mode(-1);
    
    set_display_switch_mode(SWITCH_BACKAMNESIA);
    
}
