#include "commonheaders.h"
#include "cls-window.h"
#include "window.h"
#include "processing.h"
#include "winfunctions.h"

short tempX = -1;
short tempY = -1;

void ImportPlace(short xLocation, short yLocation) {
    if(yLocation >= 0 && xLocation >= 0){
        if(yLocation + (roomTiles[roomamount - 1].ySize / 12) <= MapYSize && xLocation + (roomTiles[roomamount - 1].xSize / 16) <= MapXSize){
            for(short y = yLocation; y < yLocation + (roomTiles[roomamount - 1].ySize / 12); y ++) {
                for(short x = xLocation; x < xLocation + (roomTiles[roomamount - 1].xSize / 16); x ++) {
                    
					MapGrid[y][x] = roomamount;
                    MapSpec[y][x] = 0;
                }
            }
            
            Windows[RWin("Map Editor")]->Viewports[0]->Refresh();
            destroy_bitmap(frozenbuf);
            frozenbuf = NULL;
            CloseWindow(dialogwindow);
            dialogmode = false;
            dialogwindow = 0;
            printf("\nDimensions: %ix%i\n", roomTiles[roomamount - 1].xSize, roomTiles[roomamount - 1].ySize);
            
            if(Window_is_open(RWin("Room Editor"))) {
                EditRoom();
            }
        }
    }
}

void ImportHover(short xLocation, short yLocation) {
	tempX = xLocation;
	tempY = yLocation;
}

void ImportDraw(BITMAP *output, short gridSize) {
    if(tempX > -1 && tempY > -1) {
    short y = Windows[RWin("Place Imported Room")]->Viewports[0]->yScroll;
    short x = Windows[RWin("Place Imported Room")]->Viewports[0]->xScroll;
	BITMAP *temp = create_bitmap(roomTiles[roomamount - 1].xSize / 16 * gridSize, (roomTiles[roomamount - 1].ySize / 12) * gridSize);
	rectfill(temp, 0, 0, temp->w, temp->h, makecol(216, 56, 144));
	rect(temp, 0, 0, temp->w - 1, temp->h - 1, makecol(248, 248, 248));
	rect(temp, 1, 1, temp->w - 2, temp->h - 2, makecol(248, 248, 248));
	if(mouse_b & 1)
		set_trans_blender(0,0,0,255);
	else
		set_trans_blender(0,0,0,128);
	draw_trans_sprite(output, temp, (tempX - x) * gridSize + 1, (tempY - y) * gridSize + 1);
	destroy_bitmap(temp);
    }
}

