#include "commonheaders.h"
#include "ctype.h"

bool mouse_inarea(short window_lft_pos, short window_top_pos, short window_width, short window_height) {
    if(window_width < 1) window_width = 1;
    if(window_height < 1) window_height = 1;
    
    if(mouse_x >= window_lft_pos && mouse_x <= window_lft_pos + window_width) {
        if(mouse_y >= window_top_pos && mouse_y <= window_top_pos + window_height) {
            return(true);
        }
    }
    return(false);
}

char * strclr(char *string) {
    if(string != NULL) {
        short i;
        for(i = strlen(string); i > -1; i --) {
            string[i] = '\0';
        }
    }
}
void GetInputFromBuffer (char *outstring, char position, short type) {
    if(inputbuffer != '\0') {
        if(inputbuffer == 63) {
            if(outstring[position] != '\0') {
                outstring[position] = '\0';
            } else {
                outstring[position - 1] = '\0';
            }
            inputbuffer = '\0';
            lastinput = 63;
        } else if(inputbuffer == 75) {
            outstring[position] = 32;
            inputbuffer = '\0';
            lastinput = 75;
        } else {
            if(type != 0 || (type == 0 && inputbuffer >= 48 && inputbuffer < 58)) {
                if(position != 0 || inputbuffer > 48) {
                    outstring[position] = inputbuffer;
                }
            }
            lastinput = inputbuffer;
            if(lastinput >= 48 && lastinput < 58) lastinput -= 21;
            if(lastinput >= 65 && lastinput < 91) lastinput -= 64;
            if(lastinput >= 97 && lastinput < 123) lastinput -= 96;
            inputbuffer = '\0';
        }
    }
}
void PollKeyBuffer() {
    short i = 1;
    if(!key[lastinput]) {
        lastinput = '\0';
    }
    //NUMPAD STUFF
    /*if(lastinput > 26 && lastinput <= 36) {
        if(!key[lastinput + 10]) {
            lastinput = '\0';
        }
    }*/
    while(!key[i] && i <= 46) {
        i ++;
    }
    if(i > 46) {
        //NOTE: figure out enter key
        if(key[KEY_SPACE] && lastinput != 75) {
            inputbuffer = 75;
        }
        if(key[KEY_BACKSPACE] && lastinput != 63) {
            inputbuffer = 63;
        }
    } else {
        if(i != lastinput) {
            if(i <= 26) {
                inputbuffer = i + 96;
            } else if(i <= 36) {
                inputbuffer = i + 21;
            } 
            //NUMPAD STUFF
            /*else if(i <= 46) {
                inputbuffer = i + 11;
            }*/
        }
        if(key[KEY_LSHIFT] || key[KEY_RSHIFT]) {
            inputbuffer -= 32;
        }
    }
    if(inputbuffer < 0) inputbuffer = '\0';
}
/* //Salty's String Code
char *Get_String(char **ptr, int num)
{
    char string[32];// = (char *)malloc(1);
    int i = 0;
    while((*ptr) + i != NULL && i < 5)
    {
        string[i] = (char)((*ptr) + i);
        printf("%c\n", ((char)((*ptr) + i));
        i ++;
        //string = (char *)realloc(string, i);
    }
    printf("%s\n", string);
    readkey();
    return string;
}*/

void Init_String(char *string, char text[], int len)
{
    if(!len) len = strlen(string);
    for(int l = 0; l < len; l ++) string[l] = 0;

    if(strlen(text)) strcat(string, text);
}

void draw_hbar_gradient(BITMAP *dest, int x, int y, int w, int h, int col1, int col2){
    int r1, r2, g1, g2, b1, b2, i, col3;
    float r_grad, b_grad, g_grad;
    r1 = getr(col1);
    r2 = getr(col2);
    g1 = getg(col1);
    g2 = getg(col2);
    b1 = getb(col1);
    b2 = getb(col2);
    r_grad = ((r1 - r2) / (float)h);
    b_grad = ((b1 - b2) / (float)h);
    g_grad = ((g1 - g2) / (float)h);
    for(i = 0; i < h; i++){
        col3 = makecol((int)(r1 - (i * r_grad)), (int)(g1 - (i * g_grad)), (int)(b1 - (i * b_grad)));
        hline(dest, x, y + i, x + w, col3);
    }
}
void draw_vbar_gradient(BITMAP *dest, int x, int y, int w, int h, int col1, int col2){
    int r1, r2, g1, g2, b1, b2, i, col3;
    float r_grad, b_grad, g_grad;
    r1 = getr(col1);
    r2 = getr(col2);
    g1 = getg(col1);
    g2 = getg(col2);
    b1 = getb(col1);
    b2 = getb(col2);
    r_grad = ((r1 - r2) / (float)w);
    b_grad = ((b1 - b2) / (float)w);
    g_grad = ((g1 - g2) / (float)w);
    for(i = 0; i < w; i++){
        col3 = makecol((int)(r1 - (i * r_grad)), (int)(g1 - (i * g_grad)), (int)(b1 - (i * b_grad)));
        vline(dest, x + i, y, y + h, col3);
    }
}
void draw_diag_gradient(BITMAP *dest, int x, int y, int w, int h, int col1, int col2){
    int r1, r2, g1, g2, b1, b2, i, col3;
    float r_gradx, b_gradx, g_gradx;
    float r_grady, b_grady, g_grady;
    r1 = getr(col1);
    r2 = getr(col2);
    g1 = getg(col1);
    g2 = getg(col2);
    b1 = getb(col1);
    b2 = getb(col2);
    r_gradx = ((r1 - r2) / (float)w) / 2;
    b_gradx = ((b1 - b2) / (float)w) / 2;
    g_gradx = ((g1 - g2) / (float)w) / 2;
    r_grady = ((r1 - r2) / (float)h) / 2;
    b_grady = ((b1 - b2) / (float)h) / 2;
    g_grady = ((g1 - g2) / (float)h) / 2;
    for(i = 0; i < w; i++){
        col3 = makecol((int)(r1 - (i * r_gradx)), (int)(g1 - (i * g_gradx)), (int)(b1 - (i * b_gradx)));
        _putpixel16(dest, x + i, y, col3);
    }
    for(i = w; i < w * 2; i++){
        col3 = makecol((int)(r1 - (i * r_gradx)), (int)(g1 - (i * g_gradx)), (int)(b1 - (i * b_gradx)));
        _putpixel16(dest, x - w + i, y + h, col3);
    }
    for(i = 0; i < h; i++){
        col3 = makecol((int)(r1 - (i * r_grady)), (int)(g1 - (i * g_grady)), (int)(b1 - (i * b_grady)));
        _putpixel16(dest, x, y + i, col3);
    }
    for(i = h; i < h * 2; i++){
        col3 = makecol((int)(r1 - (i * r_grady)), (int)(g1 - (i * g_grady)), (int)(b1 - (i * b_grady)));
        _putpixel16(dest, x + w, y - h + i, col3);
    }
    _putpixel16(dest, x + w, y + h, col2);
}

void *qualloc(void *pnt, int size)
{
    if(pnt == NULL) 
    {
        return malloc(size);
    }
    else 
    {
        return realloc(pnt, size);
    }
    return NULL;
}
void *qualloc(void *pnt, int size, int size2)
{
    if(pnt == NULL)
        return calloc(size2, size);
    else
        return realloc(pnt, size * size2);
    return NULL;
}

void PrintLoc()
{
    printf("%i\n", ploc);
    ploc ++;
    readkey();
}

void quexit(int error)
{
    printf("\n\nOMG EXITING ERROR %i", error);
    readkey();
    exit(error);
}
