/*______________________________________________________________________________
================================================================= Header Files =
____________________________________________
    Notes:                                  \___________________________________
    
    The collection of the header files that are required in the program that 
    contain commonly used functions, data structures, global variables and other
    routines.
______________________________________________________________________________*/
#include <math.h>
#include <stdio.h>                        //Standard Input/Output Functions
#include <string.h>                       //String Variable Functions
#include <stdlib.h>                       //Standard Library Funtctions
#include <allegro.h>                      //Allegro Header File
#include <cstdarg>
/*______________________________________________________________________________
================================================================== Definitions =
____________________________________________
    Notes:                                  \___________________________________
    
    Definitions act as substitutes for statements or numbers.  They are included
    in preprocessor memory and are constant for duration of the program.
______________________________________________________________________________*/
#define WIN_WIDTH 512
#define WIN_HEIGHT 384
#define WIN_COLOUR makecol(192,192,200)
#define WIN_COLOUR2 makecol(128,128,136)
#define WIN_COLOUR3 makecol(96,96,100)
#define WIN_COLOUR4 makecol(64,64,68)

#define WHITE makecol(255,255,255)
#define BLACK makecol(000,000,000)

#define DLGNewRoom 3
//#pragma once                              //Have the compiler parse the headers
                                          // only once when included in multiple
                                          // source files

struct tile {
    unsigned flip:2;
    unsigned rotation:2;
    unsigned foreground:1;
    unsigned fade:1;
    unsigned clip:10;
    unsigned tileval:16;
};
struct breakable {
	short x;
	short y;
	tile tileval;
	unsigned dir:4;
	unsigned type:12;
	char timer;
};
struct door {
	bool active;
	short xPos;
	short yPos;
	unsigned direction:2;
	char levelname[30];
	/*short areadrop;
	short roomdrop;*/
	short doordrop;
};
typedef struct ROOM {
    int xSize;
    int ySize;
    int dooramount;
    int break_amount;
    
    char water_type;
    int water_high;
    int water_low;
    
    int tune_in;
    int tune_out;
    
    char *name;
    char *tune;
    
    struct tile **tiles;
    struct door *doors;
    struct breakable *breaks;
};
/*______________________________________________________________________________
============================================================= Global Variables =
____________________________________________
    Notes:                                  \___________________________________
    
    This is a list of the global variables used in the program.  The definitions
    are kept in the gbl-variables.cpp source file.
______________________________________________________________________________*/

extern char**DogList;

extern bool quit;
extern bool grab;
extern bool debug;
extern bool typing;
extern bool winOpts;
extern bool winTiles;
extern bool winMapEdit;
extern bool winRoomEdit;
extern bool typepress;
extern bool showgrids;
extern bool showclips;
extern bool showfades;
extern bool dialogmode;
extern bool dialogmenu;

extern short main_size;
extern short main_width;
extern short main_height;
extern bool fullscreen;

extern short dialogwindow;

extern char *typeval;
extern char inputbuffer;
extern char lastinput;

extern ROOM *roomTiles;
extern bool transitional;
extern bool foreground;
extern short selectedrot;
extern short selectedflip;
extern short selectedclip;
extern short selectedtile;
extern short tileamount;
extern short tilerow;
extern short clipamount;
extern short clippage;

extern short selectedroom;
extern short roomamount;
extern short roomtype;

extern bool stchhold;
extern bool stchpress;
extern short stchNum;
extern short stchxPos;
extern short stchyPos;
extern short stchxEnd;
extern short stchyEnd;

extern short MapXSize;
extern short MapYSize;
extern unsigned short **MapGrid;
extern unsigned short **MapSpec;

extern BITMAP *buffer;
extern BITMAP *frozenbuf;
extern BITMAP *mouse_spr;

extern BITMAP *checkmark;
extern BITMAP *BoxCheck;
extern BITMAP *Delete;
extern BITMAP *WinClose;
extern BITMAP *WinClosePush;
extern BITMAP *WinShade;
extern BITMAP *WinShadePush;
extern BITMAP *WinRestore;
extern BITMAP *WinRestorePush;
extern BITMAP *Slider;
extern BITMAP *SliderPush;
extern BITMAP *SliderEnd;
extern BITMAP *Arrow;
extern BITMAP *ScrollArrow;
extern BITMAP *ScrollArrowPush;
extern BITMAP *ScrollDown;
extern BITMAP *ListUp;
extern BITMAP *ListUpPush;
extern BITMAP *ListDn;
extern BITMAP *ListDnPush;
extern BITMAP *ViewU;
extern BITMAP *ViewUP;
extern BITMAP *ViewD;
extern BITMAP *ViewDP;
extern BITMAP *ViewR;
extern BITMAP *ViewRP;
extern BITMAP *ViewL;
extern BITMAP *ViewLP;

extern BITMAP *MapBox;
extern BITMAP *MapItem;
extern BITMAP *MapSlice1;
extern BITMAP *MapSlice2;
extern BITMAP *MapSlice3;
extern BITMAP *MapSlice4;
extern BITMAP *MapElevator;
extern BITMAP *MapDStretch;
extern BITMAP *MapBStretch;

extern BITMAP **TileImages;
extern BITMAP **ClipImages;

extern FONT *TinyFont;
extern DATAFILE *Fonts;
extern DATAFILE *Editor;
extern DATAFILE *TileFile;
/*______________________________________________________________________________
============================================================= Global Funcitons =
____________________________________________
    Notes:                                  \___________________________________
    
    Global functions are used in varying locations of the program.  They have 
    multiple applications or are used in separate source files.  The global 
    functions are stored in the gbl-functions.cpp source file.
______________________________________________________________________________*/

extern bool mouse_inarea(short window_lft_pos, 
                         short window_top_pos, 
                         short window_width, 
                         short window_height);
                         
extern char * strclr(char *string);
void Set_Screen(void);
void GetInputFromBuffer(char *outstring, char position, short type);
void PollKeyBuffer();
char *Get_String(char **ptr, int num);

extern void draw_hbar_gradient(BITMAP *dest, int x, int y, int w, int h, int col1, int col2);
extern void draw_vbar_gradient(BITMAP *dest, int x, int y, int w, int h, int col1, int col2);
extern void draw_diag_gradient(BITMAP *dest, int x, int y, int w, int h, int col1, int col2);

extern void *qualloc(void *pnt, int size);
extern void *qualloc(void *pnt, int size, int size2);
extern void PrintLoc();
extern int ploc;

extern void quexit(int error);
extern void Init_String(char *string, char text[], int len);
