
class Label {
    private:
        BITMAP *image;
    public:
        short xPos;
        short yPos;
        char *label;
        Label(short, short, char *);
        Label(short, short, BITMAP*);
        
        void SetText(char *);
        void SetImage(BITMAP *);
        void Draw(BITMAP *, short, short);
};
class Button {
    private: 
        bool pressed;
        short xPos;
        short yPos;
        char *label;
        void (*press)(void);
        
        BITMAP *image;
        BITMAP *pressimage;
    public:
        short width;
        short height;
        Button(short, short, short, short, char *, void (*)(void));
        Button(short, short, short, short, BITMAP*, void (*)(void));
        Button(short, short, short, short, BITMAP*, BITMAP*, void (*)(void));
        
        bool Check(short, short);
        void Draw(BITMAP *, short, short);
};


class ScrollBox {
    public: 
        short refmode;
        short inc;
        short low;
        short high;
        short *ref;
        short xPos;
        short yPos; 
        short width;
        short curflash;
        
        char *input;
        char **optList;
        
        bool drop;
        bool left;
        bool right;
        bool up;
        bool down;
        bool droppress;
        bool functionflag;
        bool waitingforinput;
        void (*funct)(void);
    public:
        ScrollBox(short, short, short, bool, short, short *, short, short, short);
        //ScrollBox(short, short, short, bool, short *, char **, short);
        
        bool AddItem(char *);
        bool EraseItem(short);
        bool ItemUp(short);
        bool ItemDn(short);
        void SetFunction(void (*)(void));
        bool ModInt(short, short, short);
        bool Check(short, short);
        void Draw(BITMAP *, short, short);
};

class TextBox {
    private:
        short xPos;
        short yPos;
        short width;
        short curflash;
        short entertype;
        
        char *input;
        char **ref;
        bool waitingforinput;
        void (*press)(char *);
    public:
        TextBox(short, short, short, char **);
        TextBox(short, short, short, bool, void (*)(char *));
        
        bool StartInput(void);
        bool CancelInput(void);
        int GetString(char *);
        void SetRefmode(short);
        bool Check(short, short);
        void Draw(BITMAP *, short, short);
};

class ListBox {
    private:
        short xPos;
        short yPos;
        short width;
        short display;
        short index;
        short items;
        short *ref;
        
        float scrollbary;
        float scrollbaryinc;
        short scrollbarysize;
        short scrollbarygrab;
        short scrollbarygpos;
        
        bool up;
        bool down;
        bool slider;
        
        char **list;
        BITMAP *highlight;
    public:
        ListBox(short, short, short, short, short *);
        
        bool AddItem(char *);
        bool EraseItem(short);
        bool ItemUp(short);
        bool ItemDn(short);
        bool Check(short, short);
        void Draw(BITMAP *, short, short);
};
class Scroller {
    
    private: 
        short inc;
        short low;
        short high;
        short *ref;
        short xPos;
        short yPos;
        short width;
        float spacing;
        
        bool ticks;
        bool left;
        bool right;
        bool barclick;
        
    public:
        Scroller(short, short, short, short *, short, short, short, bool);
        
        bool Check(short, short);
        void Draw(BITMAP *, short, short);
        
};
class Selector {   //Ex: the tile selection, door selection boxes, with custom image/text
    private: 
        short *ref;
        short xPos;
        short yPos;
        short trig;
        short width;
        short height;
        char *label;
        
        bool visible;
        bool disabled;
        bool selectable;
        bool callfunct;
        
        BITMAP *image;
        BITMAP *layer;
        BITMAP *highlight;
        
        void (*function)(void);
    public:
        Selector(short, short, short, short, char *, short *, short);
        Selector(short, short, short, short, BITMAP*, short *, short);
        
        bool SetFunction(void (*)(void));
        bool Enable(void);
        bool Disable(void);
        bool Show(void);
        bool Hide(void);
        bool Select(void);
        bool NoSelect(void);
        void FreeImage(void);
        bool SetImage(BITMAP *);
        bool SetText(char *);
        bool SetTrigger(short);
        
        bool Check(short, short);
        void Draw(BITMAP *, short, short);
};

class CheckBox {
    private:
        short xPos;
        short yPos;
        
        char *label;
        
        bool *ref;
        bool check;
        bool cproc;
        bool press;
        
        void (*click)(bool);
    public:
        CheckBox(short, short, char *, bool*);
        CheckBox(short, short, char *, void (*)(bool));
        
        bool State(bool);
        
        bool Check(short, short);
        void Draw(BITMAP *, short, short);
};
class Viewport {
    private:
        short xPos;
        short yPos;
        short xInner;
        short yInner;
        short xMouse;
        short yMouse;
        short xElements;
        short yElements;
        short gridSize;
        
        float scrollbarx;
        float scrollbary;
        float scrollbarxinc;
        float scrollbaryinc;
        short scrollbarxsize;
        short scrollbarysize;
        short scrollbarxgrab;
        short scrollbarygrab;
        short scrollbarxgpos;
        short scrollbarygpos;
        
        bool scrollup;
        bool scrolldn;
        bool scrolllf;
        bool scrollrt;
        
        bool hovall;
        bool prlflag;
        bool priflag;
        bool secflag;
        bool hovflag;
        bool outflag;
        bool drwflag;
        bool showgrid;
        bool viewalter;
        bool primouse;
        BITMAP *ViewBuf;
        
        void (*hover)(short, short);
        void (*primary)(short, short);
        void (*prirelease)(short, short);
        void (*secondary)(short, short);
        void (*drawproc)(BITMAP *, short);
        
        BITMAP *(*outproc)(short, short);
    public:
        short xScroll;
        short yScroll;
        
        Viewport(short, short, short, short, short);
        
        bool Grid(short);
        bool PriProc(void (*)(short, short));
        bool PriRelProc(void (*)(short, short));
        bool SecProc(void (*)(short, short));
        bool HovProc(void (*)(short, short), bool);
        bool OutProc(BITMAP *(*)(short, short));
        bool DrawProc(void (*)(BITMAP *, short));
        bool ResizeEx(short, short);  
        bool ResizeIn(short, short);      
        void Refresh(void);
        bool Check(short, short); 
        void Draw(BITMAP *, short, short);
};

class Window {
    private: 
        bool mobile;
        
        bool pushorigin;
        
        bool closes;
        bool pushclose;
        bool active;
        
        bool hides;
        bool pushhide;
        bool visible;
        
        bool returns;
        bool pushreturn;
        
        short grabX;
        short grabY;
        short xPos;
        short yPos; 
        short orixPos;
        short oriyPos; 
        char *label;
        short labels;
        short buttons;
        short sliders;
        short selectors;
        short scrollboxes;
        short textboxes;
        short listboxes;
        short checkboxes;
        short viewports;
        bool waitingforinput;
        
        void (*close)(void);
    public:
        short width;
        short height;
        Label **Labels;
        Button **Buttons;
        Scroller **Sliders;
        Selector **Selectors;
        ScrollBox **ScrollBoxes;
        TextBox **TextBoxes;
        ListBox **ListBoxes;
        CheckBox **CheckBoxes;
        Viewport **Viewports;
        
        Window(short, short, short, short, char *, void (*)(void)); 
        ~Window(); 
        
        bool AddLabel(short, short, char *);
        bool AddLabel(short, short, BITMAP*);
        bool AddButton(short, short, short, short, char *, void (*)(void));
        bool AddButton(short, short, short, short, BITMAP*, void (*)(void));
        bool AddButton(short, short, short, short, BITMAP*, BITMAP*, void (*)(void));

        bool AddButton_D(short, short, short, short, char *, void (*)(void));//Debug

        bool AddSelector(short, short, short, short, char *, short *, short);
        bool AddSelector(short, short, short, short, BITMAP*, short *, short);
        bool AddSlider(short, short, short, short *, short, short, short, bool);
        bool AddScrollBox(short, short, short, bool, short *, short, short, short);
        bool AddListScrollBox(short, short, short, bool, short *, int args, ...);
        bool AddTextBox(short, short, short, char **);
        bool AddTextBox(short, short, short, bool, void (*)(char *));
        bool AddListBox(short, short, short, short, short *, int args, ...);
        bool AddListBoxItem(short, char*);
        bool AddCheckBox(short, short, char *, bool*);
        bool AddCheckBox(short, short, char *, void (*)(bool));
        bool AddViewport(short, short, short, short, short);
        
        char *Window::WindowTitle(void);
        
        void Mobile(void);
        void Immobile(void);
        void Shades(void);
        void NoShade(void);
        void Open(void);
        void Close(void);
        void Returns(void);
        void NoReturn(void);
        void Closes(void);
        void NoClose(void);
        
        void Set_Pos(short, short);
        
        void In_Screen(void);
        
        int Check(void);
        void Draw(BITMAP *);
};


//#pragma once                              //Have the compiler parse the headers
                                          // only once when included in multiple
                                          // source files
