/*______________________________________________________________________________
=================================================================== GUI Window =
____________________________________________
                                            \_________________________________*/
void gui_window(BITMAP *outbitmap, 
                short window_lft_pos, 
                short window_top_pos, 
                short window_width, 
                short window_height, 
                int window_colour)
{
    if(window_width < 16) window_width = 16;
    if(window_height < 16) window_height = 16;
    
    rectfill(outbitmap, window_lft_pos, window_top_pos, window_lft_pos + window_width, window_top_pos + window_height, window_colour);
    
    line(outbitmap, window_lft_pos, window_top_pos, window_lft_pos + window_width, window_top_pos, makecol(255, 255, 255));
    rectfill(outbitmap, window_lft_pos, window_top_pos + 1, window_lft_pos + window_width, window_top_pos + 13, makecol(192, 192, 192));
    line(outbitmap, window_lft_pos, window_top_pos, window_lft_pos, window_top_pos + window_height, makecol(255, 255, 255));
    line(outbitmap, window_lft_pos + 1, window_top_pos + 14, window_lft_pos + window_width - 2, window_top_pos + 14, makecol(192, 192, 192));
    line(outbitmap, window_lft_pos + 1, window_top_pos + 14, window_lft_pos + 1, window_top_pos + window_height - 1, makecol(192, 192, 192));
    line(outbitmap, window_lft_pos + 2, window_top_pos + 15, window_lft_pos + window_width - 2, window_top_pos + 15, makecol(128, 128, 128));
    line(outbitmap, window_lft_pos + 2, window_top_pos + 15, window_lft_pos + 2, window_top_pos + window_height - 1, makecol(128, 128, 128));
    line(outbitmap, window_lft_pos + 1, window_top_pos + window_height, window_lft_pos + window_width, window_top_pos + window_height, makecol(48, 48, 48));
    line(outbitmap, window_lft_pos + window_width, window_top_pos, window_lft_pos + window_width, window_top_pos + window_height, makecol(48, 48, 48));
    line(outbitmap, window_lft_pos + 2, window_top_pos + window_height - 1, window_lft_pos + window_width - 1, window_top_pos + window_height - 1, makecol(128, 128, 128));
    line(outbitmap, window_lft_pos + window_width - 1, window_top_pos + 1, window_lft_pos + window_width - 1, window_top_pos + window_height - 1, makecol(128, 128, 128));
    line(outbitmap, window_lft_pos + 3, window_top_pos + window_height - 2, window_lft_pos + window_width - 2, window_top_pos + window_height - 2, makecol(192, 192, 192));
    line(outbitmap, window_lft_pos + window_width - 2, window_top_pos + 16, window_lft_pos + window_width - 2, window_top_pos + window_height - 2, makecol(192, 192, 192));
    
    line(outbitmap, window_lft_pos + 3, window_top_pos + 16, window_lft_pos + window_width - 3, window_top_pos + 16, (int)(window_colour / 2));
    line(outbitmap, window_lft_pos + 3, window_top_pos + 17, window_lft_pos + 5, window_top_pos + 17, (int)(window_colour / 2));
    line(outbitmap, window_lft_pos + 3, window_top_pos + 16, window_lft_pos + 3, window_top_pos + window_height - 3, (int)(window_colour / 2));
    line(outbitmap, window_lft_pos + 4, window_top_pos + 16, window_lft_pos + 4, window_top_pos + window_height - 3, (int)(window_colour / 2));
}
/*______________________________________________________________________________
============================================================== Winshade Window =
____________________________________________
                                            \_________________________________*/
void winshade_window(BITMAP *outbitmap, 
                short window_lft_pos, 
                short window_top_pos, 
                short window_width, 
                short window_height)
{
    if(window_width < 16) window_width = 16;
    //if(window_height < 16) window_height = 16;
    
    //rectfill(outbitmap, window_lft_pos, window_top_pos, window_lft_pos + window_width, window_top_pos + window_height, window_colour);
    
    line(outbitmap, window_lft_pos, window_top_pos, window_lft_pos + window_width, window_top_pos, makecol(255, 255, 255));
    rectfill(outbitmap, window_lft_pos, window_top_pos + 1, window_lft_pos + window_width, window_top_pos + 13, makecol(192, 192, 192));
    line(outbitmap, window_lft_pos, window_top_pos, window_lft_pos, window_top_pos + window_height, makecol(255, 255, 255));
    line(outbitmap, window_lft_pos + 1, window_top_pos + 14, window_lft_pos + window_width - 2, window_top_pos + 14, makecol(192, 192, 192));
    line(outbitmap, window_lft_pos + 1, window_top_pos + 14, window_lft_pos + 1, window_top_pos + window_height - 1, makecol(192, 192, 192));
    line(outbitmap, window_lft_pos + 2, window_top_pos + 15, window_lft_pos + window_width - 2, window_top_pos + 15, makecol(128, 128, 128));
    line(outbitmap, window_lft_pos + 2, window_top_pos + 15, window_lft_pos + 2, window_top_pos + window_height - 1, makecol(128, 128, 128));
    line(outbitmap, window_lft_pos + 1, window_top_pos + window_height, window_lft_pos + window_width, window_top_pos + window_height, makecol(48, 48, 48));
    line(outbitmap, window_lft_pos + window_width, window_top_pos, window_lft_pos + window_width, window_top_pos + window_height, makecol(48, 48, 48));
    line(outbitmap, window_lft_pos + 2, window_top_pos + window_height - 1, window_lft_pos + window_width - 1, window_top_pos + window_height - 1, makecol(128, 128, 128));
    line(outbitmap, window_lft_pos + window_width - 1, window_top_pos + 1, window_lft_pos + window_width - 1, window_top_pos + window_height - 1, makecol(128, 128, 128));
    line(outbitmap, window_lft_pos + 3, window_top_pos + window_height - 2, window_lft_pos + window_width - 2, window_top_pos + window_height - 2, makecol(192, 192, 192));
    line(outbitmap, window_lft_pos + window_width - 2, window_top_pos + 16, window_lft_pos + window_width - 2, window_top_pos + window_height - 2, makecol(192, 192, 192));
}
/*______________________________________________________________________________
======================================================================= Button =
____________________________________________
                                            \_________________________________*/
void button(BITMAP *outbitmap, 
            short window_lft_pos, 
            short window_top_pos, 
            short window_width, 
            short window_height, 
            int window_colour, 
            bool pressed, 
            BITMAP *image, 
            char *text, ...)
{
    window_width --;
    window_height --;
    
    if(window_width < 0) window_width = 0;
    if(window_height < 0) window_height = 0;
    
    if(pressed == FALSE) {
        rectfill(outbitmap, window_lft_pos, window_top_pos, window_lft_pos + window_width, window_top_pos + window_height, (int)(window_colour));
        
        line(outbitmap, window_lft_pos, window_top_pos, window_lft_pos + window_width / 2, window_top_pos, (int)(window_colour * 2));
        line(outbitmap, window_lft_pos, window_top_pos, window_lft_pos, window_top_pos + window_height / 2, (int)(window_colour * 2));
        putpixel(outbitmap, window_lft_pos, window_top_pos, (int)(window_colour * 2));
        
        line(outbitmap, window_lft_pos + window_width / 2, window_top_pos, window_lft_pos + window_width, window_top_pos, (int)(window_colour * 1.5));
        line(outbitmap, window_lft_pos, window_top_pos + window_height / 2, window_lft_pos, window_top_pos + window_height, (int)(window_colour * 1.5));
        line(outbitmap, window_lft_pos + 1, window_top_pos + window_height - 1, window_lft_pos + 1, window_top_pos + window_height, (int)(window_colour * 1.5));
        
        line(outbitmap, window_lft_pos + 2, window_top_pos + window_height, window_lft_pos + window_width / 2, window_top_pos + window_height, (int)(window_colour * 0.75));
        line(outbitmap, window_lft_pos + window_width, window_top_pos, window_lft_pos + window_width, window_top_pos + window_height / 2, (int)(window_colour * 0.75));
        line(outbitmap, window_lft_pos + window_width - 1, window_top_pos, window_lft_pos + window_width - 1, window_top_pos + 1, (int)(window_colour * 0.75));
        
        line(outbitmap, window_lft_pos + window_width, window_top_pos + window_height / 2, window_lft_pos + window_width, window_top_pos + window_height, (int)(window_colour * 0.5));
        line(outbitmap, window_lft_pos + window_width / 2, window_top_pos + window_height, window_lft_pos + window_width, window_top_pos + window_height, (int)(window_colour * 0.5));
        putpixel(outbitmap, window_lft_pos + window_width - 1, window_top_pos + window_height - 1, (int)(window_colour * 0.5));
        if(text != NULL)
        {
            textprintf_centre(outbitmap, font, 
                window_lft_pos + (window_width / 2) + pressed + 2, 
                window_top_pos + (window_height / 2) + pressed - 2, 
                makecol(32, 32, 32), "%s", text);
        }
    }
    else {
        rectfill(outbitmap, window_lft_pos, window_top_pos, window_lft_pos + window_width, window_top_pos + window_height, (int)(window_colour));
        
        line(outbitmap, window_lft_pos, window_top_pos, window_lft_pos + window_width / 2, window_top_pos, (int)(window_colour * 0.5));
        line(outbitmap, window_lft_pos, window_top_pos, window_lft_pos, window_top_pos + window_height / 2, (int)(window_colour * 0.5));
        putpixel(outbitmap, window_lft_pos, window_top_pos, (int)(window_colour * 0.5));
        
        line(outbitmap, window_lft_pos + window_width / 2, window_top_pos, window_lft_pos + window_width, window_top_pos, (int)(window_colour * 0.75));
        line(outbitmap, window_lft_pos, window_top_pos + window_height / 2, window_lft_pos, window_top_pos + window_height, (int)(window_colour * 0.75));
        line(outbitmap, window_lft_pos + 1, window_top_pos + window_height - 1, window_lft_pos + 1, window_top_pos + window_height, (int)(window_colour * 0.75));
        
        line(outbitmap, window_lft_pos + 2, window_top_pos + window_height, window_lft_pos + window_width / 2, window_top_pos + window_height, (int)(window_colour * 1.5));
        line(outbitmap, window_lft_pos + window_width, window_top_pos, window_lft_pos + window_width, window_top_pos + window_height / 2, (int)(window_colour * 1.5));
        line(outbitmap, window_lft_pos + window_width - 1, window_top_pos, window_lft_pos + window_width - 1, window_top_pos + 1, (int)(window_colour * 1.5));
        
        line(outbitmap, window_lft_pos + window_width, window_top_pos + window_height / 2, window_lft_pos + window_width, window_top_pos + window_height, (int)(window_colour * 2));
        line(outbitmap, window_lft_pos + window_width / 2, window_top_pos + window_height, window_lft_pos + window_width, window_top_pos + window_height, (int)(window_colour * 2));
        putpixel(outbitmap, window_lft_pos + window_width - 1, window_top_pos + window_height - 1, (int)(window_colour * 2));
    }
    if(text != NULL) {
        textprintf_centre(outbitmap, font, 
            window_lft_pos + (window_width / 2) + pressed + 1, 
            window_top_pos + (window_height / 2) + pressed - 3, 
            makecol(32, 32, 32), "%s", text);
        textprintf_centre(outbitmap, font, 
            window_lft_pos + (window_width / 2) + pressed, 
            window_top_pos + (window_height / 2) + pressed - 4, 
            makecol(255, 255, 255), "%s", text);
    }
    else {
        draw_sprite(outbitmap, image, (window_lft_pos + window_width / 2) - (image->w / 2) + pressed, (window_top_pos + window_height / 2) - (image->h / 2) + pressed);
    }
}
/*______________________________________________________________________________
===================================================================== Selector =
____________________________________________
                                            \_________________________________*/
void selector(BITMAP *outbitmap, 
            short window_lft_pos, 
            short window_top_pos, 
            short window_width, 
            short window_height, 
            BITMAP *image, 
            char *text, ...) {
    rect(outbitmap, window_lft_pos, window_top_pos, window_lft_pos + window_width, window_top_pos + window_height, makecol(255,255,255));
    rectfill(outbitmap, window_lft_pos + 1, window_top_pos + 1, window_lft_pos + window_width - 1, window_top_pos + window_height - 1, makecol(0,0,0));
    if(text != NULL)
    {
        textprintf_centre(outbitmap, font, 
            window_lft_pos + (window_width / 2) + 2, 
            window_top_pos + (window_height / 2) - 2, 
            makecol(32, 32, 32), "%s", text);
        textprintf_centre(outbitmap, font, 
            window_lft_pos + (window_width / 2) + 1, 
            window_top_pos + (window_height / 2) - 3, 
            makecol(255, 255, 255), "%s", text);
    } else {
        draw_sprite(outbitmap, image, (window_lft_pos + window_width / 2) - (image->w / 2), (window_top_pos + window_height / 2) - (image->h / 2));
    }
}
/*______________________________________________________________________________
===================================================================== Text Box =
____________________________________________
                                            \_________________________________*/
void text_box(BITMAP *outbitmap, 
              short window_lft_pos, 
              short window_top_pos, 
              short window_width, 
              short window_height, 
              int window_colour, 
              char *text, ...)
{
    if(text != NULL) 
    {
        if(window_width < strlen(text) * 8 + 6) window_width = strlen(text) * 8 + 6;
        if(window_height < 14) window_height = 14;
    }
    window_width --;
    window_height --;
    
    rectfill(outbitmap, window_lft_pos, window_top_pos, window_lft_pos + window_width, window_top_pos + window_height, window_colour);
    
    line(outbitmap, window_lft_pos, window_top_pos, window_lft_pos + window_width / 2, window_top_pos, (int)(window_colour * 3.5));
    line(outbitmap, window_lft_pos, window_top_pos, window_lft_pos, window_top_pos + window_height / 2, (int)(window_colour * 3.5));
    putpixel(outbitmap, window_lft_pos + 1, window_top_pos + 1, (int)(window_colour * 3.5));
    
    line(outbitmap, window_lft_pos + window_width / 2, window_top_pos, window_lft_pos + window_width, window_top_pos, (int)(window_colour * 3));
    line(outbitmap, window_lft_pos, window_top_pos + window_height / 2, window_lft_pos, window_top_pos + window_height, (int)(window_colour * 3));
    line(outbitmap, window_lft_pos + 1, window_top_pos + window_height - 1, window_lft_pos + 1, window_top_pos + window_height, (int)(window_colour * 3));
    
    line(outbitmap, window_lft_pos + 2, window_top_pos + window_height, window_lft_pos + window_width / 2, window_top_pos + window_height, (int)(window_colour * 2.5));
    line(outbitmap, window_lft_pos + window_width, window_top_pos, window_lft_pos + window_width, window_top_pos + window_height / 2, (int)(window_colour * 2.5));
    line(outbitmap, window_lft_pos + window_width - 1, window_top_pos, window_lft_pos + window_width - 1, window_top_pos + 1, (int)(window_colour * 2.5));
    
    line(outbitmap, window_lft_pos + window_width, window_top_pos + window_height / 2, window_lft_pos + window_width, window_top_pos + window_height, (int)(window_colour * 2));
    line(outbitmap, window_lft_pos + window_width / 2, window_top_pos + window_height, window_lft_pos + window_width, window_top_pos + window_height, (int)(window_colour * 2));
    putpixel(outbitmap, window_lft_pos + window_width - 1, window_top_pos + window_height - 1, (int)(window_colour * 2.5));
    
    line(outbitmap, window_lft_pos + 1, window_top_pos + 2, window_lft_pos + 1, window_top_pos + window_height - 2, (int)(window_colour * 0.5));
    line(outbitmap, window_lft_pos + 2, window_top_pos + 1, window_lft_pos + 2, window_top_pos + window_height - 1, (int)(window_colour * 0.5));
    line(outbitmap, window_lft_pos + 2, window_top_pos + 1, window_lft_pos + window_width - 2, window_top_pos + 1, (int)(window_colour * 0.5));
    line(outbitmap, window_lft_pos + window_width - 2, window_top_pos + 2, window_lft_pos + window_width - 1, window_top_pos + 2, (int)(window_colour * 0.5));
    putpixel(outbitmap, window_lft_pos + 3, window_top_pos + 2, (int)(window_colour * 0.5));
    
    if(text != NULL) 
    {
        textprintf_centre(outbitmap, font,
            window_lft_pos + (window_width / 2) + 3, 
            window_top_pos + (window_height / 2) - 1, 
            makecol(32, 32, 32), "%s", text);
        textprintf_centre(outbitmap, font, 
            window_lft_pos + (window_width / 2) + 2, 
            window_top_pos + (window_height / 2) - 2, 
            makecol(32, 32, 32), "%s", text);
        textprintf_centre(outbitmap, font, 
            window_lft_pos + (window_width / 2) + 1, 
            window_top_pos + (window_height / 2) - 3, 
            makecol(255, 255, 255), "%s", text); 
    }
}
