#include "commonheaders.h"
#include "cls-window.h"
#include "cls-windraw.h"

void dash(BITMAP *output, int x, int y, int d)
{
	if((float)x/2 == (float)(int)x/2)
	{
        putpixel(output, x, y, d);
    }
}

Viewport::Viewport(short xLocation, short yLocation, short xExterior, short yExterior, short grid) {
    xPos = xLocation;
    yPos = yLocation;
    xInner = xExterior;
    yInner = yExterior;
    xScroll = 0;
    yScroll = 0;
    xElements = xExterior;
    yElements = yExterior;
    viewalter = true;
    gridSize = grid;
    ViewBuf = create_bitmap(xElements * gridSize + 14, yElements * gridSize + 14);
    
    scrollup = false;
    scrolldn = false;
    scrolllf = false;
    scrollrt = false;
        
    prlflag = false;
    priflag = false;
    secflag = false;
    hovflag = false;
    outflag = false;
    drwflag = false;
    primouse = false;
    
    hover = NULL;
    drawproc = NULL;
    primary = NULL;
    prirelease = NULL;
    secondary = NULL;
    outproc = NULL;
}    

bool Viewport::PriProc(void (*proc)(short, short)) {
    priflag = true;
    primary = proc;
}       
bool Viewport::PriRelProc(void (*proc)(short, short)) {
    prlflag = true;
    prirelease = proc;
}     
bool Viewport::SecProc(void (*proc)(short, short)) {
    secflag = true;
    secondary = proc;
}       
bool Viewport::HovProc(void (*proc)(short, short), bool type) {
    hovflag = true;
    hovall = type;
    hover = proc;
}           
bool Viewport::OutProc(BITMAP *(*proc)(short, short)) {
    outflag = true;
    outproc = proc;
}       
bool Viewport::DrawProc(void (*proc)(BITMAP *, short)) {
    drwflag = true;
    drawproc = proc;
}   
bool Viewport::ResizeEx(short xNum, short yNum) {
    xElements = xNum;
    yElements = yNum;
    xScroll = 0;
    yScroll = 0;
    ViewBuf = create_bitmap(xElements * gridSize + 14, yElements * gridSize + 14);
    viewalter = true;
}       
bool Viewport::ResizeIn(short xNum, short yNum) {
    xInner = xNum;
    yInner = yNum;
    xScroll = 0;
    yScroll = 0;
    scrollbary = 0;
    scrollbarysize = (int)(((float)yElements / (float)yInner) * (yElements * gridSize - 27));
    scrollbaryinc = ((float)(yElements * gridSize - 27 - scrollbarysize) / (float)(yInner - yElements));
    scrollbarygrab = false;
    scrollbarx = 0;
    scrollbarxsize = (int)(((float)xElements / (float)xInner) * (xElements * gridSize - 27));
    scrollbarxinc = ((float)(xElements * gridSize - 27 - scrollbarxsize) / (float)(xInner - xElements));
    scrollbarxgrab = false;
    viewalter = true;
}       
void Viewport::Refresh(void) {
    viewalter = true;
}         
bool Viewport::Grid(short state) {
    if(state == 1) {
        showgrid = true;
    } else if(state == 0) {
        showgrid = false;
    }
    viewalter = true;
    return showgrid;
}     
bool Viewport::Check(short xLocation, short yLocation) {
    bool ret = false;
    short x = xPos + xLocation;
    short y = yPos + yLocation;
    if(mouse_inarea(x, y, xElements * gridSize - 1, yElements * gridSize - 1) && !scrollbarygrab && !scrollbarxgrab) {
        if(mouse_b & 1) {
			if(priflag)
            	primary((mouse_x - x) / gridSize + xScroll, (mouse_y - y) / gridSize + yScroll);
            viewalter = true;
            primouse = true;
        }
        /*if(!(mouse_b & 1) && prlflag) {
            prirelease((mouse_x - x) / gridSize + xScroll, (mouse_y - y) / gridSize + yScroll);
            viewalter = true;
        }*/
        if(mouse_b & 2 && secflag) {
            secondary((mouse_x - x) / gridSize + xScroll, (mouse_y - y) / gridSize + yScroll);
            viewalter = true;
        }
        if(hovall) {
			if(hovflag) {
                hover((mouse_x - x) / gridSize + xScroll, (mouse_y - y) / gridSize + xScroll);
            }
		} else if((xMouse / gridSize != (mouse_x - x) / gridSize) ||
            (yMouse / gridSize != (mouse_y - y) / gridSize)) {
                if(hovflag) {
                    hover((mouse_x - x) / gridSize + xScroll, (mouse_y - y) / gridSize + yScroll);
                }
        }
        scrollup = false;
        scrolldn = false;
        scrolllf = false;
        scrollrt = false;
    } else if(mouse_inarea(x + xElements * gridSize - 1, y - 1, 12, 11) && !scrollbarygrab && !scrollbarxgrab) {
        if(mouse_b & 1 && !scrollup) {
            scrollup = true;
            scrolldn = false;
            scrolllf = false;
            scrollrt = false;
            viewalter = true;
            if(yScroll > 0) {
                yScroll --;
                scrollbary -= (int)scrollbaryinc;
                if((int)scrollbary < 0 || yScroll == 0) scrollbary = 0;
            }
        }
    } else if(mouse_inarea(x, y + yElements * gridSize, 11, 11) && !scrollbarygrab && !scrollbarxgrab) {
        if(mouse_b & 1 && !scrolllf) {
            scrolllf = true;
            scrollup = false;
            scrolldn = false;
            scrollrt = false;
            viewalter = true;
            if(xScroll > 0) {
                xScroll --;
                scrollbarx -= (int)scrollbarxinc;
                if((int)scrollbarx < 0 || xScroll == 0) scrollbarx = 0;
            }
        }
    } else if(mouse_inarea(x + xElements * gridSize, y + yElements * gridSize - 12, 11, 11) && !scrollbarygrab && !scrollbarxgrab) {
        if(mouse_b & 1 && !scrolldn) {
            scrolldn = true;
            scrollup = false;
            scrolllf = false;
            scrollrt = false;
            viewalter = true;
            if(yScroll < yInner - yElements) {
                yScroll ++;
                scrollbary += (int)scrollbaryinc;
                if((int)scrollbary > yElements * gridSize - 25 - scrollbarysize || yScroll == yInner - yElements) scrollbary = yElements * gridSize - 25 - scrollbarysize;
            }
        }
    } else if(mouse_inarea(x + xElements * gridSize - 11, y + yElements * gridSize, 11, 11) && !scrollbarygrab && !scrollbarxgrab) {
        if(mouse_b & 1 && !scrollrt) {
            scrollrt = true;
            scrollup = false;
            scrolldn = false;
            scrolllf = false;
            viewalter = true;
            if(xScroll < xInner - xElements) {
                xScroll ++;
                scrollbarx += scrollbarxinc;
                if((int)scrollbarx > xElements * gridSize - 25 - scrollbarxsize || xScroll == xInner - xElements) scrollbarx = xElements * gridSize - 25 - scrollbarxsize;
            }
        }
    } else if(yInner > yElements && mouse_inarea(x + xElements * gridSize + 2, y + 11 + (int)scrollbary, 11, scrollbarysize + 2) && !scrollbarxgrab) {
        if(mouse_b & 1 && !scrollbarygrab) {
            scrollbarygrab = true;
            scrollbarygpos = (mouse_y - y) - (int)scrollbary;
            viewalter = true;
        }
        scrollup = false;
        scrolldn = false;
        scrolllf = false;
        scrollrt = false;
    } else if(xInner > xElements && mouse_inarea(x + 11 + (int)scrollbarx, y + yElements * gridSize + 2, scrollbarxsize + 2, 11) && !scrollbarygrab) {
        if(mouse_b & 1 && !scrollbarxgrab) {
            scrollbarxgrab = true;
            scrollbarxgpos = (mouse_x - x) - (int)scrollbarx;
            viewalter = true;
        }
        scrollup = false;
        scrolldn = false;
        scrolllf = false;
        scrollrt = false;
    } else {
        scrollup = false;
        scrolldn = false;
        scrolllf = false;
        scrollrt = false;
        viewalter = true;
        if(hovflag) {
            hover(-1, -1);
        }
        xMouse = -1;
        yMouse = -1;
    }
    if(yInner > yElements) {
        if (scrollbarygrab && (mouse_y - y) != scrollbarygpos + scrollbary) {
            scrollbary = (mouse_y - y) - scrollbarygpos;
            if(scrollbary < 0) scrollbary = 0;
            if(scrollbary > yElements * gridSize - 25 - scrollbarysize) scrollbary = yElements * gridSize - 25 - scrollbarysize;
            yScroll = (int)(scrollbary / scrollbaryinc);
            if(yScroll > yInner - yElements) yScroll = yInner - yElements;
            viewalter = true;
        }
    }
    if(xInner > xElements) {
        if (scrollbarxgrab && (mouse_x - x) != scrollbarxgpos + scrollbarx) {
            scrollbarx = (mouse_x - x) - scrollbarxgpos;
            if(scrollbarx < 0) scrollbarx = 0;
            if(scrollbarx > xElements * gridSize - 25 - scrollbarxsize) scrollbarx = xElements * gridSize - 25 - scrollbarxsize;
            xScroll = (int)(scrollbarx / scrollbarxinc);
            if(xScroll > xInner - xElements) xScroll = xInner - xElements;
            viewalter = true;
        }
    }
    if(!(mouse_b & 1)) {
        if(prlflag && primouse) {
            if(mouse_inarea(x, y, xElements * gridSize - 1, yElements * gridSize - 1))
                prirelease((mouse_x - x) / gridSize + xScroll, (mouse_y - y) / gridSize + yScroll);
            primouse = false;
        }
        scrollup = false;
        scrolldn = false;
        scrolllf = false;
        scrollrt = false;
        scrollbarygrab = false;
        scrollbarxgrab = false;
        viewalter = true;
    }
    xMouse = (mouse_x - x);
    yMouse = (mouse_y - y);
    return ret;
}
void Viewport::Draw(BITMAP *output, short xLocation, short yLocation) {
    short x = xPos + xLocation;
    short y = yPos + yLocation;
    if(viewalter) {
        clear_to_color(ViewBuf, makecol(255,0,255));
        if(xInner < xElements || yInner < yElements)
            rectfill(ViewBuf, 1, 1, xElements * gridSize, yElements * gridSize, makecol(0, 0, 0));
        if(xInner < xElements) {
            if(yInner < yElements) {
                rectfill(ViewBuf, 1, 1, xInner * gridSize, yInner * gridSize, makecol(32, 32, 32));
            } else {
                rectfill(ViewBuf, 1, 1, xInner * gridSize, yElements * gridSize, makecol(32, 32, 32));
            }
        } else {
            if(yInner < yElements) {
                rectfill(ViewBuf, 1, 1, xElements * gridSize, yInner * gridSize, makecol(32, 32, 32));
            } else {
                rectfill(ViewBuf, 1, 1, xElements * gridSize, yElements * gridSize, makecol(32, 32, 32));
            }
        }
        for(short yloop = yScroll; yloop < yScroll + yElements; yloop ++) {
            for(short xloop = xScroll; xloop < xScroll + xElements; xloop ++) {
                if(outflag) {
                    BITMAP *display = outproc(xloop, yloop);
                    if(display != NULL) {
                        draw_sprite(ViewBuf, display, (xloop - xScroll) * gridSize + 1, (yloop - yScroll) * gridSize + 1);
                    }
                    destroy_bitmap(display);
                }
            }
        }
        if(drwflag) {
            drawproc(ViewBuf, gridSize);
        }
        line(ViewBuf, 0, 0, xElements * gridSize, 0, makecol(16, 16, 16));
        line(ViewBuf, 0, yElements * gridSize + 1, xElements * gridSize + 1, yElements * gridSize + 1, makecol(16, 16, 16));
        line(ViewBuf, 0, 0, 0, yElements * gridSize, makecol(16, 16, 16));
        line(ViewBuf, xElements * gridSize + 1, 0, xElements * gridSize + 1, yElements * gridSize + 1, makecol(16,16,16));
        if(showgrid) {
            for(short yloop = 1; yloop < yElements; yloop ++) {
                for(short xloop = 1; xloop < xElements; xloop ++) {
                    line(ViewBuf, 0, yloop * gridSize + 1, xElements * gridSize, yloop * gridSize + 1, makecol(16, 16, 16));
                    line(ViewBuf, xloop * gridSize + 1, 0, xloop * gridSize + 1, yElements * gridSize, makecol(16, 16, 16));
                }
            }
        }
        if(!scrollup) {
            draw_sprite(ViewBuf, ViewU, xElements * gridSize + 2, 0);
        } else {
            draw_sprite(ViewBuf, ViewUP, xElements * gridSize + 2, 0);
        }
        if(!scrolldn) {
            draw_sprite(ViewBuf, ViewD, xElements * gridSize + 2, yElements * gridSize - 10);
        } else {
            draw_sprite(ViewBuf, ViewDP, xElements * gridSize + 2, yElements * gridSize - 10);
        }
        draw_vbar_gradient(ViewBuf, xElements * gridSize + 2, 12, 12, yElements * gridSize - 23, makecol(0,0,0), makecol(48,48,48));
        
        if(!scrolllf) {
            draw_sprite(ViewBuf, ViewL, 0, yElements * gridSize + 2);
        } else {
            draw_sprite(ViewBuf, ViewLP, 0, yElements * gridSize + 2);
        }
        if(!scrollrt) {
            draw_sprite(ViewBuf, ViewR, xElements * gridSize - 10, yElements * gridSize + 2);
        } else {
            draw_sprite(ViewBuf, ViewRP, xElements * gridSize - 10, yElements * gridSize + 2);
        }
        draw_hbar_gradient(ViewBuf, 12, yElements * gridSize + 2, xElements * gridSize - 23, 12, makecol(0,0,0), makecol(48,48,48));
        
        if(yInner > yElements) {
            if(!scrollbarygrab) {
                draw_vbar_gradient(ViewBuf, xElements * gridSize + 3, 13 + (int)scrollbary, 10, scrollbarysize, makecol(116,116,116), makecol(76,76,76));
            } else {
                draw_vbar_gradient(ViewBuf, xElements * gridSize + 3, 13 + (int)scrollbary, 10, scrollbarysize, makecol(76,76,76), makecol(116,116,116));
            }
            hline(ViewBuf, xElements * gridSize + 2, 12 + (int)scrollbary, xElements * gridSize + 12, makecol(192,192,192));
            vline(ViewBuf, xElements * gridSize + 2, 12 + (int)scrollbary, 14 + (int)scrollbary + scrollbarysize, makecol(192,192,192));
            hline(ViewBuf, xElements * gridSize + 3, 14 + (int)scrollbary + scrollbarysize, xElements * gridSize + 12, makecol(48,48,48));
            vline(ViewBuf, xElements * gridSize + 13, 12 + (int)scrollbary, 14 + (int)scrollbary + scrollbarysize, makecol(48,48,48));
        }
        if(xInner > xElements) {
            if(!scrollbarxgrab) {
                draw_hbar_gradient(ViewBuf, 13 + (int)scrollbarx, yElements * gridSize + 3, scrollbarxsize, 10, makecol(116,116,116), makecol(76,76,76));
            } else {
                draw_hbar_gradient(ViewBuf, 13 + (int)scrollbarx, yElements * gridSize + 3, scrollbarxsize, 10, makecol(76,76,76), makecol(116,116,116));
            }
            vline(ViewBuf, 12 + (int)scrollbarx, yElements * gridSize + 2, yElements * gridSize + 12, makecol(192,192,192));
            hline(ViewBuf, 12 + (int)scrollbarx, yElements * gridSize + 2, 14 + (int)scrollbarx + scrollbarxsize, makecol(192,192,192));
            vline(ViewBuf, 14 + (int)scrollbarx + scrollbarxsize, yElements * gridSize + 3, yElements * gridSize + 12, makecol(48,48,48));
            hline(ViewBuf, 12 + (int)scrollbarx, yElements * gridSize + 13, 14 + (int)scrollbarx + scrollbarxsize, makecol(48,48,48));
            //draw_diag_gradient(ViewBuf, xElements * gridSize + 2, 12 + scrollbary, 11, scrollbarysize + 2, makecol(224,224,224), makecol(96,96,96));
            
        }
        
        rectfill(ViewBuf, xElements * gridSize + 2, yElements * gridSize + 2, xElements * gridSize + 13, yElements * gridSize + 13, makecol(80, 80, 80));
        viewalter = false;
    } 
    blit(ViewBuf, buffer, 0, 0, x - 1, y - 1, xElements * gridSize + 14, yElements * gridSize + 14);
}
