#include "commonheaders.h"
#include "cls-window.h"
#include "cls-windraw.h"

ListBox::ListBox(short xLocation, short yLocation, short winWidth, short elements, short *refval) {
    xPos = xLocation;
    yPos = yLocation;
    width = winWidth;
    display = elements;
    display = (display < 3 ? 3 : display);
    ref = refval;
    
    list = NULL;
    items = 0;
    index = 0;

    up = false;
    down = false;
    slider = false;
    printf("%i\n", width-2);
    highlight = create_bitmap(width - 2, 10);
    draw_hbar_gradient(highlight, 0, 0, width - 2, 10, makecol(192, 192, 192), makecol(128, 128, 128));
}
bool ListBox::AddItem(char *newitem) {
	printf("AddItem");
    if(list == NULL) {
		printf("New");
        list = (char **)malloc(sizeof(char *) * (items + 1));
        list[items] = (char *)malloc(strlen(newitem) + 1);
    	Init_String(list[items], newitem, 0);
        *ref = items;
        *ref = (*ref < 0 ? 0 : *ref);
        index = *ref - display + 1;
        if(index > items) index = items - display;
        if(index < 0) index = 0;
        items ++;
        list[items] = NULL;
        return true;
    } else {
        short i = 0;
        while(i < items - 1 && list[i] != NULL) {
            if(strcmp(newitem, list[i]) == 0) {
                break;
            }
            i++;
        }
        if(strcmp(newitem, list[i]) != 0) {
			printf("Adding new");
        	list = (char **)realloc(list, sizeof(char *) * (items + 1));
        	list[items] = NULL;
            list[items] = (char *)malloc(sizeof(char) * strlen(newitem) + 1);
            Init_String(list[items], newitem, 0);
            *ref = items;
            *ref = (*ref < 0 ? 0 : *ref);
            index = *ref - display + 1;
            if(index > items) index = items - display;
            if(index < 0) index = 0;
            items ++;
            list[items] = NULL;
            scrollbary = 0;
            scrollbarysize = (int)(((float)display / (float)items) * (display * 10 - 20));
            scrollbaryinc = ((float)(display * 10 - 20 - scrollbarysize) / (float)(items - display));
            scrollbarygrab = false;
            return true;
        }
    }
    return false;
}
bool ListBox::EraseItem(short itemnum) {
    bool founditem = false;
    for(short i = 0; i < items; i ++) {
        if(i == itemnum) founditem = true;
        if(founditem && i < items) {
            strclr(list[i]);
            if(list[i + 1] != NULL) {
                strcpy(list[i], list[i + 1]);
            }
        }
    }
    if(founditem) {
        free(list[items]);
        items --;
        list = (char **)realloc(list, sizeof(char *) * (items));
        *ref = items - 1;
        *ref = (*ref < 0 ? 0 : *ref);
    }
    return founditem;
}
bool ListBox::ItemUp(short itemnum) {
    if(itemnum > 0 && itemnum < items) {
        char * tempstr;
        short len1, len2;
        len1 = strlen(list[itemnum]);
        len2 = strlen(list[itemnum - 1]);
        if(len1 > len2) {
            tempstr = (char *)malloc(sizeof(char) * len1);
            list[itemnum - 1] = (char *)realloc(list[itemnum - 1], sizeof(char) * len1);
            list[itemnum - 1][len2] = '\0';
            strcpy(tempstr, list[itemnum - 1]);
            strcpy(list[itemnum - 1], list[itemnum]);
            strcpy(list[itemnum], tempstr);
            list[itemnum] = (char *)realloc(list[itemnum], sizeof(char) * len2);
            list[itemnum][len2] = '\0';
        } else if (len1 < len2) {
            tempstr = (char *)malloc(sizeof(char) * len2);
            list[itemnum] = (char *)realloc(list[itemnum], sizeof(char) * len2);
            list[itemnum][len1] = '\0';
            strcpy(tempstr, list[itemnum - 1]);
            strcpy(list[itemnum - 1], list[itemnum]);
            strcpy(list[itemnum], tempstr);
            list[itemnum - 1] = (char *)realloc(list[itemnum - 1], sizeof(char) * len1);
            list[itemnum - 1][len1] = '\0';
        } else {
            tempstr = (char *)malloc(sizeof(char) * len1);
            strcpy(tempstr, list[itemnum - 1]);
            strcpy(list[itemnum - 1], list[itemnum]);
            strcpy(list[itemnum], tempstr);
        }
        *ref = *ref - 1;
        return true;
    }
    return false;
}
bool ListBox::ItemDn(short itemnum) {
    if(itemnum >= 0 && itemnum < items - 1) {
        char * tempstr;
        short len1, len2;
        len1 = strlen(list[itemnum]);
        len2 = strlen(list[itemnum + 1]);
        if(len1 > len2) {
            tempstr = (char *)malloc(sizeof(char) * len1);
            list[itemnum + 1] = (char *)realloc(list[itemnum + 1], sizeof(char) * len1);
            list[itemnum + 1][len2] = '\0';
            strcpy(tempstr, list[itemnum + 1]);
            strcpy(list[itemnum + 1], list[itemnum]);
            strcpy(list[itemnum], tempstr);
            list[itemnum] = (char *)realloc(list[itemnum], sizeof(char) * len2);
            list[itemnum][len2] = '\0';
        } else if (len1 < len2) {
            tempstr = (char *)malloc(sizeof(char) * len2);
            list[itemnum] = (char *)realloc(list[itemnum], sizeof(char) * len2);
            list[itemnum][len1] = '\0';
            strcpy(tempstr, list[itemnum + 1]);
            strcpy(list[itemnum + 1], list[itemnum]);
            strcpy(list[itemnum], tempstr);
            list[itemnum + 1] = (char *)realloc(list[itemnum + 1], sizeof(char) * len1);
            list[itemnum + 1][len1] = '\0';
        } else {
            tempstr = (char *)malloc(sizeof(char) * len1);
            strcpy(tempstr, list[itemnum + 1]);
            strcpy(list[itemnum + 1], list[itemnum]);
            strcpy(list[itemnum], tempstr);
        }
        *ref = *ref + 1;
        return true;
    }
    return false;
}
bool ListBox::Check(short xLocation, short yLocation) {
    short y = yPos + yLocation;
    if(mouse_inarea(xPos + xLocation + width - 10, yPos + yLocation, 10, 10) && !scrollbarygrab) {
        if(mouse_b & 1 && !up) {
            up = true;
            down = false;
            if(index > 0) {
                index --;
                scrollbary -= (int)scrollbaryinc;
                if((int)scrollbary < 0 || index == 0) scrollbary = 0;
            }
            //if(*ref > index + display - 1 || (index == 0 && *ref > 0)) *ref -= 1;
        }
    } else if (mouse_inarea(xPos + xLocation + width - 10, yPos + yLocation + display * 10 - 6, 10, 10) && !scrollbarygrab) {
        if(mouse_b & 1 && !down) {
            down = true;
            up = false;
            if(index < items - display) {
                index ++;
                scrollbary += (int)scrollbaryinc;
                if((int)scrollbary > display * 10 - 20 - scrollbarysize || index == items - display) scrollbary = display * 10 - 20 - scrollbarysize;
            }
            //if(*ref < index || (*ref < items - 1 && index == items - display)) *ref += 1;
        }
    } else if(items > display && mouse_inarea(xPos + xLocation + width - 10, yPos + yLocation + 10, 8, display * 10 - 10)) {
        if(mouse_b & 1 && !scrollbarygrab) {
            scrollbarygrab = true;
            scrollbarygpos = (mouse_y - y) - (int)scrollbary;
        }
        up = false;
        down = false;
    } else {
        up = false;
        down = false;
        if(list != NULL) {
            short i = 0;
            while(i < display && list[i + index] != NULL) {
                if(mouse_b & 1 && mouse_inarea(xPos + xLocation + 1, yPos + yLocation + 3 + i * 10, width - 10, 10)) {
                    *ref = i + index;
                }
                i++;
            }
        }
    }
    if(items > display) {
        if (scrollbarygrab && (mouse_y - y) != scrollbarygpos + scrollbary) {
            scrollbary = (mouse_y - y) - scrollbarygpos;
            if(scrollbary < 0) scrollbary = 0;
            if(scrollbary > display * 10 - 20 - scrollbarysize) scrollbary = display * 10 - 20 - scrollbarysize;
            index = (int)(scrollbary / scrollbaryinc);
            if(index > items - display) index = items - display;
        }
    }
    if(!(mouse_b & 1)) {
        up = false;
        down = false;
        scrollbarygrab = false;
    }
    return false;
}
void ListBox::Draw(BITMAP *output, short xLocation, short yLocation) {
    text_box(output, xPos + xLocation, yPos + yLocation, width, 4 + display * 10, makecol(64,64,64), NULL);
    if(list != NULL) {
        short i = 0;
    	while(i < display && list[i + index] != NULL && i + index < items) {
    	    if(i + index == *ref) {
                set_trans_blender(0,0,0,128);
                draw_trans_sprite(output, highlight, xPos + xLocation + 1, yPos + yLocation + 2 + (i) * 10);
        	    /*textprintf(output, font, xPos + xLocation + 5, yPos + yLocation + 5 + (i) * 10, makecol(32, 32, 32), "%s", list[i + index]);
            	textprintf(output, font, xPos + xLocation + 4, yPos + yLocation + 4 + (i) * 10, makecol(32, 32, 32), "%s", list[i + index]);
                textprintf(output, font, xPos + xLocation + 3, yPos + yLocation + 3 + (i) * 10, makecol(192, 192, 192), "%s", list[i + index]);*/
                textprintf(output, font, xPos + xLocation + 3, yPos + yLocation + 3 + (i) * 10, makecol(32, 32, 32), "%s", list[i + index]); 
            } else {
                textprintf(output, font, xPos + xLocation + 5, yPos + yLocation + 5 + (i) * 10, makecol(32, 32, 32), "%s", list[i + index]);
                textprintf(output, font, xPos + xLocation + 4, yPos + yLocation + 4 + (i) * 10, makecol(32, 32, 32), "%s", list[i + index]);
                textprintf(output, font, xPos + xLocation + 3, yPos + yLocation + 3 + (i) * 10, makecol(255, 255, 255), "%s", list[i + index]); 
            }
            i++;
        }
    }
    draw_hbar_gradient(output, xPos + xLocation + width - 10, yPos + yLocation + 10, 8, display * 10 - 10, makecol(0,0,0), makecol(48,48,48));
    if(!down) {
        draw_sprite(output, ListDn, xPos + xLocation + width - 10, yPos + yLocation + display * 10 - 6);
    } else {
        draw_sprite(output, ListDnPush, xPos + xLocation + width - 10, yPos + yLocation + display * 10 - 6);
    }
    if(!up) {
        draw_sprite(output, ListUp, xPos + xLocation + width - 10, yPos + yLocation);
    } else {
        draw_sprite(output, ListUpPush, xPos + xLocation + width - 10, yPos + yLocation);
    }
    
}
