#include "commonheaders.h"
#include "cls-window.h"
#include "cls-windraw.h"

CheckBox::CheckBox(short xLocation, short yLocation, char *texty, bool *refval) {
    xPos = xLocation;
    yPos = yLocation;
    ref = refval;
    
    label = (char *)malloc((strlen(texty)+1) * sizeof(char));
    Init_String(label, texty, 0);
    
    check = false;
    cproc = false;
    click = NULL;
}
CheckBox::CheckBox(short xLocation, short yLocation, char *texty, void (*proc)(bool)) {
    xPos = xLocation;
    yPos = yLocation;
    ref = NULL;
    
    label = (char *)malloc((strlen(texty)+1) * sizeof(char));
    Init_String(label, texty, 0);
    
    check = false;
    cproc = true;
    click = proc;
}
bool CheckBox::State(bool state) {
    if(ref == NULL) {
        check = state;
        return check;
    } else {
        *ref = state;
        return *ref;
    }
}
bool CheckBox::Check(short xLocation, short yLocation) {
    if(mouse_inarea(xPos + xLocation, yPos + yLocation, 12, 12)) {
        if(mouse_b & 1) {
            if(ref == NULL && press == false) {
                if(check == true) {
                    check = false;
                } else {
                    check = true;
                }
                if(cproc) click(check);
            } else if(press == false) {
                if(*ref == true) {
                    *ref = false;
                } else {
                    *ref = true;
                }
                if(cproc) click(*ref);
            }
            press = true;
            return true;
        } else {
            press = false;
        }
    }
    return false;
}
void CheckBox::Draw(BITMAP *output, short xLocation, short yLocation) {
    text_box(output, xPos + xLocation, yPos + yLocation, 12, 12, makecol(64,64,64), NULL);
    if(ref == NULL) {
        if(check == true) {
            draw_sprite(output, BoxCheck, xPos + xLocation, yPos + yLocation - 4);
        }
    } else {
        if(*ref == true) {
            draw_sprite(output, BoxCheck, xPos + xLocation, yPos + yLocation - 4);
        }
    }
    if(label != NULL) {
        textprintf(output, font, xPos + xLocation + 17, yPos + yLocation + 3, 0, "%s", label);
        textprintf(output, font, xPos + xLocation + 16, yPos + yLocation + 2, 65535, "%s", label);
    }
}
