#include "commonheaders.h"
#include "cls-window.h"
#include "cls-windraw.h"

Button::Button(short xLocation, short yLocation, short winWidth, short winHeight, char *text, void (*funct)(void)) {
    label = (char *)malloc(strlen(text)+1);
    Init_String(label, text, 0);
    xPos = xLocation;
    yPos = yLocation;
    width = winWidth;
    height = winHeight;
    pressed = false;
    press = funct;
    
    image = NULL;
    pressimage = NULL;
}

Button::Button(short xLocation, short yLocation, short winWidth, short winHeight, BITMAP *mainImage, void (*funct)(void)) {
    xPos = xLocation;
    yPos = yLocation;
    width = winWidth;
    image = mainImage;
    height = winHeight;
    pressed = false;
    press = funct;
    
    label = NULL;
    pressimage = NULL;
}

Button::Button(short xLocation, short yLocation, short winWidth, short winHeight, BITMAP *mainImage, BITMAP *switchimage, void (*funct)(void)) {
    xPos = xLocation;
    yPos = yLocation;
    width = winWidth;
    image = mainImage;
    height = winHeight;
    pressimage = switchimage;
    pressed = false;
    press = funct;
    
    label = NULL;
}
bool Button::Check(short xLocation, short yLocation) {
    if(mouse_inarea(xPos + xLocation, yPos + yLocation, width, height)) {
        if(mouse_b & 1) {
            pressed = true;
        } else {
            if(pressed) {
                press();
                pressed = false;
            }
        }
    } else {
        if(pressed) pressed = false;  
    }
    return false;
}
void Button::Draw(BITMAP *output, short xLocation, short yLocation) {
    if(image == NULL) {
        button(output, xPos + xLocation, yPos + yLocation, width, height, makecol(96, 96, 96), pressed, NULL, label);
    } else {
        if(pressed && pressimage != NULL) {
            button(output, xPos + xLocation, yPos + yLocation, width, height, makecol(96, 96, 96), pressed, pressimage, NULL);
        } else {
            button(output, xPos + xLocation, yPos + yLocation, width, height, makecol(96, 96, 96), pressed, image, NULL);
        }
    }
}
