#include "commonheaders.h"
#include "cls-menu.h"
#include "cls-window.h"
#include "initialization.h"
#include "winfunctions.h"
#include "window.h"

void OpenRoomDialog(void) {
    OpenWindow(RWin("New Room"));
    Windows[RWin("New Room")]->Set_Pos(main_width / 2 - 88, main_height / 2 - 40);
    Windows[RWin("New Room")]->TextBoxes[0]->StartInput();
    dialogmode = true;
    dialogwindow = RWin("New Room");
}
void ExitDialog(void) {
    destroy_bitmap(frozenbuf);
    frozenbuf = NULL;
    CloseWindow(dialogwindow);
    dialogmode = false;
    dialogwindow = 0;
}
/*void EditRoomName(char *stringy) {
    if(stringy[0] != '\0' && stringy[0] != ' ') {
        char *tempString = NULL;
        tempString = 
        if(Windows[RWin("Map Editor")]->ListBoxes[0]->ReplaceItem(stringy)) {
            Windows[RWin("Room Editor")]->ScrollBoxes[0]->AddItem(stringy);
            roomamount++;
            selectedroom = roomamount - 1;
        }
    }
}*/
void AppendRoom(char *stringy) {
    if(stringy[0] != '\0' && stringy[0] != ' ') {
        logprintf(" Adding Stringy %s", stringy);
        Windows[RWin("Map Editor")]->ListBoxes[0]->AddItem(stringy);
        Windows[RWin("Room Editor")]->ScrollBoxes[0]->AddItem(stringy);
        roomamount++;
        selectedroom = roomamount - 1;
        if(debug) logprintf("Added Room %s\n", stringy);
    	roomTiles = (ROOM *)qualloc(roomTiles, sizeof(ROOM) * roomamount);
    	//printf("R%i  &%i  MEM%i\n", roomamount, roomTiles[roomamount], sizeof(ROOM) * roomamount);
    	if(roomTiles == NULL) {
			allegro_message("Memory Error:\n    Memory for the room could not be allocated\n\nAborting Program");
			exit(1);
		}
        Init_String(roomTiles[roomamount - 1].name, stringy, 30);
    	roomTiles[roomamount - 1].xSize = 0;
    	roomTiles[roomamount - 1].ySize = 0;
    	roomTiles[roomamount - 1].itemamount = 0;
    	roomTiles[roomamount - 1].dooramount = 0;
    	roomTiles[roomamount - 1].breakamount = 0;
    	roomTiles[roomamount - 1].water_type = 0;
    	roomTiles[roomamount - 1].water_high = 0;
    	roomTiles[roomamount - 1].water_low = 0;
    	roomTiles[roomamount - 1].tunenum = 0;
    	roomTiles[roomamount - 1].tune_in = 0;
    	roomTiles[roomamount - 1].tune_out = 0;
    	roomTiles[roomamount - 1].tiles = NULL;
    	roomTiles[roomamount - 1].items = NULL;
    	roomTiles[roomamount - 1].breaks = NULL;
    	roomTiles[roomamount - 1].doors = NULL;
        Init_String(roomTiles[roomamount - 1].tune, "", 30);
    	roomTiles[roomamount - 1].doors = (struct door*)qualloc(roomTiles[roomamount - 1].doors, sizeof(struct door) * (roomTiles[roomamount - 1].dooramount + 1));
        roomTiles[roomamount - 1].doors[0].xPos = 0;
        roomTiles[roomamount - 1].doors[0].yPos = 0;
        roomTiles[roomamount - 1].doors[0].type = 0;
        roomTiles[roomamount - 1].doors[0].direction = 0;
        Init_String(roomTiles[roomamount - 1].doors[0].levelname, "", 30);
        roomTiles[roomamount - 1].doors[0].doordrop = 0;
    }

    destroy_bitmap(frozenbuf);
    frozenbuf = NULL;
    CloseWindow(dialogwindow);
    dialogmode = false;
    dialogwindow = 0;
}
void AppendRoomButton(void) {
    char *tempstr;
    tempstr = (char *)qualloc(sizeof(char) * Windows[RWin("New Room")]->TextBoxes[0]->GetString(NULL));
    Windows[RWin("New Room")]->TextBoxes[0]->GetString(tempstr);
    Windows[RWin("New Room")]->TextBoxes[0]->CancelInput();
    if(tempstr[0] != '\0' && tempstr[0] != ' ') {
        Windows[RWin("Map Editor")]->ListBoxes[0]->AddItem(tempstr);
        Windows[RWin("Room Editor")]->ScrollBoxes[0]->AddItem(tempstr);
        roomamount ++;
        selectedroom = roomamount - 1;
    	roomTiles = (ROOM *)qualloc(roomTiles, sizeof(ROOM) * roomamount);
        if(roomTiles == NULL) {
			allegro_message("Memory Error:\n    Memory for the room could not be allocated\n\nAborting Program");
			exit(1);
		}
        Init_String(roomTiles[roomamount - 1].name, tempstr, 30);
    	roomTiles[roomamount - 1].xSize = 0;
    	roomTiles[roomamount - 1].ySize = 0;
    	roomTiles[roomamount - 1].itemamount = 0;
    	roomTiles[roomamount - 1].dooramount = 0;
    	roomTiles[roomamount - 1].breakamount = 0;
    	roomTiles[roomamount - 1].water_type = 0;
    	roomTiles[roomamount - 1].water_high = 0;
    	roomTiles[roomamount - 1].water_low = 0;
    	roomTiles[roomamount - 1].tunenum = 0;
    	roomTiles[roomamount - 1].tune_in = 0;
    	roomTiles[roomamount - 1].tune_out = 0;
    	roomTiles[roomamount - 1].tiles = NULL;
    	roomTiles[roomamount - 1].items = NULL;
    	roomTiles[roomamount - 1].breaks = NULL;
    	roomTiles[roomamount - 1].doors = NULL;
        Init_String(roomTiles[roomamount - 1].tune, "", 30);
    	roomTiles[roomamount - 1].doors = (struct door*)qualloc(roomTiles[roomamount - 1].doors, sizeof(struct door) * (roomTiles[roomamount - 1].dooramount + 1));
        roomTiles[roomamount - 1].doors[0].xPos = 0;
        roomTiles[roomamount - 1].doors[0].yPos = 0;
        roomTiles[roomamount - 1].doors[0].type = 0;
        roomTiles[roomamount - 1].doors[0].direction = 0;
        Init_String(roomTiles[roomamount - 1].doors[0].levelname, "", 30);
        roomTiles[roomamount - 1].doors[0].doordrop = 0;
    }
    
    free(tempstr);
    destroy_bitmap(frozenbuf);
    frozenbuf = NULL;
    CloseWindow(dialogwindow);
    dialogmode = false;
    dialogwindow = 0;
    //Windows[WinMapEdit]->ScrollBoxes[0]->ModInt(0, roomamount, 1);
}

void ImportRoom(char *stringy) 
{ 
    Import_Level(stringy, true); 
}
void ImportRoomButton(void) 
{ 
    char *tempstr;
    tempstr = (char *)qualloc(sizeof(char) * Windows[RWin("Import Room")]->TextBoxes[0]->GetString(NULL));
    Windows[RWin("Import Room")]->TextBoxes[0]->GetString(tempstr);
    Windows[RWin("Import Room")]->TextBoxes[0]->CancelInput();
    Import_Level(tempstr, true);
    free(tempstr);
}

void ExportRoom(char *stringy) 
{ 
    Export_Level(stringy, true); 
}
void ExportRoomButton(void) 
{ 
    char *tempstr;
    tempstr = (char *)qualloc(sizeof(char) * Windows[RWin("Export Room")]->TextBoxes[0]->GetString(NULL));
    Windows[RWin("Export Room")]->TextBoxes[0]->GetString(tempstr);
    Windows[RWin("Export Room")]->TextBoxes[0]->CancelInput();
    Export_Level(tempstr, true);
    free(tempstr);
}

void SaveRoom(char *stringy) 
{ 
    Save_Area(stringy); 
}
void SaveRoomButton(void) 
{ 
    char *tempstr;
    tempstr = (char *)qualloc(sizeof(char) * Windows[RWin("Save Room")]->TextBoxes[0]->GetString(NULL));
    Windows[RWin("Save Room")]->TextBoxes[0]->GetString(tempstr);
    Windows[RWin("Save Room")]->TextBoxes[0]->CancelInput();
    Save_Area(tempstr);
    free(tempstr);
}

void LoadRoom(char *stringy) 
{ 
    Load_Area(stringy); 
}
void LoadRoomButton(void) 
{ 
    char *tempstr;
    tempstr = (char *)qualloc(sizeof(char) * Windows[RWin("Load Room")]->TextBoxes[0]->GetString(NULL));
    Windows[RWin("Load Room")]->TextBoxes[0]->GetString(tempstr);
    Windows[RWin("Load Room")]->TextBoxes[0]->CancelInput();
    Load_Area(tempstr);
    free(tempstr);
}

void DeleteRoom(void) {
    if(debug) logprintf("\nRemoving Room #%i\n", selectedroom + 1);
    for(short y = 0; y < MapYSize; y ++) {
        for(short x = 0; x < MapXSize; x ++) {
            if(MapGrid[y][x] == selectedroom + 1) {
                MapGrid[y][x] = 0;
                MapSpec[y][x] = 0;
            } else if(MapGrid[y][x] > selectedroom + 1) {
                MapGrid[y][x] --;
            }
        }
    }
    if(debug) logprintf("Removed Room from Map\n");
    for(short i = selectedroom; i < roomamount; i++) {
        roomTiles[i] = roomTiles[i + 1];
    }
    if(debug) logprintf("Reordered List\n");
    Windows[RWin("Room Editor")]->ScrollBoxes[0]->EraseItem(selectedroom);
    if(debug) logprintf("Removed Room from Room Editor\n");
    Windows[RWin("Map Editor")]->ListBoxes[0]->EraseItem(selectedroom);
    if(debug) logprintf("Removed Room from Map Editor\n");
    Windows[RWin("Map Editor")]->Viewports[0]->Refresh();
    if(debug) logprintf("Removed Room from Objects\n");
    if(roomamount > 0) roomamount --;
    if(roomTiles != NULL) {
    	roomTiles = (ROOM *)qualloc(roomTiles, sizeof(ROOM) * roomamount);
    	if(roomamount == 0) roomTiles = NULL;
    	if(debug) logprintf("Qualloced Memory\n");
	}
}
void ClearRoom(void) {
    for(short y = 0; y < MapYSize; y ++) {
        for(short x = 0; x < MapXSize; x ++) {
            if(MapGrid[y][x] == selectedroom + 1) {
                MapGrid[y][x] = 0;
                MapSpec[y][x] = 0;
            }
        }
    }
}
void ClearAll(void) {
    for(short y = 0; y < MapYSize; y ++) {
        for(short x = 0; x < MapXSize; x ++) {
            MapGrid[y][x] = 0;
            MapSpec[y][x] = 0;
        }
    }
}
void EditRoom(void) {
    printf("Edit %i", selectedroom);
	if ( roomamount > 0 ) {
        clear_keybuf();
        short ystart = -1, yend = -1;
        short xstart = -1, xend = -1;
        for ( short y = 0; y < MapYSize; y ++ ) 
        {
            for ( short x = 0; x < MapXSize; x ++ ) 
            {
                if ( MapGrid[y][x] == selectedroom + 1 && MapSpec[y][x] != 6 ) 
                {
                    // Set starting position
                    if ( ystart == -1 ) 
                    {
                        ystart = y;
                        yend = y;
                    } 
                    // Move the starting position
                    else if ( y < ystart ) 
                    {
                        ystart = y;
                    }
                    // Set ending position
                    if ( y > yend ) 
                    {
                        yend = y;
                    }
                    // Set starting position
                    if ( xstart == -1 ) 
                    {
                        xstart = x;
                        xend = x;
                    } 
                    // Move the starting position
                    else if ( x < xstart ) 
                    {
                        xstart = x;
                    }
                    // Set ending position
                    if ( x > xend ) 
                    {
                        xend = x;
                    }
                }
            }
        }
        yend ++;
        xend ++;
        if( ystart > -1 && xstart > -1 ) 
        {
            printf("Allocating Room %i...\nRoom Size: ", selectedroom);
            printf("%ix%i\n", (xend - xstart) * 64, (yend - ystart) * 48);
            printf("Memory Needed:%i\n", (xend - xstart) * 16 * sizeof(unsigned short *)*  (yend - ystart) * 16 * sizeof(unsigned short *));
        	//printf("R%i  &%i\n ", roomamount, roomTiles[roomamount - 1]);
            
            printf("Element Satus: ");
    		printf("%p\n", roomTiles[selectedroom].tiles);
            
            if ( roomTiles[selectedroom].tiles == NULL ) 
            {
                roomTiles[selectedroom].tiles = (struct tile **)qualloc(roomTiles[selectedroom].tiles, sizeof(struct tile *) * (yend - ystart) * 16);
                memset(roomTiles[selectedroom].tiles, 0, sizeof(unsigned short *) * (yend - ystart) * 16);
            } 
            else  
            {
                roomTiles[selectedroom].tiles = (struct tile **)qualloc(roomTiles[selectedroom].tiles, sizeof(struct tile *) * (yend - ystart) * 16);
                if ( (yend - ystart) * 16 > roomTiles[selectedroom].ySize ) 
                {
                    for ( short i = roomTiles[selectedroom].ySize; i < (yend - ystart) * 16; i ++ ) 
                    {
                        roomTiles[selectedroom].tiles[i] = NULL;
                    }
                }
            }
            
            roomTiles[selectedroom].ySize = (yend - ystart) * 16;
            
            printf("Allocating Rows...\n");
            for ( short i = 0; i < roomTiles[selectedroom].ySize; i ++ )
            {
                if(i == 0) printf("Row Number: %i", i);
                else       printf(", %i ", i);
                //PrintLoc();
                if ( roomTiles[selectedroom].tiles[i] == NULL )
                {
                    roomTiles[selectedroom].tiles[i] = (struct tile *)qualloc(roomTiles[selectedroom].tiles[i], sizeof(struct tile) * (xend - xstart) * 16);
                    memset(roomTiles[selectedroom].tiles[i], 0, sizeof(struct tile *) * (xend - xstart) * 16);
                }
                else 
                {
                    roomTiles[selectedroom].tiles[i] = (struct tile *)qualloc(roomTiles[selectedroom].tiles[i], sizeof(struct tile) * (xend - xstart) * 16);
                    if ( (xend - xstart) * 16 > roomTiles[selectedroom].xSize ) 
                    {
                        for ( short j = roomTiles[selectedroom].xSize; j < (xend - xstart) * 16; j ++ )
                         {
                            roomTiles[selectedroom].tiles[i][j].tileval = 0;
                        }
                        
                    }
                }
            }
            roomTiles[selectedroom].xSize = (xend - xstart) * 16;
            printf("\nRoom Allocation Complete.\n", (xend - xstart) * 16, (yend - ystart) * 16);
            selecteddoor = roomTiles[selectedroom].dooramount + 1;
            Windows[RWin("Room Editor")]->Viewports[0]->ResizeIn(roomTiles[selectedroom].xSize, roomTiles[selectedroom].ySize);
            Windows[RWin("Doors")]->ScrollBoxes[0]->ModInt(1, roomTiles[selectedroom].dooramount + 1, 1);
            if(Window_is_open(RWin("Map Editor"))) {
                if(Window_is_open(RWin("Map Editor"))) {
                    CloseWindow(RWin("Map Editor"));
                    winMapEdit = false;
                }
                if(!Window_is_open(RWin("Room Editor"))) {
                    OpenWindow(RWin("Room Editor"));
                    winRoomEdit = true;
                }
            }
            printf("Changed Viewport\n");
        } else {
            Windows[RWin("Room Editor")]->Viewports[0]->ResizeIn(0, 0);
            if(Window_is_open(RWin("Map Editor"))) {
                if(Window_is_open(RWin("Map Editor"))) {
                    CloseWindow(RWin("Map Editor"));
                    winMapEdit = false;
                }
                if(!Window_is_open(RWin("Room Editor"))) {
                    OpenWindow(RWin("Room Editor"));
                    winRoomEdit = true;
                }
            }
        }
	}
}
void DoorRoomDrop(char *stringy)
{
    Init_String(roomdrop, stringy, 30);
    if(roomTiles != NULL && roomamount > 0)
    {
        if(roomTiles[selectedroom].doors != NULL)
        {
            Init_String(roomTiles[selectedroom].doors[selecteddoor - 1].levelname, roomdrop, 30);
        }
    }
}
void SetEditDoor(void)
{
    if(roomTiles != NULL && roomamount > 0)
    {
        if(roomTiles[selectedroom].doors != NULL)
        {
            selecteddoortype = roomTiles[selectedroom].doors[selecteddoor - 1].direction;
            printf("%s|%s\n", roomdrop, roomTiles[selectedroom].doors[selecteddoor - 1].levelname);
            if(strcasecmp(roomdrop, roomTiles[selectedroom].doors[selecteddoor - 1].levelname))
            {
                Init_String(roomdrop, roomTiles[selectedroom].doors[selecteddoor - 1].levelname, 30);
                CheckExitDoors();
            }
            Windows[RWin("Doors")]->TextBoxes[0]->SetInput(roomdrop);
            selectedexit = roomTiles[selectedroom].doors[selecteddoor - 1].doordrop;
            ChangeExitDoors();
        }
    }
    Windows[RWin("Room Editor")]->Viewports[0]->Refresh();
}
void SetDoorType(void)
{
    if(roomTiles != NULL && roomamount > 0)
    {
        if(roomTiles[selectedroom].doors != NULL)
        {
            roomTiles[selectedroom].doors[selecteddoor - 1].type = selecteddooredit;
        }
    }
}
void CheckExitDoors(void) 
{
    Import_Doors(roomdrop);
    selectedexit = 1;
    if(roomTiles != NULL && roomamount > 0)
    {
        if(roomTiles[selectedroom].doors != NULL)
        {
            Init_String(roomTiles[selectedroom].doors[selecteddoor - 1].levelname, roomdrop, 30);
            roomTiles[selectedroom].doors[selecteddoor - 1].doordrop = selectedexit;
	    }
    }
    Windows[RWin("Doors")]->TextBoxes[0]->SetInput(roomdrop);
    if(exitamount > 0) {
		if(selectedexit <= exitamount) 
		{
    		char tempString[30];
    		itoa(exitdoors[selectedexit - 1].doordrop, tempString, 10);
    		Windows[RWin("Doors")]->Labels[8]->SetText(tempString);
    		Windows[RWin("Doors")]->Labels[6]->SetText(exitdoors[selectedexit - 1].levelname);
		} 
		else
		{
    		Windows[RWin("Doors")]->Labels[6]->SetText("Invalid Door");
    		Windows[RWin("Doors")]->Labels[8]->SetText("");
		}
	}
    else {
    	Windows[RWin("Doors")]->Labels[6]->SetText("No Doors Exist");
    	Windows[RWin("Doors")]->Labels[8]->SetText("");
	}
}
void ChangeExitDoors(void) {
    if(roomTiles != NULL && roomamount > 0)
    {
        if(roomTiles[selectedroom].doors != NULL)
        {
            roomTiles[selectedroom].doors[selecteddoor - 1].doordrop = selectedexit;
    	}
	}
    if(exitamount > 0) {
		if(selectedexit <= exitamount) 
		{
    		char tempString[30];
    		itoa(exitdoors[selectedexit - 1].doordrop, tempString, 10);
    		Windows[RWin("Doors")]->Labels[8]->SetText(tempString);
    		Windows[RWin("Doors")]->Labels[6]->SetText(exitdoors[selectedexit - 1].levelname);
		} 
		else
		{
    		Windows[RWin("Doors")]->Labels[6]->SetText("Invalid Door");
    		Windows[RWin("Doors")]->Labels[8]->SetText("");
		}
	}
    else {
    	Windows[RWin("Doors")]->Labels[6]->SetText("No Doors Exist");
    	Windows[RWin("Doors")]->Labels[8]->SetText("");
	}
}
void SetRoomMusic(void) {
    if(roomTiles != NULL) {
        roomTiles[selectedroom].tunenum = selectedtune; 
    }
}
void ExitRoomEdit(void) {
    if(!Window_is_open(RWin("Map Editor"))) {
        OpenWindow(RWin("Map Editor"));
        winMapEdit = true;
    }
    if(Window_is_open(RWin("Room Editor"))) {
        CloseWindow(RWin("Room Editor"));
        winRoomEdit = false;
    }
}
void UpRoom(void) 
{
    Windows[RWin("Room Editor")]->ScrollBoxes[0]->ItemUp(selectedroom);
    Windows[RWin("Map Editor")]->ListBoxes[0]->ItemUp(selectedroom);
    Windows[RWin("Map Editor")]->Viewports[0]->Refresh();
}
void DnRoom(void) {
    Windows[RWin("Room Editor")]->ScrollBoxes[0]->ItemDn(selectedroom);
    Windows[RWin("Map Editor")]->ListBoxes[0]->ItemDn(selectedroom);
    Windows[RWin("Map Editor")]->Viewports[0]->Refresh();
}
void SaveRoomName(bool save) 
{
    if(save == true) {
        Windows[RWin("New Room")]->TextBoxes[0]->SetRefmode(2);
    } else {
        Windows[RWin("New Room")]->TextBoxes[0]->SetRefmode(1);
    }
}
void SaveImportName(bool save) 
{
    if(save == true) {
        Windows[RWin("Import Room")]->TextBoxes[0]->SetRefmode(2);
    } else {
        Windows[RWin("Import Room")]->TextBoxes[0]->SetRefmode(1);
    }
}
void SaveExportName(bool save) 
{
    if(save == true) {
        Windows[RWin("Export Room")]->TextBoxes[0]->SetRefmode(2);
    } else {
        Windows[RWin("Export Room")]->TextBoxes[0]->SetRefmode(1);
    }
}

void Cut(void)
{
    if(selectX >= 0 || selectY >= 0 && selectedtool == 0 && !selectpress)
    {
        if(tilecopies != NULL)
        {
            short i = 0;
            while(tilecopies[i] != NULL)
            {
                free(tilecopies[i]);
                i ++;
            }
            free(tilecopies);
        }
        if(breakcopies != NULL)
        {
            breakcopyamount = 0;
            free(breakcopies);
        }
        copyX = 0;
        copyY = 0;
        tilecopies = (struct tile**)qualloc(tilecopies, sizeof(struct tile*) * (abs(selectY - selectY2) + 1));
        memset(tilecopies, 0, sizeof(struct tile*) * (abs(selectY - selectY2) + 1));
        copyX = (abs(selectX - selectX2) + 1);
        copyY = (abs(selectY - selectY2) + 1);
        short selectYDist = (selectY < selectY2 ? selectY : selectY2);
        short selectXDist = (selectX < selectX2 ? selectX : selectX2);
        for(short i = 0; i < (abs(selectY - selectY2) + 1); i ++)
        {
            tilecopies[i] = (struct tile*)qualloc(tilecopies[i], sizeof(struct tile) * (abs(selectX - selectX2) + 1));
            memset(tilecopies[i], 0, sizeof(struct tile) * (abs(selectX - selectX2) + 1));
            for(short j = 0; j < (abs(selectX - selectX2) + 1); j ++)
            {
                if(i + selectYDist < roomTiles[selectedroom].ySize && j + selectXDist < roomTiles[selectedroom].xSize)
                {
                    tilecopies[i][j].tileval = roomTiles[selectedroom].tiles[i + selectYDist][j + selectXDist].tileval;
                    tilecopies[i][j].flip = roomTiles[selectedroom].tiles[i + selectYDist][j + selectXDist].flip;
                    tilecopies[i][j].rotation = roomTiles[selectedroom].tiles[i + selectYDist][j + selectXDist].rotation;
                    tilecopies[i][j].foreground = roomTiles[selectedroom].tiles[i + selectYDist][j + selectXDist].foreground;
                    tilecopies[i][j].fade = roomTiles[selectedroom].tiles[i + selectYDist][j + selectXDist].fade;
                    tilecopies[i][j].clip = roomTiles[selectedroom].tiles[i + selectYDist][j + selectXDist].clip;
    				roomTiles[selectedroom].tiles[i + selectYDist][j + selectXDist].flip = 0;
    				roomTiles[selectedroom].tiles[i + selectYDist][j + selectXDist].rotation = 0;
    				roomTiles[selectedroom].tiles[i + selectYDist][j + selectXDist].foreground = 0;
    				roomTiles[selectedroom].tiles[i + selectYDist][j + selectXDist].fade = 0;
    				roomTiles[selectedroom].tiles[i + selectYDist][j + selectXDist].clip = 0;
    				roomTiles[selectedroom].tiles[i + selectYDist][j + selectXDist].tileval = 0;
    				short copynum = -1;
                    for(short k = 0; k < roomTiles[selectedroom].breakamount; k++)
                    {
                        if(roomTiles[selectedroom].breaks[k].x == j + selectXDist 
                        && roomTiles[selectedroom].breaks[k].y == i + selectYDist)
                        {
                            copynum = k;
                        }
                    }
                    if(copynum != -1)
                    {
                        breakcopyamount ++;
                        breakcopies = (struct breakable*)qualloc(breakcopies, sizeof(struct breakable) * breakcopyamount);
                        Copy_Structure((unsigned char *)(&roomTiles[selectedroom].breaks[copynum]), sizeof(struct breakable), (unsigned char *)(&breakcopies[breakcopyamount - 1]));
                        for(short k = copynum; k < roomTiles[selectedroom].breakamount - 1; k++)
                        {
                            roomTiles[selectedroom].breaks[k] = roomTiles[selectedroom].breaks[k + 1];
                        }
                        roomTiles[selectedroom].breakamount --;
                        roomTiles[selectedroom].breaks = (struct breakable*)qualloc(roomTiles[selectedroom].breaks, sizeof(struct breakable) * roomTiles[selectedroom].breakamount);
                    }
                }
            }
        }
    }
    Windows[RWin("Room Editor")]->Viewports[0]->Refresh();
}
void Copy(void)
{
    if(selectX >= 0 || selectY >= 0 && selectedtool == 0 && !selectpress)
    {
        if(tilecopies != NULL)
        {
            short i = 0;
            while(tilecopies[i] != NULL)
            {
                free(tilecopies[i]);
                i ++;
            }
            free(tilecopies);
        }
        if(breakcopies != NULL)
        {
            breakcopyamount = 0;
            free(breakcopies);
        }
        copyX = 0;
        copyY = 0;
        tilecopies = (struct tile**)qualloc(tilecopies, sizeof(struct tile*) * (abs(selectY - selectY2) + 1));
        memset(tilecopies, 0, sizeof(struct tile*) * (abs(selectY - selectY2) + 1));
        copyX = (abs(selectX - selectX2) + 1);
        copyY = (abs(selectY - selectY2) + 1);
        short selectYDist = (selectY < selectY2 ? selectY : selectY2);
        short selectXDist = (selectX < selectX2 ? selectX : selectX2);
        for(short i = 0; i < (abs(selectY - selectY2) + 1); i ++)
        {
            tilecopies[i] = (struct tile*)qualloc(tilecopies[i], sizeof(struct tile) * (abs(selectX - selectX2) + 1));
            memset(tilecopies[i], 0, sizeof(struct tile) * (abs(selectX - selectX2) + 1));
            for(short j = 0; j < (abs(selectX - selectX2) + 1); j ++)
            {
                if(i + selectYDist < roomTiles[selectedroom].ySize && j + selectXDist < roomTiles[selectedroom].xSize)
                {
                    tilecopies[i][j].tileval = roomTiles[selectedroom].tiles[i + selectYDist][j + selectXDist].tileval;
                    tilecopies[i][j].flip = roomTiles[selectedroom].tiles[i + selectYDist][j + selectXDist].flip;
                    tilecopies[i][j].rotation = roomTiles[selectedroom].tiles[i + selectYDist][j + selectXDist].rotation;
                    tilecopies[i][j].foreground = roomTiles[selectedroom].tiles[i + selectYDist][j + selectXDist].foreground;
                    tilecopies[i][j].fade = roomTiles[selectedroom].tiles[i + selectYDist][j + selectXDist].fade;
                    tilecopies[i][j].clip = roomTiles[selectedroom].tiles[i + selectYDist][j + selectXDist].clip;
    				short copynum = -1;
                    for(short k = 0; k < roomTiles[selectedroom].breakamount; k++)
                    {
                        if(roomTiles[selectedroom].breaks[k].x == j + selectXDist 
                        && roomTiles[selectedroom].breaks[k].y == i + selectYDist)
                        {
                            copynum = k;
                        }
                    }
                    if(copynum != -1)
                    {
                        breakcopyamount ++;
                        breakcopies = (struct breakable*)qualloc(breakcopies, sizeof(struct breakable) * breakcopyamount);
                        Copy_Structure((unsigned char *)(&roomTiles[selectedroom].breaks[copynum]), sizeof(struct breakable), (unsigned char *)(&breakcopies[breakcopyamount - 1]));
                    }
                }
            }
        }
    }
    Windows[RWin("Room Editor")]->Viewports[0]->Refresh();
}
void Paste(void)
{
    pasteit = true;
    Windows[RWin("Room Editor")]->Viewports[0]->Refresh();
}
void Clear(void)
{
    if(selectX >= 0 || selectY >= 0 && selectedtool == 0 && !selectpress)
    {
        short selectYDist = (selectY < selectY2 ? selectY : selectY2);
        short selectXDist = (selectX < selectX2 ? selectX : selectX2);
        for(short i = 0; i < (abs(selectY - selectY2) + 1); i ++)
        {
            for(short j = 0; j < (abs(selectX - selectX2) + 1); j ++)
            {
                if(i + selectYDist < roomTiles[selectedroom].ySize && j + selectXDist < roomTiles[selectedroom].xSize)
                {
                    roomTiles[selectedroom].tiles[i + selectYDist][j + selectXDist].flip = 0;
    				roomTiles[selectedroom].tiles[i + selectYDist][j + selectXDist].rotation = 0;
    				roomTiles[selectedroom].tiles[i + selectYDist][j + selectXDist].foreground = 0;
    				roomTiles[selectedroom].tiles[i + selectYDist][j + selectXDist].fade = 0;
    				roomTiles[selectedroom].tiles[i + selectYDist][j + selectXDist].clip = 0;
    				roomTiles[selectedroom].tiles[i + selectYDist][j + selectXDist].tileval = 0;
    				short copynum = -1;
                    for(short k = 0; k < roomTiles[selectedroom].breakamount; k++)
                    {
                        if(roomTiles[selectedroom].breaks[k].x == j + selectXDist 
                        && roomTiles[selectedroom].breaks[k].y == i + selectYDist)
                        {
                            copynum = k;
                        }
                    }
                    if(copynum != -1)
                    {
                        for(short k = copynum; k < roomTiles[selectedroom].breakamount - 1; k++)
                        {
                            roomTiles[selectedroom].breaks[k] = roomTiles[selectedroom].breaks[k + 1];
                        }
                        roomTiles[selectedroom].breakamount --;
                        roomTiles[selectedroom].breaks = (struct breakable*)qualloc(roomTiles[selectedroom].breaks, sizeof(struct breakable) * roomTiles[selectedroom].breakamount);
                    }
                }
            }
        }
    }
    Windows[RWin("Room Editor")]->Viewports[0]->Refresh();
}

void Set_Screen(void) 
{
    if(main_size == 0) {
        main_width = 640;
        main_height = 480;
    } else if(main_size == 1) {
        main_width = 800;
        main_height = 600;
    } else if(main_size == 2) {
        main_width = 848;
        main_height = 480;
    } else if(main_size == 3) {
        main_width = 960;
        main_height = 600;
    } else if(main_size == 4) {
        main_width = 1024;
        main_height = 768;
    }
    for(short i = 0; i < WindowAmount; i ++) {
        Windows[i]->In_Screen();
    }
    short msx = mouse_x;
    short msy = mouse_y;
    if(fullscreen)
        set_gfx_mode(GFX_DIRECTX_ACCEL, main_width, main_height, 0, 0);  //Set the screen resolution
    else
        set_gfx_mode(GFX_DIRECTX_WIN, main_width, main_height, 0, 0);  //Set the screen resolution
    if((buffer = create_bitmap(main_width, main_height)) == NULL) {
        allegro_message("Image Error:\n    The screen buffer could not be created.\n\nAborting Program");
        exit(1);
    }
    clear_to_color(buffer, BLACK);
    mouse_x = msx;
    mouse_y = msy;
}

void Clear_Area ( void )
{
    for( short y = MapYSize - 1; y >= 0; y -- ) 
    {
        //free ( MapGrid[y] );
        //free ( MapSpec[y] );
        memset ( MapGrid[y],  0, MapXSize );
        memset ( MapSpec[y],  0, MapXSize );
    }
    //free( MapGrid );
    //free( MapSpec );
    //MapXSize = 0;
    //MapYSize = 0;
    //Windows[RWin("Map Editor")]->Viewports[0]->ResizeIn(MapXSize, MapYSize);
    
    if ( roomTiles != NULL )
    {
        for ( short i = roomamount - 1; i >= 0; i-- ) 
        {
            if ( roomTiles[i].tiles != NULL )
            {
                for ( short j = roomTiles[i].ySize; j > 0; j-- ) 
                {
                    if ( roomTiles[i].tiles[j] != NULL )
                    {
                        free ( roomTiles[i].tiles[j] );
                    }
                }
                free ( roomTiles[i].tiles );
                roomTiles[i].xSize = 0;
                roomTiles[i].ySize = 0;
            }
            if ( roomTiles[i].doors != NULL )
            {
                free ( roomTiles[i].doors );
                roomTiles[i].dooramount = 0;
            }
            if ( roomTiles[i].breaks != NULL )
            {
                free ( roomTiles[i].breaks );
                roomTiles[i].breakamount = 0;
            }
            if ( roomTiles[i].items != NULL )
            {
                free ( roomTiles[i].items );
                roomTiles[i].itemamount = 0;
            }
            Windows[RWin("Room Editor")]->ScrollBoxes[0]->EraseItem(i);
            Windows[RWin("Map Editor")]->ListBoxes[0]->EraseItem(i);
        }
        free ( roomTiles );
    }
    roomamount = 0;
    Windows[RWin("Map Editor")]->Viewports[0]->Refresh();
}
