
#include "commonheaders.h"
#include "cls-window.h"
#include "window.h"

short StackHeight = 0;
short WindowAmount = 0;
short *WindowStack = NULL;
Window **Windows = NULL;

void WinInit(void) {
    if(debug) logputs("GUI Initialization Sequence:\n\n");
    WindowAmount = 0;
    StackHeight = 0;
	if(WindowStack != NULL) {
		free(WindowStack);
		WindowStack = NULL;
	}
    if(debug) logputs("\tAllocating Window Stack Memory...");
    // Allocate stack memory
    if((WindowStack = (short *)qualloc(WindowStack, (StackHeight + 1) * sizeof(short))) == NULL) {
        allegro_message("Memory Error:\n    Could not allocate space for the window stack.\n\nAborting Program.");
        exit(1);
    }
    if(debug) logputs("Success.\n\n");
    WindowStack[StackHeight] = -1;
    Windows = NULL;
}

void NewWindow(short xLocation, short yLocation, short winWidth, short winHeight, char *title, void (*funct)(void)) 
{
    if(debug) 
    {
        logputs("\t\tCreating \"");
        logputs(title);
        logputs("\" Window...");
    }
    Windows = (Window **)qualloc(Windows, sizeof(Window *) * (WindowAmount + 1));
    // Create new window
    if((Windows[WindowAmount] = new Window(xLocation, yLocation, winWidth, winHeight, title, funct)) == NULL) {
        allegro_message("Declaration Error:\n    Could not create window #%i.\n\nAborting Program.", WindowAmount);
        exit(1);
    }
    if(debug) logputs("Success.\n");
    WindowAmount ++;
}

int RWin(char winname[]) {
    for(short i = 0; i <WindowAmount; i++) {
        if(!strcasecmp(Windows[i]->WindowTitle(), winname)) {
            return i;
        }
    }
}

bool OpenWindow(short winNum) {
    if(Windows[winNum] != NULL) {
        WindowStack[StackHeight] = winNum;
        Windows[WindowStack[StackHeight]]->Open();
        StackHeight ++;
        if((WindowStack = (short *)qualloc(WindowStack, (StackHeight + 1) * sizeof(short))) == NULL) {
            allegro_message("Memory Error:\n    Could not allocate space for the window stack.\n\nAborting Program.");
            exit(1);
        }
        WindowStack[StackHeight] = -1;
        return true;
    } else {
        return false;
    }
}

bool CloseWindow(short winNum) {
    short i = StackHeight - 1;
    while(i >= 0 && WindowStack[i] != winNum) {
        i--;
    }
    if(i >= 0) {
        if(StackHeight > 1) {
            // Reorder the window stack
            for(short j = i; j < StackHeight - 1; j ++) {
                WindowStack[j] = WindowStack[j + 1];
            }
            StackHeight --;
            if((WindowStack = (short *)qualloc(WindowStack, (StackHeight + 1) * sizeof(short))) == NULL) {
                allegro_message("Memory Error:\n    Could not allocate space for the window stack.\n\nAborting Program.");
                exit(1);
            }
            WindowStack[StackHeight] = -1;
        } else {
            // Remove the last window from the stack
            StackHeight --;
            if((WindowStack = (short *)qualloc(WindowStack, (StackHeight + 1)* sizeof(short))) == NULL) {
                allegro_message("Memory Error:\n    Could not allocate space for the window stack.\n\nAborting Program.");
                exit(1);
            }
            WindowStack[StackHeight] = -1;
        }
        return true;
    } else {
        return false;
    }
}

bool Window_is_open(short winNum) {
    for(short i = StackHeight - 1; i >= 0; i --) {
        if(WindowStack[i] == winNum) {
            return true;
        }
    }
    return false;
}

void ListWindows(void) {
    if(debug) printf("<=== Window Information ===>\n");
    if(debug) printf("Stack Height: %i\n", StackHeight);
    for(short i = StackHeight - 1; i >= 0; i --) {
        if(debug) printf("Stack #%i: %i\n", i, WindowStack[i]);
    }
}

void ProcessWindows(void) {
    short check;
    short intTemp;
    short i = StackHeight - 1;
    if(!dialogmode) {
        while(i >= 0) {
            if(WindowStack[i] >= 0) {
                if(Windows[WindowStack[i]] != NULL) {
                    check = Windows[WindowStack[i]]->Check();
                    if(check == -1) {
                        if(StackHeight > 1) {
                            for(short j = i; j < StackHeight - 1; j ++) {
                                WindowStack[j] = WindowStack[j + 1];
                            }
                            StackHeight --;
                            if((WindowStack = (short *)qualloc(WindowStack, (StackHeight + 1) * sizeof(short))) == NULL) {
                                allegro_message("Memory Error:\n    Could not allocate space for the window stack.\n\nAborting Program.");
                                exit(1);
                            }
                            WindowStack[StackHeight] = -1;
                        } else {
                            StackHeight --;
                            if((WindowStack = (short *)qualloc(WindowStack, (StackHeight + 1) * sizeof(short))) == NULL) {
                                allegro_message("Memory Error:\n    Could not allocate space for the window stack.\n\nAborting Program.");
                                exit(1);
                            }
                            WindowStack[StackHeight] = -1;
                        }
                    } else if(check == 1) {
                        if(i != StackHeight - 1) {
                            intTemp = WindowStack[i];
                            for(short j = i; j < StackHeight - 1; j ++) {
                                WindowStack[j] = WindowStack[j + 1];
                            }
                            WindowStack[StackHeight - 1] = intTemp;
                        }
                        i = -1;
                    }
                }
            }
            i--;
        }
    } else {
        if(Windows[dialogwindow] != NULL) {
            check = Windows[dialogwindow]->Check();
        }
    }
}

void DrawWindows(BITMAP *output) {
    if(!dialogmode || frozenbuf == NULL) {
        for(short i = 0; i < StackHeight; i ++) {
            if(WindowStack[i] > -1) {
                if(Windows[WindowStack[i]] != NULL) {
                    Windows[WindowStack[i]]->Draw(output);
                }
            }
        }
        if(dialogmode) {
            BITMAP *layer = create_bitmap(main_width, main_height);
        	if(layer == NULL) {
				allegro_message("Image Error:\n    Error Number: &W0L\n\nAborting Program");
        		exit(1);
			}
            clear_to_color(layer, makecol(0, 0, 0));
            set_trans_blender(0, 0, 0, 96);
            draw_trans_sprite(output, layer, 0, 0);
            destroy_bitmap(layer);
        }
    } else {
        if(Windows[dialogwindow] != NULL) {
            Windows[dialogwindow]->Draw(output);
        }
    }
}
