#include "commonheaders.h"
#include "cls-window.h"
#include "window.h"
#include "processing.h"


#ifndef PROCESSING_CPP
#define PROCESSING_CPP

void RefreshTilePreview(void) 
{
    BITMAP *temp = create_bitmap(16, 16);
    clear_to_color(temp, makecol(255,0,255));
    BITMAP *ex = create_bitmap(16, 16);
    clear_to_color(ex, makecol(255, 0, 255));
    if(selectedtile > 0 && selectedtile <= tileamount) {
        rotate_sprite(temp, TileImages[selectedtile - 1], 0, 0, itofix(selectedrot * 32));
		if(selectedflip == 0)
		  draw_sprite(ex, temp, 0, 0);
		else if(selectedflip == 1)
			draw_sprite_h_flip(ex, temp, 0, 0);
		else if(selectedflip == 2)
			draw_sprite_v_flip(ex, temp, 0, 0);
		else if(selectedflip == 3)
			draw_sprite_vh_flip(ex, temp, 0, 0);
    }
    //textprintf(ex, font, 0, 0, -1, "%i", roomTiles[selectedroom].tiles[yLocation][xLocation].tileval);
    //textprintf(ex, font, 0, 8, -1, "%i", roomTiles[selectedroom].tiles[yLocation][xLocation].clip);
	destroy_bitmap(temp);
    Windows[RWin("Tiles")]->Selectors[64]->FreeImage();
    Windows[RWin("Tiles")]->Selectors[64]->SetImage(ex);
}
void ProcessTiles(void) {
    if(selectedtile < (tilerow - 1) * 16 + 1 || selectedtile > (tilerow - 1) * 16 + 16) {
        tilerow = ((selectedtile - 1) / 16) + 1;
        for(short i = 0; i < 64; i ++) {
            if(TileImages[(tilerow - 1) * 16 + i] != NULL) {
                Windows[RWin("Tiles")]->Selectors[i]->Show();
                if((tilerow - 1) * 16 + i < tileamount)
                {
                    Windows[RWin("Tiles")]->Selectors[i]->SetImage(TileImages[(tilerow - 1) * 16 + i]);
                    Windows[RWin("Tiles")]->Selectors[i]->SetTrigger((tilerow - 1) * 16 + i + 1);
                }
                else
                {
                    Windows[RWin("Tiles")]->Selectors[i]->SetImage(TileImages[(tilerow - 1) * 16 + i - tileamount]);
                    Windows[RWin("Tiles")]->Selectors[i]->SetTrigger((tilerow - 1) * 16 + i - tileamount + 1);
                }
            } 
            else
            {
                Windows[RWin("Tiles")]->Selectors[i]->Hide();
            }
        }
    }
    RefreshTilePreview();
}
void ProcessRows(void) {
    if(selectedtile < (tilerow - 1) * 16 + 1) {
        selectedtile = (tilerow - 1) * 16 + (selectedtile % 16 == 0 ? 16 : selectedtile % 16);
    } else if(selectedtile > (tilerow - 1) * 16 + 16) {
        selectedtile = (tilerow - 1) * 16 + (selectedtile % 16 == 0 ? 16 : selectedtile % 16);
    }
    for(short i = 0; i < 64; i ++) {
        if(TileImages[(tilerow - 1) * 16 + i] != NULL) {
            Windows[RWin("Tiles")]->Selectors[i]->Show();
            if((tilerow - 1) * 16 + i < tileamount)
            {
                printf("%igrrr!\n", i);
                Windows[RWin("Tiles")]->Selectors[i]->SetImage(TileImages[(tilerow - 1) * 16 + i]);
                Windows[RWin("Tiles")]->Selectors[i]->SetTrigger((tilerow - 1) * 16 + i + 1);
            }
            else
            {
                printf("%irawr!\n", i);
                Windows[RWin("Tiles")]->Selectors[i]->SetImage(TileImages[(tilerow - 1) * 16 + i - tileamount]);
                Windows[RWin("Tiles")]->Selectors[i]->SetTrigger((tilerow - 1) * 16 + i - tileamount + 1);
            }
        } else {
            Windows[RWin("Tiles")]->Selectors[i]->Hide();
        }
    }
    RefreshTilePreview();
}

void ProcessClips(void) {
    if(selectedclip < (clippage - 1) * 12 + 1 || selectedclip > (clippage - 1) * 12 + 12) {
        clippage = ((selectedclip - 1) / 12) + 1;
        for(short i = 0; i < 36; i ++) {
            if((clippage - 1) * 12 + i < clipamount) {
                if(ClipImages[(clippage - 1) * 12 + i] != NULL) {
                    Windows[RWin("Clips")]->Selectors[i]->Show();
                    Windows[RWin("Clips")]->Selectors[i]->SetImage(ClipImages[(clippage - 1) * 12 + i]);
                    Windows[RWin("Clips")]->Selectors[i]->SetTrigger((clippage - 1) * 12 + i + 1);
                } else {
                    Windows[RWin("Clips")]->Selectors[i]->Hide();
                }
            }
            else {
                Windows[RWin("Clips")]->Selectors[i]->Hide();
            }
        }
    }
}
void ProcessClipRows(void) {
    if(selectedclip < (clippage - 1) * 36 + 1) {
        selectedclip = (clippage - 1) * 36 + (selectedclip % 36 == 0 ? 36 : selectedclip % 36);
    } else if(selectedclip > (clippage - 1) * 36 + 36) {
        selectedclip = (clippage - 1) * 36 + (selectedclip % 36 == 0 ? 36 : selectedclip % 36);
    }
    selectedclip = selectedclip > clipamount ? clipamount : selectedclip;
    for(short i = 0; i < 36; i ++) {
        if((clippage - 1) * 36 + i < clipamount) {
            if(ClipImages[(clippage - 1) * 36 + i] != NULL) {
                Windows[RWin("Clips")]->Selectors[i]->Show();
                Windows[RWin("Clips")]->Selectors[i]->SetImage(ClipImages[(clippage - 1) * 36 + i]);
                Windows[RWin("Clips")]->Selectors[i]->SetTrigger((clippage - 1) * 36 + i + 1);
            } else {
                Windows[RWin("Clips")]->Selectors[i]->Hide();
            }
        }
        else {
            Windows[RWin("Clips")]->Selectors[i]->Hide();
        }
    }
}
#endif
