struct tile {
    unsigned flip:2;  
    //Tile flipping: 0 = None, 1 = H Flip, 2 = V Flip, 4 = HV Flip
    unsigned rotation:2;
    //Rotation: 0 = none, 1 = -90, 2 = -180, 3 = -270
    unsigned foreground:1;
    //Foreground: 1(On)/0(Off)
    unsigned fade:1;
    //Transitional: 1(On)/0(Off)
    unsigned clip:10;
    //Clipping reference number
    unsigned tileval:16;
    //Tile reference number
};
struct breakable {
	short x;
	short y;
	tile tileinfo;
	// A tile, woof
	unsigned dir:4;
	//Chain Directions: 
    //      Bits:  0   0   0   0
    //             Lf  Rt  Dn  Up
	unsigned type:12;
	////Breaking Flags: 
    //      By 2^nth power: 
	//"Crumble", "Shootable", "Missile", "Super Missile", 
    //"Bombable", "Power Bomb", "Screw Attack", "Speed Booster"
	unsigned char timer;
	// Timer for block respawn
};
struct item {
	short xPos;
	short yPos;
	short type;
	// Image reference
};
struct door {
	short xPos;
	short yPos;
	short type;
	// Type: 0 = standard, 1 = ceres, 2 = missile, 3 = smissile, 4 = pbomb
	unsigned direction:2;
	// Direction: 0 = faces right, 1 = faces left, 2 = faces up, 3 = faces down
	char levelname[30];
	// Which level it goes to
	short doordrop;
	// The door in the level
};
typedef struct ROOM {
    int xSize;
    int ySize;
    int dooramount;
    int itemamount;
    int breakamount;
    
    char water_type;
    int water_high;
    int water_low;
    // Water Tide info
    
    int tune_in;
    int tune_out;
    // Danika rules!
    
    char *name;
    //Room Name (not using yet)
    char *tune;
    //Music Name (not using yet)
    
    struct tile **tiles;
    struct item *items;
    struct door *doors;
    struct breakable *breaks;
};


int load_level(FILE *level)
{
    level = fopen(leveldir, "rb+");
    
    //Editor version
    //   If you need to check it, it is now "SMTCLevEdit v0.8"
    fread(tempString, sizeof(char), 20, level);
    
    // Room Dims
    fread(&roomTiles[roomamount - 1].xSize, sizeof(short), 1, level);
    fread(&roomTiles[roomamount - 1].ySize, sizeof(short), 1, level);
    
    roomTiles[roomamount - 1].tiles = (struct tile **)realloc(roomTiles[roomamount - 1].tiles, sizeof(struct tile *) * roomTiles[roomamount - 1].ySize);
	if(roomTiles[roomamount - 1].tiles == NULL) {
		printf("Memory Error");
		readkey();
		exit(1);
	}
    memset(roomTiles[roomamount - 1].tiles, 0, sizeof(unsigned short *) * roomTiles[roomamount - 1].ySize);
    for(short i = 0; i < roomTiles[roomamount - 1].ySize; i ++)
    {
        roomTiles[roomamount - 1].tiles[i] = (struct tile *)realloc(roomTiles[roomamount - 1].tiles[i], sizeof(struct tile) * roomTiles[roomamount - 1].xSize);
        memset(roomTiles[roomamount - 1].tiles[i], 0, sizeof(struct tile *) * roomTiles[roomamount - 1].xSize);
    }
    
    // Load ze tiles
    for(short yloop = 0; yloop < roomTiles[roomamount - 1].ySize; yloop++)
    {
        for(short xloop = 0; xloop < roomTiles[roomamount - 1].xSize; xloop++)
        {
            fread(&roomTiles[roomamount - 1].tiles[yloop][xloop], sizeof(struct tile), 1, level);
        }
    }
    
    // Load the doors
    fread(&roomTiles[roomamount - 1].dooramount, sizeof(short), 1, level);
    roomTiles[roomamount - 1].doors = (struct door*)realloc(roomTiles[roomamount - 1].doors, sizeof(struct door) * roomTiles[roomamount - 1].dooramount);
    for(short i = 0; i < roomTiles[roomamount - 1].dooramount; i ++)
    {
        fread(&roomTiles[roomamount - 1].doors[i], sizeof(struct door), 1, level);
    }
    
    // Load the breakables
    fread(&roomTiles[roomamount - 1].breakamount, sizeof(short), 1, level);
    roomTiles[roomamount - 1].breaks = (struct breakable*)realloc(roomTiles[roomamount - 1].breaks, sizeof(struct breakable) * roomTiles[roomamount - 1].breakamount);
    for(short i = 0; i < roomTiles[roomamount - 1].breakamount; i ++)
    {
        fread(&roomTiles[roomamount - 1].breaks[i], sizeof(struct breakable), 1, level);
    }
    
    // Load the items
    fread(&roomTiles[roomamount - 1].itemamount, sizeof(short), 1, level);
    roomTiles[roomamount - 1].items = (struct item*)realloc(roomTiles[roomamount - 1].items, sizeof(struct item) * roomTiles[roomamount - 1].itemamount);
    for(short i = 0; i < roomTiles[roomamount - 1].itemamount; i ++)
    {
        fread(&roomTiles[roomamount - 1].items[i], sizeof(struct item), 1, level);
    }
}
