
#include "commonheaders.h"
#include "cls-menu.h"
#include "cls-window.h"
#include "initialization.h"
#include "menufunctions.h"
#include "window.h"

void OpenImportDialog(void) {
    OpenWindow(RWin("Import Room"));
    Windows[RWin("Import Room")]->Set_Pos(main_width / 2 - 160, main_height / 2 - 44);
    Windows[RWin("Import Room")]->TextBoxes[0]->StartInput();
    dialogmode = true;
    dialogwindow = RWin("Import Room");
}
void OpenExportDialog(void) {
    OpenWindow(RWin("Export Room"));
    Windows[RWin("Export Room")]->Set_Pos(main_width / 2 - 160, main_height / 2 - 44);
    Windows[RWin("Export Room")]->TextBoxes[0]->StartInput();
    dialogmode = true;
    dialogwindow = RWin("Export Room");
}
void OpenLoadDialog(void) {
    OpenWindow(RWin("Load Room"));
    Windows[RWin("Load Room")]->Set_Pos(main_width / 2 - 160, main_height / 2 - 44);
    Windows[RWin("Load Room")]->TextBoxes[0]->StartInput();
    dialogmode = true;
    dialogwindow = RWin("Load Room");
}
void OpenSaveDialog(void) {
    OpenWindow(RWin("Save Room"));
    Windows[RWin("Save Room")]->Set_Pos(main_width / 2 - 160, main_height / 2 - 44);
    Windows[RWin("Save Room")]->TextBoxes[0]->StartInput();
    dialogmode = true;
    dialogwindow = RWin("Save Room");
}
void OpenRoomProperties(void) {
    if(!Window_is_open(RWin("Room Properties"))) {
        OpenWindow(RWin("Room Properties"));
        winRoomProperties = true;
        if(roomTiles != NULL) selectedtune = roomTiles[selectedroom].tunenum;
    } else {
        CloseWindow(RWin("Room Properties"));
        winRoomProperties = false;
    }
}
void CloseRoomProperties(void) {
    winRoomProperties = false;
}
void OpenMapEdit(void) {
    if(!Window_is_open(RWin("Map Editor"))) {
        OpenWindow(RWin("Map Editor"));
        if(Window_is_open(RWin("Room Editor"))) {
            CloseWindow(RWin("Room Editor"));
            winRoomEdit = false;
        }
        winMapEdit = true;
    } else {
        CloseWindow(RWin("Map Editor"));
        winMapEdit = false;
    }
}
void CloseMapEdit(void) {
    winMapEdit = false;
}
void OpenOpts(void) {
    if(!Window_is_open(RWin("Options"))) {
        OpenWindow(RWin("Options"));
        winOpts = true;
    } else {
        CloseWindow(RWin("Options"));
        winOpts = false;
    }
}
void CloseOpts(void) {
    winOpts = false;
}

void OpenTileEdits(void) {
    if(!Window_is_open(RWin("Tiles"))) {
        OpenWindow(RWin("Tiles"));
        winTiles = true;
        if(!Window_is_open(RWin("Breakables"))) {
            OpenWindow(RWin("Breakables"));
            winBreakables = true;
        }
        if(!Window_is_open(RWin("Clips"))) {
            OpenWindow(RWin("Clips"));
            winClips = true;
        }
    } else {
        CloseWindow(RWin("Tiles"));
        winTiles = false;
        if(Window_is_open(RWin("Breakables"))) {
            CloseWindow(RWin("Breakables"));
            winBreakables = false;
        }
        if(Window_is_open(RWin("Clips"))) {
            CloseWindow(RWin("Clips"));
            winClips = false;
        }
    }
}

void OpenTiles(void) {
    if(!Window_is_open(RWin("Tiles"))) {
        OpenWindow(RWin("Tiles"));
        winTiles = true;
    } else {
        CloseWindow(RWin("Tiles"));
        winTiles = false;
    }
}
void CloseTiles(void) {
    winTiles = false;
}

void OpenClips(void) {
    if(!Window_is_open(RWin("Clips"))) {
        OpenWindow(RWin("Clips"));
        winClips = true;
    } else {
        CloseWindow(RWin("Clips"));
        winClips = false;
    }
}
void CloseClips(void) {
    winClips = false;
}

void OpenBreakables(void) {
    if(!Window_is_open(RWin("Breakables"))) {
        OpenWindow(RWin("Breakables"));
        winBreakables = true;
    } else {
        CloseWindow(RWin("Breakables"));
        winBreakables = false;
    }
}
void CloseBreakables(void) {
    winBreakables = false;
}

void OpenDoors(void) {
    if(!Window_is_open(RWin("Doors"))) {
        OpenWindow(RWin("Doors"));
        winDoors = true;
    } else {
        CloseWindow(RWin("Doors"));
        winDoors = false;
    }
}
void CloseDoors(void) {
    winDoors = false;
}

void OpenItems(void) {
    if(!Window_is_open(RWin("Items"))) {
        OpenWindow(RWin("Items"));
        winItems = true;
    } else {
        CloseWindow(RWin("Items"));
        winItems = false;
    }
}
void CloseItems(void) {
    winItems = false;
}

void OpenRoomEdit(void) {
    if(roomamount > 0) {
        if(!Window_is_open(RWin("Room Editor"))) {
            OpenWindow(RWin("Room Editor"));
            if(Window_is_open(RWin("Map Editor"))) {
                CloseWindow(RWin("Map Editor"));
                winMapEdit = false;
            }
            winRoomEdit = true;
        } else {
            CloseWindow(RWin("Room Editor"));
            winRoomEdit = false;
        }
    }
}
void CloseRoomEdit(void) {
    winRoomEdit = false;
}

void ViewGrids(void) {
    if(Windows[RWin("Map Editor")]->Viewports[0]->Grid(-1)) {
        Windows[RWin("Map Editor")]->Viewports[0]->Grid(0);
        Windows[RWin("Room Editor")]->Viewports[0]->Grid(0);
        Windows[RWin("Place Imported Room")]->Viewports[0]->Grid(0);
        showgrids = false;
    } else {
        Windows[RWin("Map Editor")]->Viewports[0]->Grid(1);
        Windows[RWin("Room Editor")]->Viewports[0]->Grid(1);
        Windows[RWin("Place Imported Room")]->Viewports[0]->Grid(1);
        showgrids = true;
    }
}
void ViewFades(void) {
    showfades = !showfades;
    Windows[RWin("Room Editor")]->Viewports[0]->Refresh();
}
void ViewClips(void) {
    showclips = !showclips;
    Windows[RWin("Room Editor")]->Viewports[0]->Refresh();
}
void ViewBreaks(void) {
    showbreaks = !showbreaks;
    Windows[RWin("Room Editor")]->Viewports[0]->Refresh();
}

void Exit(void) {
    quit = true;
}
void NULLF(void) {;}
void NULLF(char*) {;}
