#include <conio.h>
#include "commonheaders.h"
#include "cls-menu.h"
#include "cls-window.h"
#include "window.h"
#include "menufunctions.h"
#include "winfunctions.h"
#include "initialization.h"
#include "processing.h"

extern int speed_counter;
extern volatile int fps_counter, fps;

#define DMKEY "Software\\Justice Productions\\SMTC"

int main(int argc, char *argv[]) {
    
    HKEY hKey;
    LONG returnStatus;
    DWORD dwType=REG_SZ;
    DWORD dwSize=255;
    returnStatus = RegOpenKeyEx(HKEY_LOCAL_MACHINE, DMKEY, 0L,  KEY_ALL_ACCESS, &hKey);
    strcpy( install_path, "" );
    if (returnStatus == ERROR_SUCCESS)
    {
        returnStatus = RegQueryValueEx(hKey, "InstallPath", NULL, &dwType,(LPBYTE)&install_path, &dwSize);
        if (returnStatus == ERROR_SUCCESS)
        {
            printf("Value Read is %s\n", install_path);
        }
    }
    RegCloseKey(hKey);
    
    Initialize_Allegro();       // Initialize allegro system (INIT-ALLEGRO.CPP)
    
	set_window_title("SMTC Level Editor v0.8");  //Set Window Title
	set_window_close_hook(Exit);                 // Set close button function
	
	Initial_Load();             // Load some main images (LOAD-INITIAL.CPP)
	
	Load_Tiles();               // Load room tiles (LOAD-TILES.CPP)
	
	Load_Items();               // Load item images (LOAD-TILES.CPP)
	
	Load_Clips();               // Load clipping images (LOAD-CLIPS.CPP)
    
    WinInit();                  // Initialize window GUI system (WINDOW.CPP)

    Initialize_Menus();         // Initialize menu systems (INIT-MENUS.CPP)
    
    Initialize_Windows();       // Initialize program windows (INIT-WINDOWS.CPP)
	
    int arg;
    bool bgshow = false;
    bool showfps = false;
    bool pressfps = false;
    bool bgstretch = false;
    BITMAP *background = NULL;
    
    for (arg = 1; arg < argc; arg++) {
        /*----- Debug Shit -----*/
        if(stricmp(argv[arg], "-debug") == 0) {
            debug = true;
            init_logging();
            
            logputs("Debug Mode Engaged\n\n");
        }
        /*----- Working Background -----*/
        else if(stricmp(argv[arg], "-bg") == 0) {
            if(argv[arg + 1] != NULL) {
                background = load_bitmap(argv[arg + 1], NULL);
                if(background != NULL) {
                    bgshow = true;
                }
            }
        }
        /*----- Working Background Stretch -----*/
        else if(stricmp(argv[arg], "-bgstretch") == 0) {
            bgstretch = true;
        }
        else if(argv[arg][strlen(argv[arg])] - 4 == '.'
             && argv[arg][strlen(argv[arg])] - 3 == 'l'
             && argv[arg][strlen(argv[arg])] - 2 == 'e'
             && argv[arg][strlen(argv[arg])] - 1 == 'v' )
        {
            dialogmode = true;
            Import_Level(argv[arg], true);
        }
        else if(argv[arg][strlen(argv[arg])] - 4 == '.'
             && argv[arg][strlen(argv[arg])] - 3 == 's'
             && argv[arg][strlen(argv[arg])] - 2 == 'm'
             && argv[arg][strlen(argv[arg])] - 1 == 'a' )
        {
            dialogmode = true;
            Load_Area(argv[arg]);
        }
    }
    
    if(debug) logputs("\nInitialization Complete, program running...\n");

    while(!quit) {                               //Control Loop
        
        while(speed_counter > 0) {
            if(key[KEY_ESC]) quit = true;
            if(key[KEY_TILDE] && debug) {
                ListWindows();
            }
            if(key[KEY_TILDE]) {
                if(!pressfps) {
                    showfps = (showfps == true ? false : true);
                    pressfps = true;
                }
            } else {
                pressfps = false;
            }
            
            if(!dialogmode){
                if(!grab) {
                    if(!(MainMenu->Check())) {
                        PollKeyBuffer();
                        ProcessWindows();
                    }
                } else {
                    ProcessWindows();
                }
            } else {
                PollKeyBuffer();
                ProcessWindows();
            }
            if(pasteit && mouse_b & 1)
            {
                pasteit = false;
            }
            speed_counter --;
        }    
        clear_to_color(buffer, BLACK);
    
        if(bgshow) {
            if(bgstretch) {
                stretch_blit(background, buffer, 0, 0, background->w, background->h, 0, 0, main_width, main_height);
            } else {
                blit(background, buffer, 
                ((main_width - background->w) / 2 < 0 ? abs(main_width - background->w) / 2 : 0), 
                ((main_height - background->h) / 2 < 0 ? abs(main_height - background->h) / 2 : 0),
                ((main_width - background->w) / 2 < 0 ? 0 : (main_width - background->w) / 2),
                ((main_height - background->h) / 2 < 0 ? 0 : (main_height - background->h) / 2),
                main_width, main_height);
            }
        }
        if(!dialogmode){
            DrawWindows(buffer);
            MainMenu->Draw(buffer);
        } else {
            if(frozenbuf == NULL) {
                MainMenu->Draw(buffer);
                DrawWindows(buffer);
                frozenbuf = create_bitmap(main_width, main_height);
                blit(buffer, frozenbuf, 0, 0, 0, 0, main_width, main_height);
            }        
            blit(frozenbuf, buffer, 0, 0, 0, 0, main_width, main_height);
            DrawWindows(buffer);
        }
        
        if(key[KEY_RCONTROL] || key[KEY_LCONTROL])
        {
            draw_sprite(buffer, mouse_grb, mouse_x, mouse_y);
        }
        else
        {
            draw_sprite(buffer, mouse_spr, mouse_x, mouse_y);
        }
        textprintf(buffer, TinyFont, mouse_x + 13, mouse_y + 13, BLACK, "(%3i:%3i)", mouse_x, mouse_y);
        textprintf(buffer, TinyFont, mouse_x + 12, mouse_y + 12, WHITE, "(%3i:%3i)", mouse_x, mouse_y);
            
        if(showfps) {
            textprintf(buffer, font, main_width - 56, 3, BLACK, "FPS:%3i", fps);
            textprintf(buffer, font, main_width - 57, 2, makecol(224, 224, 0), "FPS:%3i", fps);
        }
        
        acquire_screen();
        
        blit(buffer, screen, 0, 0, 0, 0, main_width, main_height);
        
        release_screen();
        
        fps_counter++;
    }

    if(background != NULL) destroy_bitmap(background);
    
    free_datafile_bmps();
    
    destroy_bitmap(buffer);
    delete(MainMenu);
    delete(Windows);
    free(WindowStack);
    
    allegro_exit();
    
    return(0);
}
END_OF_MAIN();
