#include "commonheaders.h"
#include "cls-menu.h"
#include "initialization.h"
#include "editor.h"

int Load_Tiles(void) {
	if(TileImages != NULL) {
		free(TileImages);
		TileImages = NULL;
	}
	
    // Load the datafile containing the tile images

    char tile_string[265];
    strcpy( tile_string, install_path );
    strcat( tile_string, "\\Tiles.dat" );
    
    TileFile = load_datafile( tile_string );
    abort_NULL(TileFile, "DTFL&TL&0");
    
    if(debug) logputs("\t\"Tiles.dat\" opened, loading images...");
    
    //Create an empty black tile
    BlackTile = create_bitmap(16, 16);
    abort_NULL(BlackTile, "TLEBK");
    clear_to_color(BlackTile, 0);

    short i = 0;
    tilerow = 1;
    tileamount = 0;
    selectedtile = 1;
    
    //Read tile images until at the end of the file
    while(TileFile[i + 1].type != DAT_END)
    {
        //Allocate and load the tile
        TileImages = (BITMAP **)qualloc(TileImages, sizeof(BITMAP *) * (i + 1));
        abort_NULL(TileImages, "TLEALLOCI&0");
        
        TileImages[i] = (BITMAP *)TileFile[i].dat;//get_datafile_bmp(TileFile[i].dat);//
        abort_NULL(TileImages[i], "TLELD&i");
        
        // Replace white tiles with black tiles
        short y = 0;
        short x = 0;
        while(y < 15 && _getpixel16(TileImages[i], x, y) == 65535) {
            x = 0;
            while(x < 15 && _getpixel16(TileImages[i], x, y) == 65535) {
                x++;
            }
            y++;
        }
        if(y == 15 && x == 15) {
            //destroy_bitmap(TileImages[i]);
            TileImages[i] = BlackTile;
        }
        
        i ++;
        tileamount ++;
    }
	//unload_datafile(TileFile);
    if(debug) logputs("Complete.\n");
    for(short j = 0; j < i; j ++)
    if(TileImages[j])
    draw_sprite(screen, TileImages[j], 0, 0);
    //readkey();
    
    return(0);
}
int Load_Items(void) {
	if(ItemImages != NULL) {
		free(ItemImages);
		ItemImages = NULL;
	}
	
    // Load the datafile containing the item images

    char item_string[265];
    strcpy( item_string, install_path );
    strcat( item_string, "\\Items.dat" );
    
    ItemFile = load_datafile( item_string );
    abort_NULL(ItemFile, "DTFL&IT&0");
    
    if(debug) logputs("\t\"Items.dat\" opened, loading images...");
    
    short i = 0;
    
    //Read item images until at the end of the file
    while(ItemFile[i + 1].type != DAT_END)
    {
        //Allocate and load the items
        ItemImages = (BITMAP **)qualloc(ItemImages, sizeof(BITMAP *) * (i + 1));
        abort_NULL(ItemImages, "ITMALLOCI&0");
    
        ItemImages[i] = get_datafile_bmp(ItemFile[i].dat);
        abort_NULL(ItemImages[i], "ITMLD&i");
        
        i ++;
    }
    
	//unload_datafile(ItemFile);
    if(debug) logputs("Complete.\n");
    
    return(0);
}
