#include "commonheaders.h"
#include "cls-menu.h"
#include "cls-window.h"
#include "initialization.h"
#include "winfunctions.h"
#include "window.h"

// A list of preset music files for the game
char TuneNames[22][30] = {
	"NO MUSIC", 
    "Boss Battle 1",
    "Boss Battle 2",
    "Brinstar Green",
    "Brinstar Red",
    "Expectation",
    "Crateria Raining",
    "Crateria Surface",
    "Crateria Underground",
    "Item Room",
    "Maridia Natural",
    "Maridia Metal",
    "Mini-Boss",
    "Mother Brain Boss",
    "Norfair",
    "Norfair Depths",
    "Self Destruct",
    "Ceres",
    "Statue Room",
    "Tourian Bubbling",
    "Tourian Tension",
    "Wrecked Ship" };

int Import_Doors(char *levelname) 
{
    FILE *level = NULL;
    char *leveldir = NULL;
    char *tempString = NULL;
    short tempX = 0, tempY = 0;
    
    if(debug) logputs("\nChecking Level Doors:\n\n");
    
    // Check if the string ends with the file extension
    if(strlen(levelname) > 4 
    && (levelname[strlen(levelname) - 4] == '.') 
    && (levelname[strlen(levelname) - 3] == 'l') 
    && (levelname[strlen(levelname) - 2] == 'e') 
    && (levelname[strlen(levelname) - 1] == 'v')) 
    {
        if(debug) printf("NoAdd \"%s\"\n", levelname);
        
        // Allocate memory for the level directory string and copy the full path
        leveldir = (char*)qualloc(strlen(levelname) + strlen("Levels\\") + 1);
        memset(leveldir, 0, strlen(levelname) + strlen("Levels\\") + 1);
        strcpy(leveldir, "Levels\\");
        strcat(leveldir, levelname);
    } 
    else 
    {
        if(debug) printf("Add \"%s\" + \".lev\"\n", levelname);
        
        // Allocate memory for the level directory string and copy the full path
        leveldir = (char*)qualloc(strlen(levelname) + strlen("Levels\\.lev") + 1);
        memset(leveldir, 0, strlen(levelname) + strlen("Levels\\") + 1);
        strcpy(leveldir, "Levels\\");
        strcat(leveldir, levelname);
        strcat(leveldir, ".lev");
    }
    
    if(debug) logprintf("Opening: \"%s\"...", leveldir);
    
    // Load the file into memory
    level = fopen(leveldir, "r");
    
    // Check for successful loading
    if(level != NULL) 
    {
        if(debug) logputs("Complete.\n");
        
        // Allocate memory for a multi-use string
        tempString = (char*)qualloc(tempString, sizeof(char) * 20);
        memset(tempString, 0, sizeof(char) * 20);
        
        // Read the level version into memory
        fread(tempString, sizeof(char), 20, level);
        
        if(debug) logprintf("Version: %s\n", tempString);
        
        // Check the version of the level, disregarding case
        if(!strcasecmp(tempString, "SMTCLevEdit v0.8"))
        {
            // Close the level and reopen it in binary mode
            fclose(level);
            level = fopen(leveldir, "rb");
            
            // Seek past the version and music information
            fseek(level, 50, SEEK_SET);
            
            // Read the room X size and Y size into temporary values
            fread(&tempX, sizeof(short), 1, level);
            fread(&tempY, sizeof(short), 1, level);
            
            // Seek past the tile entries
            fseek(level, tempX * tempY * sizeof(struct tile), SEEK_CUR);
            
            // Read the amount of doors in the room
            fread(&exitamount, sizeof(short), 1, level);
                
            // Allocate space for the exit doors and clear the memory
            exitdoors = (struct door*)qualloc(exitdoors, sizeof(struct door) * exitamount);
            memset(exitdoors, 0, sizeof(struct door) * exitamount);
                	
            for(short i = 0; 
                i < exitamount; 
                i ++)
            {
                // Read the door entries into memory
                fread(&exitdoors[i], sizeof(struct door), 1, level);
                
                // Increase the drop location for SMTC compatability
				exitdoors[i].doordrop ++;
				
				// Clear the back end of the levelname in case there is bad information
                for(short j = strlen(exitdoors[i].levelname); 
                    j < 30; 
                    j++)
                {
					exitdoors[i].levelname[j] = '\0';
				}
            }
            
            // Close the level file
            fclose(level);
            
		    // Deallocate string memory
    		free(leveldir);
            
            if(debug) logprintf("Doors Loaded Successfully, Exit Amount: %i\n", exitamount);
		}
    
		// Deallocate string memory
        free(tempString);
        return(0);
    }
    return(1);
}
int Import_Level(char *levelname, bool exitDialog) 
{
    // Initially Check for rooms with duplicate names
    if(!Windows[RWin("Map Editor")]->ListBoxes[0]->CheckItem(levelname))
    {
        FILE *level;
        FILE *logfile = NULL;
        char *leveldir = NULL;
        char *tempString = NULL;
        
        printf("\n Importing %s...", levelname);
        
        // Check if the string ends with the file extension
    	if(strlen(levelname) > 4 
        && (levelname[strlen(levelname) - 4] == '.')) 
    	{        	
        	// Allocate memory for the level directory string and copy the full path
        	leveldir = (char*)qualloc(sizeof(char) * strlen(levelname) + strlen("Levels\\"));
            memset(leveldir, 0, strlen(levelname) + strlen("Levels\\") + 1);
        	strcpy(leveldir, "Levels\\");
        	strcat(leveldir, levelname);
    	} 
    	else 
    	{        	
        	// Allocate memory for the level directory string and copy the full path
        	leveldir = (char*)qualloc(strlen(levelname) + strlen("Levels\\.lev") + 1);
            memset(leveldir, 0, strlen(levelname) + strlen("Levels\\") + 1);
        	strcpy(leveldir, "Levels\\");
        	strcat(leveldir, levelname);
            strcat(leveldir, ".lev");
    	}
    	
    	// Load the file into memory
        level = fopen(leveldir, "r+");
        puts(leveldir);
        
        // Check for successful loading
        if(level != NULL) 
        {
            // Increase the room amount and quallocate memory
            roomamount ++;
        	roomTiles = (ROOM *)qualloc(roomTiles, sizeof(ROOM) * roomamount);
        	printf("Load to Room #%i\n", roomamount - 1);
        	
        	// Check for a memory allocation error
        	if(roomTiles == NULL) {
    			allegro_message("Memory Error:\n    Memory for the room could not be allocated\n\nAborting Program");
    			exit(1);
    		}
        	
            // Check if the string ends with the file extension
        	if((levelname[strlen(levelname) - 4] == '.')) 
            {
                // Truncate the level name
                levelname[strlen(levelname) - 4] = '\0';
                
                // Add the level name to the room lists
                Init_String(roomTiles[roomamount - 1].name, levelname, 30);
        	    Windows[RWin("Map Editor")]->ListBoxes[0]->AddItem(levelname);
                Windows[RWin("Room Editor")]->ScrollBoxes[0]->AddItem(levelname);
                
                // Restore the level name
                levelname[strlen(levelname) - 4] = '.';
            }
            else 
            {
                // Add the level name to the room lists
                Init_String(roomTiles[roomamount - 1].name, levelname, 30);
                Windows[RWin("Map Editor")]->ListBoxes[0]->AddItem(levelname);
                Windows[RWin("Room Editor")]->ScrollBoxes[0]->AddItem(levelname);
            }
            
    		// Set the values of the new room to defaults
        	roomTiles[roomamount - 1].xSize = 0;
        	roomTiles[roomamount - 1].ySize = 0;
        	roomTiles[roomamount - 1].itemamount = 0;
        	roomTiles[roomamount - 1].dooramount = 0;
        	roomTiles[roomamount - 1].breakamount = 0;
        	roomTiles[roomamount - 1].water_type = 0;
        	roomTiles[roomamount - 1].water_high = 0;
        	roomTiles[roomamount - 1].water_low = 0;
        	roomTiles[roomamount - 1].tunenum = 0;
        	roomTiles[roomamount - 1].tune_in = 0;
        	roomTiles[roomamount - 1].tune_out = 0;
            Init_String(roomTiles[roomamount - 1].tune, "", 30);
        	
            // Allocate memory for a multi-use string
        	tempString = (char*)malloc(sizeof(char) * 30);
            memset(tempString, 0, sizeof(char) * 30);
        	
            // Read the level version into memory
            fread(tempString, sizeof(char), 20, level);
            
            printf("\tVersion: %s\n", tempString);
            
            // Check the version of the level, disregarding case
            if(strcasecmp(tempString, "SMTCLevEdit v0.8") == 0)
            {
                // Close the level and reopen it in binary mode
                fclose(level);
                level = fopen(leveldir, "rb+");
                
                // Seek past the version information
                fseek(level, 20, SEEK_SET);
                
                // Read the music information into cleared memory
                memset(tempString, 0, sizeof(char) * 30);
                fread(tempString, sizeof(char), 30, level);
                
                // Check if the level has a valid music name
                for(short i = 0; 
                    i < 21; 
                    i ++)
                {
                    if(!strcasecmp(tempString, TuneNames[i]))
                        roomTiles[roomamount - 1].tunenum = i;
                }
                
                if(debug) fputs("\tReading Room Size Information...", logfile);
                
                // Read the room X size and Y size into the room information
                fread(&roomTiles[roomamount - 1].xSize, sizeof(short), 1, level);
                fread(&roomTiles[roomamount - 1].ySize, sizeof(short), 1, level);
                
                int tempySize = (roomTiles[roomamount - 1].ySize % 16 > 0 ? 16 - roomTiles[roomamount - 1].ySize % 16 : 0);
                roomTiles[roomamount - 1].ySize += tempySize;
                
                if(debug) fputs("Completed.\n", logfile);
                
                if(debug) fprintf(logfile, "\tDimensions: %ix%i\n", roomTiles[roomamount - 1].xSize, roomTiles[roomamount - 1].ySize);
                
                if(debug) fputs("\tAllocating Memory for the Tiles...", logfile);
                
                // Allocate memory for the rows of tiles in the room    
                roomTiles[roomamount - 1].tiles = NULL;
                roomTiles[roomamount - 1].tiles = (struct tile **)qualloc(roomTiles[roomamount - 1].tiles, sizeof(struct tile *) * roomTiles[roomamount - 1].ySize);
                // Check for allocation errors and clear the data
                
    			if(debug) fputs("Allocated\n", logfile);
    				
                if(roomTiles[roomamount - 1].tiles == NULL) {
    				if(debug) fputs("Memory Error", logfile);
    				exit(1);
    			}
    			
    			if(debug) fputs("\tCleared\n", logfile);
                
                if(debug) fputs("\tReading Tile Information...", logfile);
                
                // Read each tile from the level into memory
                roomTiles[roomamount - 1].ySize -= tempySize;
                for( short yloop = 0; yloop < roomTiles[roomamount - 1].ySize; yloop++ )
                {
                    roomTiles[roomamount - 1].tiles[yloop] = NULL;
                    roomTiles[roomamount - 1].tiles[yloop] = (struct tile *)qualloc(roomTiles[roomamount - 1].tiles[yloop], sizeof(struct tile) * roomTiles[roomamount - 1].xSize);
                    memset(roomTiles[roomamount - 1].tiles[yloop], 0, sizeof(struct tile) * roomTiles[roomamount - 1].xSize);
                    for( short xloop = 0; xloop < roomTiles[roomamount - 1].xSize; xloop++ )
                    {
                        fread(&roomTiles[roomamount - 1].tiles[yloop][xloop], sizeof(struct tile), 1, level);
                    }
                }
                for( short yloop = roomTiles[roomamount - 1].ySize; yloop < roomTiles[roomamount - 1].ySize + tempySize; yloop++ )
                {
                    roomTiles[roomamount - 1].tiles[yloop] = NULL;
                    roomTiles[roomamount - 1].tiles[yloop] = (struct tile *)qualloc(roomTiles[roomamount - 1].tiles[yloop], sizeof(struct tile) * roomTiles[roomamount - 1].xSize);
                    memset(roomTiles[roomamount - 1].tiles[yloop], 0, sizeof(struct tile) * roomTiles[roomamount - 1].xSize);
                }
                roomTiles[roomamount - 1].ySize += tempySize;
                
                if(debug) fputs("Completed.\n", logfile);
            
                // Read the amount of doors in the room
                fread(&roomTiles[roomamount - 1].dooramount, sizeof(short), 1, level);
                
                if(debug) fputs("\tAllocating Memory for the Doors...", logfile);
                
                // Allocate space for the doors and clear the memory
                roomTiles[roomamount - 1].doors = NULL;
                roomTiles[roomamount - 1].doors = (struct door*)qualloc(roomTiles[roomamount - 1].doors, sizeof(struct door) * (roomTiles[roomamount - 1].dooramount + 1));
                if(debug) fputs("Clearing...", logfile);
                memset(roomTiles[roomamount - 1].doors, 0, sizeof(struct door) * (roomTiles[roomamount - 1].dooramount + 1));
                
                if(debug) fprintf(logfile, "Successfully allocated %i bytes.\n", sizeof(struct door) * (roomTiles[roomamount - 1].dooramount + 1));
            
                if(debug) fputs("\tReading Door Information...", logfile);
                
                for(short i = 0; 
                    i < roomTiles[roomamount - 1].dooramount; 
                    i ++)
                {
                    // Read the door entries into memory
                    fread(&roomTiles[roomamount - 1].doors[i], sizeof(struct door), 1, level);
                    
                    // Increase the drop location for SMTC compatability
					roomTiles[selectedroom].doors[i].doordrop ++;
					
				    // Clear the back end of the levelname in case there is bad information
                    for(short j = strlen(roomTiles[roomamount - 1].doors[i].levelname); 
                        j < 30; 
                        j++)
                    {
						roomTiles[roomamount - 1].doors[i].levelname[j] = '\0';
					}
                }
                
                if(debug) fputs("Complete.\n", logfile);
                
                // Read the amount of breakables in the room
                fread(&roomTiles[roomamount - 1].breakamount, sizeof(short), 1, level);
                
                if(debug) fputs("\tAllocating Memory for the Breakables...", logfile);
                
                // Allocate space for the breakables and clear the memory
                roomTiles[roomamount - 1].breaks = NULL;
                roomTiles[roomamount - 1].breaks = (struct breakable*)qualloc(roomTiles[roomamount - 1].breaks, sizeof(struct breakable) * roomTiles[roomamount - 1].breakamount);
                if(debug) fputs("Clearing...", logfile);
                memset(roomTiles[roomamount - 1].breaks, 0, sizeof(struct breakable) * roomTiles[roomamount - 1].breakamount);
                
                if(debug) fprintf(logfile, "Successfully allocated %i bytes.\n", sizeof(struct breakable) * roomTiles[roomamount - 1].breakamount);
                
                if(debug) fputs("\tReading Breakable Information...", logfile);
                
                for(short i = 0; i < roomTiles[roomamount - 1].breakamount; i ++)
                {
                    // Read the breakable entries into memory
                    fread(&roomTiles[roomamount - 1].breaks[i], sizeof(struct breakable), 1, level);
                    if( roomTiles[roomamount - 1].breaks[i].type > 512 )
                        roomTiles[roomamount - 1].breaks[i].type = 0;
                }
                
                if(debug) fputs("Complete.\n", logfile);
                
                // Read the amount of items in the room
                fread(&roomTiles[roomamount - 1].itemamount, sizeof(short), 1, level);
                
                if(debug) fputs("\tAllocating Memory for the Items...", logfile);
                
                // Allocate space for the items and clear the memory
                roomTiles[roomamount - 1].items = NULL;
                roomTiles[roomamount - 1].items = (struct item*)qualloc(roomTiles[roomamount - 1].items, sizeof(struct item) * roomTiles[roomamount - 1].itemamount);
                if(debug) fputs("Clearing...", logfile);
                memset(roomTiles[roomamount - 1].items, 0, sizeof(struct item) * roomTiles[roomamount - 1].itemamount);
                
                if(debug) fprintf(logfile, "Successfully allocated %i bytes.\n", sizeof(struct item) * roomTiles[roomamount - 1].itemamount);
                
                if(debug) fputs("\tReading Item Information...", logfile);
                
                for(short i = 0; i < roomTiles[roomamount - 1].itemamount; i ++)
                {
                    // Read the item entries into memory
                    fread(&roomTiles[roomamount - 1].items[i], sizeof(struct item), 1, level);
                }
                if(debug) fputs("Complete.\n", logfile);
                
                if(debug) fprintf(logfile, "\n%s Loaded Successfully\n\n", leveldir);
                if(debug) logprintf("\n%s Loaded Successfully\n\n", leveldir);
                
                // Switch the dialog window to the import window
                if(exitDialog)
                {
                    CloseWindow(dialogwindow);
                    dialogwindow = RWin("Place Imported Room");
                }
                
                // Close the level file
                fclose(level);
                
		        // Deallocate string memory
        		free(leveldir);
        		free(tempString);
        		
                return(0);
            }
            if(strcasecmp(tempString, "SMTCLevEdit v0.75a") == 0)
            {
                fclose(level);
                level = fopen(leveldir, "rb+");
                
                int tempInt = 0;
                int tempxSize = 0;
                int tempySize = 0;
        	    tempString = (char*)qualloc(sizeof(char) * 50);
                fread(tempString, sizeof(char), 50, level);
                
                fread(&tempInt, sizeof(int), 1, level);
                roomTiles[roomamount - 1].xSize = (short)tempInt;
                tempxSize = (roomTiles[roomamount - 1].xSize % 16 > 0 ? 16 - roomTiles[roomamount - 1].xSize % 16 : 0);
                roomTiles[roomamount - 1].xSize += tempxSize;
                fread(&tempInt, sizeof(int), 1, level);
                roomTiles[roomamount - 1].ySize = (short)tempInt;
                tempySize = (roomTiles[roomamount - 1].ySize % 16 > 0 ? 16 - roomTiles[roomamount - 1].ySize % 16 : 0);
                roomTiles[roomamount - 1].ySize += tempySize;
    	        if(debug) printf("\nDimensions: %ix%i %i\n", roomTiles[roomamount - 1].xSize, roomTiles[roomamount - 1].ySize, roomTiles[roomamount -1].tiles);
                
                roomTiles[roomamount - 1].tiles = (struct tile **)qualloc(roomTiles[roomamount - 1].tiles, sizeof(struct tile *) * roomTiles[roomamount - 1].ySize);
    			if(roomTiles[roomamount - 1].tiles == NULL) {
    				logputs("Memory Error");
    				readkey();
    				exit(1);
    			}
                memset(roomTiles[roomamount - 1].tiles, 0, sizeof(unsigned short *) * roomTiles[roomamount - 1].ySize);
                for(short i = 0; i < roomTiles[roomamount - 1].ySize; i ++)
                {
                    roomTiles[roomamount - 1].tiles[i] = (struct tile *)qualloc(roomTiles[roomamount - 1].tiles[i], sizeof(struct tile) * roomTiles[roomamount - 1].xSize);
                    memset(roomTiles[roomamount - 1].tiles[i], 0, sizeof(struct tile *) * roomTiles[roomamount - 1].xSize);
                }
                fread(tempString, sizeof(char), 1 + sizeof(int) * 2, level);
                
                roomTiles[roomamount - 1].xSize -= tempxSize;
                roomTiles[roomamount - 1].ySize -= tempySize;
                for(short yloop = 0; yloop < roomTiles[roomamount - 1].ySize; yloop++)
                {
                    for(short xloop = 0; xloop < roomTiles[roomamount - 1].xSize; xloop++)
                    {
    					tempInt = 0;
                        fread(&tempInt, sizeof(int), 1, level);
                        if(tempInt > 130000)
                        {
                            tempInt -= 130000;
                            if(tempInt > 40) 
                            {
                                roomTiles[roomamount - 1].tiles[yloop][xloop].fade = 1;
                                tempInt -= 40;
                            }
                            roomTiles[roomamount - 1].tiles[yloop][xloop].rotation = (short)(tempInt / 10);
                            roomTiles[roomamount - 1].tiles[yloop][xloop].flip = (short)(tempInt % 10);
                            fread(&tempInt, sizeof(int), 1, level);
                        }
                        roomTiles[roomamount - 1].tiles[yloop][xloop].tileval = tempInt;
    					tempInt = 0;
                        fread(&tempInt, sizeof(short), 1, level);
                        roomTiles[roomamount - 1].tiles[yloop][xloop].clip = tempInt;
                	}
                }
                roomTiles[roomamount - 1].xSize += tempxSize;
                roomTiles[roomamount - 1].ySize += tempySize;
                for(short i = 0; i < 10; i++)
                {
                    fread(&tempInt, sizeof(int), 1, level);
                    if(tempInt == 1) {
                        roomTiles[roomamount - 1].dooramount = i + 1;
                        roomTiles[roomamount - 1].doors = (struct door*)qualloc(roomTiles[roomamount - 1].doors, sizeof(struct door) * (roomTiles[roomamount - 1].dooramount + 1));
                        roomTiles[roomamount - 1].doors[i].xPos = 0;
                        roomTiles[roomamount - 1].doors[i].yPos = 0;
                        roomTiles[roomamount - 1].doors[i].type = 0;
                        roomTiles[roomamount - 1].doors[i].direction = 0;
                        roomTiles[roomamount - 1].doors[i].doordrop = 0;
                        fread(&tempInt, sizeof(int), 1, level);
                        roomTiles[roomamount - 1].doors[i].xPos = (short)(tempInt / 16);
                        fread(&tempInt, sizeof(int), 1, level);
                        roomTiles[roomamount - 1].doors[i].yPos = (short)(tempInt / 16);
                        fread(&tempInt, sizeof(int), 1, level);
                        roomTiles[roomamount - 1].doors[i].direction = (short)(tempInt > 2 ? tempInt : (tempInt == 1 ? 0 : 1));
                        fread(&tempInt, sizeof(int), 1, level);
                        char area_filenames[7][5] = {
                                {"crat"},
                                {"brin"},
                                {"norf"},
                                {"ship"},
                                {"mard"},
                                {"tour"},
                                {"cere"}};
                        Init_String(roomTiles[roomamount - 1].doors[i].levelname, area_filenames[tempInt], 30);
                        printf("DOOR BF: %s", roomTiles[roomamount - 1].doors[i].levelname);
                        fread(&tempInt, sizeof(int), 1, level);
                        Init_String(tempString, "", 30);
                        itoa(tempInt, tempString, 10);
                        printf("%s\n", tempString);
                        strcat(roomTiles[roomamount - 1].doors[i].levelname, tempString);
                        printf("DOOR AR: %s\n", roomTiles[roomamount - 1].doors[i].levelname);
                        fread(&tempInt, sizeof(int), 1, level);
                        roomTiles[roomamount - 1].doors[i].doordrop = (short)(tempInt) + 1;
                    } else {
                        fread(&tempInt, sizeof(int), 1, level);
                        fread(&tempInt, sizeof(int), 1, level);
                        fread(&tempInt, sizeof(int), 1, level);
                        fread(&tempInt, sizeof(int), 1, level);
                        fread(&tempInt, sizeof(int), 1, level);
                        fread(&tempInt, sizeof(int), 1, level);
                    }
                }
                
                for(short i = 0; i < 5; i++)
                {
                    //roomTiles[roomamount - 1].itemamount ++;
                    //roomTiles[roomamount - 1].items = (struct item*)qualloc(roomTiles[roomamount - 1].items, sizeof(struct item) * roomTiles[roomamount - 1].itemamount);
                    fread(&tempInt, sizeof(int), 1, level);
                    //roomTiles[roomamount - 1].items[roomTiles[roomamount - 1].itemamount].type = (short)tempInt;
                    fread(&tempInt, sizeof(int), 1, level);
                    //roomTiles[roomamount - 1].items[roomTiles[roomamount - 1].itemamount].xPos = (short)tempInt;
                    fread(&tempInt, sizeof(int), 1, level);
                    //roomTiles[roomamount - 1].items[roomTiles[roomamount - 1].itemamount].yPos = (short)tempInt;
                }
                for(short i = 0; i < 128; i++)
                {
                    fread(&tempInt, sizeof(int), 1, level);
                    if(tempInt != 0 && tempInt < 16)
                    {
                        roomTiles[roomamount - 1].breakamount ++;
                        roomTiles[roomamount - 1].breaks = (struct breakable*)qualloc(roomTiles[roomamount - 1].breaks, sizeof(struct breakable) * roomTiles[roomamount - 1].breakamount);
                        printf("BT %i->", tempInt);
                        if(tempInt == 11) tempInt = 4;
                        if(tempInt == 12) tempInt = 8;
                        if(tempInt == 13) tempInt = 1;
                        if(tempInt == 14) tempInt = 3;
                        if(tempInt == 15) tempInt = 7;
                        printf("BT %i\n", tempInt);
                        roomTiles[roomamount - 1].breaks[roomTiles[roomamount - 1].breakamount - 1].type = 1 << (tempInt - 1);
                        printf("BT %i-%i\n", roomTiles[roomamount - 1].breaks[roomTiles[roomamount - 1].breakamount - 1].type, 
                        (int)log2(roomTiles[roomamount - 1].breaks[roomTiles[roomamount - 1].breakamount - 1].type));
                        fread(&tempInt, sizeof(int), 1, level);
                        roomTiles[roomamount - 1].breaks[roomTiles[roomamount - 1].breakamount - 1].x = (short)(tempInt);
                        fread(&tempInt, sizeof(int), 1, level);
                        roomTiles[roomamount - 1].breaks[roomTiles[roomamount - 1].breakamount - 1].y = (short)(tempInt);
                        fread(&tempInt, sizeof(int), 1, level);
    		            roomTiles[roomamount - 1].breaks[roomTiles[roomamount - 1].breakamount - 1].timer = 120;
                        roomTiles[roomamount - 1].breaks[roomTiles[roomamount - 1].breakamount - 1].tileinfo.flip = 0;
                        roomTiles[roomamount - 1].breaks[roomTiles[roomamount - 1].breakamount - 1].tileinfo.rotation = 0;
                        roomTiles[roomamount - 1].breaks[roomTiles[roomamount - 1].breakamount - 1].tileinfo.tileval = (short)(tempInt);
                        roomTiles[roomamount - 1].breaks[roomTiles[roomamount - 1].breakamount - 1].tileinfo.clip = 1;
    		            roomTiles[roomamount - 1].breaks[roomTiles[roomamount - 1].breakamount - 1].tileinfo.foreground = false;
    		            roomTiles[roomamount - 1].breaks[roomTiles[roomamount - 1].breakamount - 1].tileinfo.fade = false;
    		            roomTiles[roomamount - 1].breaks[roomTiles[roomamount - 1].breakamount - 1].dir = 0;
                    }
                    else
                    {
                        fread(&tempInt, sizeof(int), 1, level);
                        fread(&tempInt, sizeof(int), 1, level);
                        fread(&tempInt, sizeof(int), 1, level);
                    }
                }
                printf("\nLoaded: Dimensions: %ix%i\n", roomTiles[roomamount - 1].xSize, roomTiles[roomamount - 1].ySize);
                //readkey();
                if(exitDialog)
                {
				    CloseWindow(dialogwindow);
                    dialogwindow = RWin("Place Imported Room");
                }
                fclose(level);
        		free(leveldir);
        		free(tempString);
                
                return(0);
            }
            else 
            {
                fclose(level);
                
                if(debug) logputs("Invalid Version\n");
                roomamount --;
        	    roomTiles = (ROOM *)qualloc(roomTiles, sizeof(ROOM) * roomamount);
                Windows[RWin("Map Editor")]->ListBoxes[0]->EraseItem(roomamount);
                Windows[RWin("Room Editor")]->ScrollBoxes[0]->EraseItem(roomamount);
                if(exitDialog)
                {
                    CloseWindow(dialogwindow);
                    Windows[RWin("Invalid Level")]->Set_Pos(main_width / 2 - 152, main_height / 2 - 36);
                    dialogwindow = RWin("Invalid Level");
                }
        		free(tempString);
            }
        } 
        else 
        {
            if(exitDialog)
            {
                CloseWindow(dialogwindow);
                Windows[RWin("Import Error")]->Set_Pos(main_width / 2 - 152, main_height / 2 - 32);
                dialogwindow = RWin("Import Error");
            }
            if(debug) logputs("\nUnable to open level.\n");
        }
    } 
    else 
    {
        
        if(exitDialog)
        {
            CloseWindow(dialogwindow);
            Windows[RWin("Cannot Import")]->Set_Pos(main_width / 2 - 152, main_height / 2 - 32);
            dialogwindow = RWin("Cannot Import");
        }
        if(debug) logputs("\nRoom already exists.\n");
    }
    return(1);
}
int Load_Area ( char *areaname )
{
    FILE *level;
    char *leveldir = NULL;
    char *tempString = NULL;
    
    if ( strlen(areaname) > 4 &&
	    (areaname[strlen(areaname) - 4] == '.') &&
        (areaname[strlen(areaname) - 3] == 's') &&
        (areaname[strlen(areaname) - 2] == 'm') &&
        (areaname[strlen(areaname) - 1] == 'q') ) 
    {
        if(debug) logprintf("NoAdd \"%s\"\n", areaname);
        leveldir = (char*)qualloc(strlen(areaname) + strlen("Levels\\") + 1);
        strcpy(leveldir, "Levels\\");
        strcat(leveldir, areaname);
    } 
    else 
    {
        if(debug) logprintf("Add \"%s\" + \".sma\"\n", areaname);
        leveldir = (char*)qualloc(strlen(areaname) + strlen("Levels\\.sma") + 1);
        strcpy(leveldir, "Levels\\");
        strcat(leveldir, areaname);
        strcat(leveldir, ".sma");
    }
    
    if(debug) logprintf("Opening: \"%s\"...", leveldir);
    level = fopen(leveldir, "rb+");
    
    if ( level != NULL ) 
    {
        if(debug) logprintf("Level Opened.\n");
        
    	tempString = (char*)qualloc ( sizeof(char) * 30 );
        fread ( tempString, sizeof(char), 20, level );
        
        if(debug) logprintf("Version: %s\n", tempString);
        
        Clear_Area();
        
        short temp_room_amount;
        fread ( &temp_room_amount, sizeof(short), 1, level );
        
        for ( short i = 0; i < temp_room_amount; i ++ )
        {
            Init_String ( tempString, "", 30 );
            fread ( tempString, sizeof(char), 30, level );
            Import_Level ( tempString, false );
        }
        
        //fread ( &MapXSize, sizeof(short), 1, level );
        //fread ( &MapYSize, sizeof(short), 1, level );
    
        if(debug) logprintf("Dimensions: %ix%i", MapXSize, MapYSize);
        
        //MapGrid = (unsigned short **)qualloc(sizeof(short *) * (MapYSize));
        //MapSpec = (unsigned short **)qualloc(sizeof(short *) * (MapYSize));
        for ( short yloop = 0; yloop < MapYSize; yloop++ )
        {
            //MapGrid[yloop] = (unsigned short *)qualloc(sizeof(short) * (MapXSize));
            //MapSpec[yloop] = (unsigned short *)qualloc(sizeof(short) * (MapXSize));
            for ( short xloop = 0; xloop < MapXSize; xloop++ )
            {
                fread ( &MapGrid[yloop][xloop], sizeof(short), 1, level );
                if(MapGrid[yloop][xloop] > roomamount)
                {
                    MapSpec[yloop][xloop] = MapGrid[yloop][xloop];
                    fread(&MapGrid[yloop][xloop], sizeof(short), 1, level);
                }
            }
        }
        
        fclose(level);
        free(tempString);
        free(leveldir);
        
        if(debug) logprintf("Load Complete.");
    }
    
    ExitDialog();
}
int Save_Area(char *areaname)
{
	if(roomamount > 0) 
    {
        FILE *level;
        char *leveldir = NULL;
        char *tempString = NULL;
        
        if(strlen(areaname) > 4 &&
    	    (areaname[strlen(areaname) - 4] == '.') &&
            (areaname[strlen(areaname) - 3] == 's') &&
            (areaname[strlen(areaname) - 2] == 'm') &&
            (areaname[strlen(areaname) - 1] == 'q')) 
        {
            if(debug) logprintf("NoAdd \"%s\"\n", areaname);
            leveldir = (char*)qualloc(strlen(areaname) + strlen("Levels\\") + 1);
            strcpy(leveldir, "Levels\\");
            strcat(leveldir, areaname);
        } 
        else 
        {
            if(debug) logprintf("Add \"%s\" + \".sma\"\n", areaname);
            leveldir = (char*)qualloc(strlen(areaname) + strlen("Levels\\.sma") + 1);
            strcpy(leveldir, "Levels\\");
            strcat(leveldir, areaname);
            strcat(leveldir, ".sma");
        }
        
        if(debug) logprintf("Opening: \"%s\"...", leveldir);
        level = fopen(leveldir, "wb+");
        
        if(level != NULL) 
        {
            if(debug) logprintf("Level Opened.\n");
            
        	tempString = (char*)qualloc(sizeof(char) * 20);
            Init_String(tempString, "SMTCLevEdit v0.8", 20);
            if(debug) logprintf("Version: %s\n", tempString);
            
            fwrite(tempString, sizeof(char), 20, level);
            
            fwrite(&roomamount, sizeof(short), 1, level);
            for( short i = 0; i < roomamount; i ++)
            {
                fwrite(roomTiles[i].name, sizeof(char), 30, level);
            }
            
            fwrite(&MapXSize, sizeof(short), 1, level);
            fwrite(&MapYSize, sizeof(short), 1, level);
        
            if(debug) logprintf("Dimensions: %ix%i", MapXSize, MapYSize);
            
            for(short yloop = 0; yloop < MapYSize; yloop++)
            {
                for(short xloop = 0; xloop < MapXSize; xloop++)
                {
                    fwrite(&MapGrid[yloop][xloop], sizeof(short), 1, level);
                    if(MapSpec[yloop][xloop] > 0)
                    {
                        MapSpec[yloop][xloop] += roomamount;
                        fwrite(&MapSpec[yloop][xloop], sizeof(short), 1, level);
                        MapSpec[yloop][xloop] -= roomamount;
                    }
                }
            }
            
            fclose(level);
            free(tempString);
            free(leveldir);
            
            short temp_select = selectedroom;
            for( selectedroom = 0; selectedroom < roomamount; selectedroom ++)
            {
                Export_Level(roomTiles[selectedroom].name, false);
            }
            selectedroom = temp_select;
            
            if(debug) logprintf("Save Complete.");
        }
    }
    
    ExitDialog();
}
int Export_Level(char *levelname, bool exitDialog) 
{
	if(roomamount > 0) 
    {
        FILE *level;
        char *leveldir = NULL;
        char *tempString = NULL;
        
        printf("\n Exporting %s...", levelname);
        if(debug) logputs("\nLevel Export:\n\n");
            
        if(strlen(levelname) > 4 &&
    	    (levelname[strlen(levelname) - 4] == '.') &&
            (levelname[strlen(levelname) - 3] == 'l') &&
            (levelname[strlen(levelname) - 2] == 'e') &&
            (levelname[strlen(levelname) - 1] == 'v')) 
        {
            if(debug) logprintf("NoAdd \"%s\"\n", levelname);
            leveldir = (char*)qualloc(strlen(levelname) + strlen("Levels\\") + 1);
            strcpy(leveldir, "Levels\\");
            strcat(leveldir, levelname);
        } 
        else 
        {
            if(debug) logprintf("Add \"%s\" + \".lev\"\n", levelname);
            leveldir = (char*)qualloc(strlen(levelname) + strlen("Levels\\.lev") + 1);
            strcpy(leveldir, "Levels\\");
            strcat(leveldir, levelname);
            strcat(leveldir, ".lev");
        }
        if(debug) logprintf("Opening: \"%s\"...", leveldir);
        level = fopen(leveldir, "wb+");
        if(level != NULL) 
        {
            if(debug) logprintf("Level Opened.\n");
            
        	tempString = (char*)qualloc(sizeof(char) * 50);
        	memset(tempString, 0, sizeof(char) * 50);
            strcpy(tempString, "SMTCLevEdit v0.8");
            if(debug) logprintf("Version: %s\n", tempString);
            
            fwrite(tempString, sizeof(char), 20, level);
            fwrite(TuneNames[roomTiles[selectedroom].tunenum], sizeof(char), 30, level);
            //fwrite(tempString, sizeof(char), 30, level);
                
            fwrite(&roomTiles[selectedroom].xSize, sizeof(short), 1, level);
            fwrite(&roomTiles[selectedroom].ySize, sizeof(short), 1, level);
            
            if(debug) logprintf("Dimensions: %ix%i", roomTiles[selectedroom].xSize, roomTiles[selectedroom].ySize);
                
            int tempInt = 0;
            for(short yloop = 0; yloop < roomTiles[selectedroom].ySize; yloop++)
            {
                for(short xloop = 0; xloop < roomTiles[selectedroom].xSize; xloop++)
                {
                    fwrite(&roomTiles[selectedroom].tiles[yloop][xloop], sizeof(struct tile), 1, level);
                }
            }
            fwrite(&roomTiles[selectedroom].dooramount, sizeof(short), 1, level);
            for(short i = 0; i < roomTiles[selectedroom].dooramount; i ++)
            {
    			roomTiles[selectedroom].doors[i].doordrop --;
                fwrite(&roomTiles[selectedroom].doors[i], sizeof(struct door), 1, level);
                if(debug) logprintf("lvl%s", roomTiles[selectedroom].doors[i].levelname);
    			roomTiles[selectedroom].doors[i].doordrop ++;
            }
            fwrite(&roomTiles[selectedroom].breakamount, sizeof(short), 1, level);
            if(debug) logprintf("BREAK AMOUNT %i", roomTiles[selectedroom].breakamount);
            
            for(short i = 0; i < roomTiles[selectedroom].breakamount; i ++)
            {
                fwrite(&roomTiles[selectedroom].breaks[i], sizeof(struct breakable), 1, level);
            }
            fwrite(&roomTiles[selectedroom].itemamount, sizeof(short), 1, level);
            if(debug) logprintf("ITEM AMOUNT %i", roomTiles[selectedroom].itemamount);
            
            for(short i = 0; i < roomTiles[selectedroom].itemamount; i ++)
            {
                fwrite(&roomTiles[selectedroom].items[i], sizeof(struct item), 1, level);
            }
            
            if(exitDialog)
                ExitDialog();
                
            fclose(level);
            free(leveldir);
        	free(tempString);
            
            return(0);
        }
        else
        {
            if(exitDialog)
            {
                CloseWindow(dialogwindow);
                Windows[RWin("Export Error")]->Set_Pos(main_width / 2 - 152, main_height / 2 - 32);
                dialogwindow = RWin("Export Error");
            }
            if(debug) logprintf("\nUnable to open level.\n");
        }
	}
    return(1);
}
