#include "commonheaders.h"
#include "cls-menu.h"
#include "initialization.h"
#include "olddata.h"

/////////////////////
// CUSTOM CLIPPING //
////////////////////////////////////////////////////////////////////////////////
BITMAP* custom_clip(int customnumber)
{
    FILE *file;
    char pathset[8];
    char fullpath[64];
    char clipval[18];
    char charnum[8];
    
    strclr(fullpath);
    strclr(charnum);
    strcat(fullpath, "Custom\\");
    strcat(fullpath, "clip");
    itoa(customnumber - 11, charnum, 10);
    strcat(fullpath, charnum);
    strcat(fullpath, ".clp");
    
    if(debug)
    {
        logputs("\t\tLoading Clip:");
        logputs(fullpath);
        logputs("...");
    }
    if((file = fopen(fullpath, "r")) == NULL)
    {
	    if(debug) logputs("Invalid Target.\n");
        return NULL;
    }
    else
    {
        BITMAP * temp = create_bitmap(16, 16);
        abort_NULL(temp, "CLPTMP&0");
        
        clear_to_color(temp, makecol(255,0,255));
        for(short yloop = 0; yloop < 16; yloop ++)
        {
            fgets(clipval, sizeof(char) * 18, file);
            for(short xloop = 0; xloop < 16; xloop ++)
            {
                if(clipval[xloop] == 49)
                    _putpixel16(temp, xloop, yloop, makecol(128, 0, 128));
            }
        }
	    fclose(file);
	    if(debug) logputs("Complete.\n");
	    return temp;
    }
}

int Load_Clips(void) {
    if(debug) logputs("\n\tLoading Custom Clipping and Preset Clipping:\n\n");
    
	short i = 14;
	if(ClipImages != NULL) {
		free(ClipImages);
		ClipImages = NULL;
	}
	
	ClipImages = (BITMAP **)qualloc(ClipImages, sizeof(BITMAP *) * (i+1));
    abort_NULL(ClipImages, "CLPALLOCI&0");

    OldData = load_datafile("OldData.dat");  //Load the Editor Datafile
    abort_NULL(OldData, "DTFL&OD&0");

    ClipImages[0] = create_bitmap(16, 16);
    abort_NULL(ClipImages[0], "CLPLD&0");
    clear_to_color(ClipImages[0], makecol(255, 0, 255));
    
    ClipImages[1] = create_bitmap(16, 16);
    abort_NULL(ClipImages[1], "CLPLD&1");
    
    clear_to_color(ClipImages[1], makecol(128, 0, 128));
    ClipImages[2]  = get_datafile_bmp(OldData[ClipSlpelr].dat);
    abort_NULL(ClipImages[2], "CLPLD&2");
    
	ClipImages[3]  = get_datafile_bmp(OldData[ClipSlpell].dat);
    abort_NULL(ClipImages[3], "CLPLD&3");
    
	ClipImages[4]  = get_datafile_bmp(OldData[ClipSlpetr].dat);
    abort_NULL(ClipImages[4], "CLPLD&4");
    
	ClipImages[5]  = get_datafile_bmp(OldData[ClipSlpetl].dat);
    abort_NULL(ClipImages[5], "CLPLD&5");
    
	ClipImages[6]  = get_datafile_bmp(OldData[ClipHalft].dat);
    abort_NULL(ClipImages[6], "CLPLD&6");
    
	ClipImages[7]  = get_datafile_bmp(OldData[ClipHalfb].dat);
    abort_NULL(ClipImages[7], "CLPLD&7");
    
	ClipImages[8]  = get_datafile_bmp(OldData[ClipHalfr].dat);
    abort_NULL(ClipImages[8], "CLPLD&8");
    
	ClipImages[9]  = get_datafile_bmp(OldData[ClipHalfl].dat);
    abort_NULL(ClipImages[9], "CLPLD&9");
    
	ClipImages[10] = get_datafile_bmp(OldData[ClipQuartl].dat);
    abort_NULL(ClipImages[10], "CLPLD10");
    
	ClipImages[11] = get_datafile_bmp(OldData[ClipQuarll].dat);
    abort_NULL(ClipImages[11], "CLPLD11");
    
	ClipImages[12] = get_datafile_bmp(OldData[ClipQuartr].dat);
    abort_NULL(ClipImages[12], "CLPLD12");
    
	ClipImages[13] = get_datafile_bmp(OldData[ClipQuarlr].dat);
    abort_NULL(ClipImages[13], "CLPLD13");
    
	
	if(debug) logputs("\t\tPreset Clipping Loaded Successfully\n");
	
	ToolDoor = get_datafile_bmp(OldData[IcoDoor].dat);
    abort_NULL(ClipImages[13], "TLDOOR");
    
	ToolEnemy = get_datafile_bmp(OldData[EnmyMellow].dat);
    abort_NULL(ClipImages[13], "TLENMY");
    
	IElevator = get_datafile_bmp(OldData[Elevator].dat);
    abort_NULL(ClipImages[13], "DRELEV");
    
	DoorImage = get_datafile_bmp(OldData[BeamDoor].dat);
    abort_NULL(ClipImages[13], "DRMIMG");
    
	DoorRt = get_datafile_bmp(OldData[DoorRgt].dat);
    abort_NULL(ClipImages[13], "DOOR&PRT");
    
	DoorLf = get_datafile_bmp(OldData[DoorLft].dat);
    abort_NULL(ClipImages[13], "DOOR&PLF");
    
	DoorUp = get_datafile_bmp(OldData[DoorBot].dat);
    abort_NULL(ClipImages[13], "DOOR&PUP");
    
	DoorDn = get_datafile_bmp(OldData[DoorTop].dat);
    abort_NULL(ClipImages[13], "DOOR&PDN");
    
	
	if(debug) logputs("\t\tLoading Custom Clipping...\n\n");
	while((ClipImages[i] = custom_clip(i)) != NULL) {
		i ++;
        ClipImages = (BITMAP **)qualloc(ClipImages, sizeof(BITMAP *) * (i+1));
	}
	clipamount = i;
    ClipImages = (BITMAP **)qualloc(ClipImages, sizeof(BITMAP *) * i);
    
	if(debug) logputs("\n\t\tLoaded Custom Clips\n\n");
}
