
#include "commonheaders.h"
#include "cls-menu.h"
#include "cls-window.h"
#include "initialization.h"
#include "menufunctions.h"
#include "winfunctions.h"
#include "window.h"

Menu *MainMenu = NULL;

void Initialize_Menus(void) {
    
    if(debug) logputs("\tInitializing Menu System:\n\n");
    MainMenu = new Menu;
    if(MainMenu == NULL) {
		allegro_message("Memory Error:\n    Error Number: &M0M\n    Memory could not be allocated for the menus.\n\nAborting Program");
        exit(1);
	}
    
    MainMenu->AddDir("File");
    MainMenu->AddItem("New", Clear_Area);
    MainMenu->AddItem("&sep", NULLF);
    MainMenu->AddItem("Load...", OpenLoadDialog);
    //MainMenu->AddItem("Save", OpenSaveDialog);
    MainMenu->AddItem("Save...", OpenSaveDialog);
    MainMenu->AddItem("&sep", NULLF);
    MainMenu->AddItem("Import Room...", OpenImportDialog);
    MainMenu->AddItem("Export Room...", OpenExportDialog);
    MainMenu->AddItem("&sep", NULLF);
    MainMenu->AddItem("Exit", Exit);
    MainMenu->AddDir("Edit");
    MainMenu->AddItem("Cut", Cut);
    MainMenu->AddItem("Copy", Copy);
    MainMenu->AddItem("Paste", Paste);
    MainMenu->AddItem("&sep", NULLF);
    MainMenu->AddItem("Clear", Clear);
    MainMenu->AddDir("Display");
    MainMenu->AddItem("Grid Lines", ViewGrids);
    MainMenu->Flagged(false, &showgrids);
    MainMenu->AddItem("Fading Tile Transparency", ViewFades);
    MainMenu->Flagged(false, &showfades);
    MainMenu->AddItem("Clipping", ViewClips);
    MainMenu->Flagged(false, &showclips);
    MainMenu->AddItem("Breakable Types", ViewBreaks);
    MainMenu->Flagged(false, &showbreaks);
    /*MainMenu->AddItem("#Camera Bounds", NULLF);
    MainMenu->Flagged(false, NULL);
    MainMenu->AddItem("#Door Highlights", NULLF);
    MainMenu->Flagged(false, NULL);*/
    /*MainMenu->AddItem("#Water Levels", NULLF);
    MainMenu->Flagged(true, NULL);*/
    MainMenu->AddDir("Windows");
    MainMenu->AddItem("Map Editor", OpenMapEdit);
    MainMenu->Flagged(true, &winMapEdit);
    MainMenu->AddItem("Room Editor", OpenRoomEdit);
    MainMenu->Flagged(false, &winRoomEdit);
    MainMenu->AddItem("Room Properties", OpenRoomProperties);
    MainMenu->Flagged(false, &winOpts);
    MainMenu->AddItem("Tiles", OpenTiles);
    MainMenu->Flagged(false, &winTiles);
    MainMenu->AddItem("Clips", OpenClips);
    MainMenu->Flagged(false, &winClips);
    MainMenu->AddItem("Breakables", OpenBreakables);
    MainMenu->Flagged(false, &winBreakables);
    MainMenu->AddItem("Doors", OpenDoors);
    MainMenu->Flagged(false, &winDoors);
    MainMenu->AddItem("Items", OpenItems);
    MainMenu->Flagged(false, &winItems);
    MainMenu->AddItem("Options", OpenOpts);
    MainMenu->Flagged(false, &winOpts);
    
}
