#include "commonheaders.h"
#include "cls-menu.h"
#include "initialization.h"

int speed_counter;

void increment_speed_counter() {
    speed_counter++;
}
END_OF_FUNCTION(increment_speed_counter);

volatile int fps, fps_counter = 0;
void timer_function(void)
{
 fps = fps_counter;
 fps_counter = 0;
}
END_OF_FUNCTION(timer_function);

void Initialize_Allegro(void) {
    allegro_init();                           // Initialize allegro system
    install_mouse();                          // Initialize Mouse routines
    install_timer();                          // Initialize Timer routines
    install_keyboard();                       // Initialize Keyboard routines

    //set_keyboard_rate(0,0);                   // Set Keyboard Repeat Rate
    set_volume_per_voice(0);
    install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL);  // Install digital audio
    
    /*----- Set the graphics mode and colour depth -----*/
    set_color_depth(16);                      // Set the screen to 16 bit colour
    Set_Screen();
    LOCK_FUNCTION(timer_function);            // Set the FPS timer to show fps rate
    LOCK_VARIABLE(fps_counter);
    LOCK_VARIABLE(fps);
    LOCK_VARIABLE(speed_counter);             // Used to set the timer - which
    LOCK_FUNCTION(increment_speed_counter);   // regulates the game's speed.

    install_int_ex(timer_function,BPS_TO_TIMER(1));
    install_int_ex(increment_speed_counter, BPS_TO_TIMER(60)); // Set the BPS
    
    text_mode(-1);                             // Transparent text
    
    set_display_switch_mode(SWITCH_BACKAMNESIA);  // Set the window running mode
    
    textprintf(screen, font, 8, 8, 65535, "Loading...");
}
