#include "commonheaders.h"
#include "cls-window.h"
#include "window.h"
#include "processing.h"
#include "winfunctions.h"

short tempX = -1;
short tempY = -1;

void ImportPlace(short xLocation, short yLocation) 
{
    if(roomTiles != NULL)
    {
        if(roomamount > 0)
        {
            if(yLocation >= 0 
            && xLocation >= 0)
            {
                if(yLocation + (roomTiles[roomamount - 1].ySize / 16) <= MapYSize 
                && xLocation + (roomTiles[roomamount - 1].xSize / 16) <= MapXSize){
                    
                    for(short y = yLocation; 
                        y < yLocation + (roomTiles[roomamount - 1].ySize / 16); 
                        y ++) 
                    {
                        if ( y < MapYSize )
                        {
                            for(short x = xLocation; 
                                x < xLocation + (roomTiles[roomamount - 1].xSize / 16); 
                                x ++) 
                            {
                                if ( x < MapXSize )
                                {
                                    // Add the room the the map grid
                					MapGrid[y][x] = roomamount;
                					
                					// Clear any special modifiers
                                    MapSpec[y][x] = 0;
                                }
                            }
                        }
                    }
                    
                    // Refresh the Map Viewport with the new room on it
                    Windows[RWin("Map Editor")]->Viewports[0]->Refresh();
                    
                    // Erase the dialog buffer
                    if(frozenbuf != NULL)
                    {
                        destroy_bitmap(frozenbuf);
                        frozenbuf = NULL;
                    }
                    
                    // Close the current dialog window and reset dialog data
                    if(Window_is_open(dialogwindow))
                    {
                        CloseWindow(dialogwindow);
                    }
                    dialogmode = false;
                    dialogwindow = 0;
                    
                    if(debug) logprintf("\nDimensions: %ix%i\n", roomTiles[roomamount - 1].xSize, roomTiles[roomamount - 1].ySize);
                    
                    // Open the room for editing if the Room Editor is open
                    if(Window_is_open(RWin("Room Editor"))) 
                    {
                        EditRoom();
                    }
                }
            }
        }
    }
}

void ImportHover(short xLocation, short yLocation) 
{
    // Save the location of the mouse on the viewport grid
	tempX = xLocation;
	tempY = yLocation;
}

void ImportDraw(BITMAP *output, short gridSize) {
    if(roomTiles != NULL) 
    {
        if(roomamount > 0)
        {
            if(tempX > -1 && tempY > -1) 
            {
                // Retrieve the viewport scrolling information
            	short y = Windows[RWin("Place Imported Room")]->Viewports[0]->yScroll;
            	short x = Windows[RWin("Place Imported Room")]->Viewports[0]->xScroll;
        		
        		// Create a bitmap the size of the room
                BITMAP *temp = create_bitmap(roomTiles[roomamount - 1].xSize / 16 * gridSize, (roomTiles[roomamount - 1].ySize / 16) * gridSize);
        		
        		// Make the temporary bitmap into a map room
                clear_to_color(temp, makecol(216, 56, 144));
        		rect(temp, 0, 0, temp->w - 1, temp->h - 1, makecol(248, 248, 248));
        		rect(temp, 1, 1, temp->w - 2, temp->h - 2, makecol(248, 248, 248));
        		
        		// Set transparency based on if the user is pressing the left mouse button
                if(mouse_b & 1)
        		{
        			set_trans_blender(0,0,0,255);
                }
        		else
        		{
        			set_trans_blender(0,0,0,128);
                }
                
                // Draw the room with the specified transparency onto the viewport
        		draw_trans_sprite(output, temp, (tempX - x) * gridSize + 1, (tempY - y) * gridSize + 1);
        		
        		// Destroy the temporary bitmap now that it is drawn
                destroy_bitmap(temp);
            }
        }
    }
}

