#include "commonheaders.h"
#include "ctype.h"
#include <time.h>

bool mouse_inarea(short window_lft_pos, short window_top_pos, short window_width, short window_height) {
    if(window_width < 1) window_width = 1;
    if(window_height < 1) window_height = 1;
    
    if(mouse_x >= window_lft_pos && mouse_x <= window_lft_pos + window_width) {
        if(mouse_y >= window_top_pos && mouse_y <= window_top_pos + window_height) {
            return(true);
        }
    }
    return(false);
}

char * strclr(char *string) {
    if(string != NULL) {
        short i;
        for(i = strlen(string); i > -1; i --) {
            string[i] = '\0';
        }
    }
}
void GetInputFromBuffer (char *outstring, char position, short type) 
{
    if ( inputbuffer != '\0' ) 
    {
        if ( inputbuffer >= 0x20 && inputbuffer <= 0x7E 
          // Restircted filename characters
          && inputbuffer != 0x22
          && inputbuffer != 0x2A
          && inputbuffer != 0x2F
          && inputbuffer != 0x3B
          && inputbuffer != 0x3C
          && inputbuffer != 0x3E
          && inputbuffer != 0x3F
          && inputbuffer != 0x5C
          && inputbuffer != 0x7C )
        {
            outstring[position] = inputbuffer;
        }
        else
        {
            switch ( inputbuffer_scancode )
            {
                case KEY_BACKSPACE:
                    if(outstring[position] != '\0') {
                         outstring[position] = '\0'; }
                    else  {
                        outstring[position - 1] = '\0'; }
                    break;
                default: break;
            }
        }
        inputbuffer = '\0';
    }
}
void PollKeyBuffer( ) {
    if ( keypressed() )
    {
        int bufferkey = readkey();
        inputbuffer = bufferkey & 0xFF;
        inputbuffer_scancode = bufferkey >> 0x08;
    }
    if ( inputbuffer < 0 ) inputbuffer = '\0';
}
/* //Salty's String Code
char *Get_String(char **ptr, int num)
{
    char string[32];// = (char *)qualloc(1);
    int i = 0;
    while((*ptr) + i != NULL && i < 5)
    {
        string[i] = (char)((*ptr) + i);
        printf("%c\n", ((char)((*ptr) + i));
        i ++;
        //string = (char *)qualloc(string, i);
    }
    printf("%s\n", string);
    readkey();
    return string;
}*/

void Init_String(char *string, char text[], int len)
{
    if(!len) len = strlen(string);
    for(int l = 0; l < len; l ++) string[l] = 0;

    if(strlen(text)) strcat(string, text);
}

void draw_hbar_gradient(BITMAP *dest, int x, int y, int w, int h, int col1, int col2){
    int r1, r2, g1, g2, b1, b2, i, col3;
    float r_grad, b_grad, g_grad;
    r1 = getr(col1);
    r2 = getr(col2);
    g1 = getg(col1);
    g2 = getg(col2);
    b1 = getb(col1);
    b2 = getb(col2);
    r_grad = ((r1 - r2) / (float)h);
    b_grad = ((b1 - b2) / (float)h);
    g_grad = ((g1 - g2) / (float)h);
    for(i = 0; i < h; i++){
        col3 = makecol((int)(r1 - (i * r_grad)), (int)(g1 - (i * g_grad)), (int)(b1 - (i * b_grad)));
        hline(dest, x, y + i, x + w, col3);
    }
}
void draw_vbar_gradient(BITMAP *dest, int x, int y, int w, int h, int col1, int col2){
    int r1, r2, g1, g2, b1, b2, i, col3;
    float r_grad, b_grad, g_grad;
    r1 = getr(col1);
    r2 = getr(col2);
    g1 = getg(col1);
    g2 = getg(col2);
    b1 = getb(col1);
    b2 = getb(col2);
    r_grad = ((r1 - r2) / (float)w);
    b_grad = ((b1 - b2) / (float)w);
    g_grad = ((g1 - g2) / (float)w);
    for(i = 0; i < w; i++){
        col3 = makecol((int)(r1 - (i * r_grad)), (int)(g1 - (i * g_grad)), (int)(b1 - (i * b_grad)));
        vline(dest, x + i, y, y + h, col3);
    }
}
void draw_diag_gradient(BITMAP *dest, int x, int y, int w, int h, int col1, int col2){
    int r1, r2, g1, g2, b1, b2, i, col3;
    float r_gradx, b_gradx, g_gradx;
    float r_grady, b_grady, g_grady;
    r1 = getr(col1);
    r2 = getr(col2);
    g1 = getg(col1);
    g2 = getg(col2);
    b1 = getb(col1);
    b2 = getb(col2);
    r_gradx = ((r1 - r2) / (float)w) / 2;
    b_gradx = ((b1 - b2) / (float)w) / 2;
    g_gradx = ((g1 - g2) / (float)w) / 2;
    r_grady = ((r1 - r2) / (float)h) / 2;
    b_grady = ((b1 - b2) / (float)h) / 2;
    g_grady = ((g1 - g2) / (float)h) / 2;
    for(i = 0; i < w; i++){
        col3 = makecol((int)(r1 - (i * r_gradx)), (int)(g1 - (i * g_gradx)), (int)(b1 - (i * b_gradx)));
        _putpixel16(dest, x + i, y, col3);
    }
    for(i = w; i < w * 2; i++){
        col3 = makecol((int)(r1 - (i * r_gradx)), (int)(g1 - (i * g_gradx)), (int)(b1 - (i * b_gradx)));
        _putpixel16(dest, x - w + i, y + h, col3);
    }
    for(i = 0; i < h; i++){
        col3 = makecol((int)(r1 - (i * r_grady)), (int)(g1 - (i * g_grady)), (int)(b1 - (i * b_grady)));
        _putpixel16(dest, x, y + i, col3);
    }
    for(i = h; i < h * 2; i++){
        col3 = makecol((int)(r1 - (i * r_grady)), (int)(g1 - (i * g_grady)), (int)(b1 - (i * b_grady)));
        _putpixel16(dest, x + w, y - h + i, col3);
    }
    _putpixel16(dest, x + w, y + h, col2);
}
int dearachnids = 0;
debuglist *dearachnid = NULL;
void *qualloc(void *pnt, int size)
{
    if(pnt == NULL) 
    {
        FILE *logfile = fopen("memory.log", "a");
        pnt = malloc(size);
        
        dearachnids ++;
        dearachnid = (debuglist *)realloc(dearachnid, sizeof(debuglist) *dearachnids);
        dearachnid[dearachnids - 1].pointy = (int)pnt;
        dearachnid[dearachnids - 1].sizey = size;
        
        time_t tval = time(NULL);
        struct tm *now = localtime(&tval);
        char *tempString = asctime(now);
        tempString[19] = '\0';
        
        if(debug) fprintf(logfile, "[%s] Allocating Memory ( AD[%i] SZ[%i] )\n", tempString, dearachnid[dearachnids - 1].pointy, dearachnid[dearachnids - 1].sizey);
        fclose(logfile);
        return pnt;
        //return malloc(size);
    }
    else 
    {
        /*FILE *logfile = fopen("memory.log", "a");
        short i;
        for ( i = 0; i < dearachnids ; i ++)
        {
            if(dearachnid[i].pointy == (int)pnt)
                break;
        }
        if( i < dearachnids ) i ++;
        
        void *tempPnt = realloc(pnt, size);
        dearachnid[i - 1].pointy = (int)tempPnt;
        dearachnid[i - 1].sizey = size;
        if(debug) fprintf(logfile, "Rellocating Memory ( AD[%i] SZ[%i] )\n", tempPnt, size);
        fclose(logfile);
        return tempPnt;*/
        return realloc(pnt, size);
    }
    return NULL;
}
void *qualloc(void *pnt, int size, int size2)
{
    if(pnt == NULL)
        return calloc(size2, size);
    else
        return realloc(pnt, size * size2);
    return NULL;
}
void *qualloc(int size)
{
    /*FILE *logfile = fopen("Editlog.log", "a");
    void *pnt;
    dearachnids ++;
    dearachnid = (debuglist *)realloc(dearachnid, sizeof(debuglist) *dearachnids);
    pnt = malloc(size);
    dearachnid[dearachnids - 1].pointy = (int)pnt;
    dearachnid[dearachnids - 1].sizey = size;
    if(debug) fprintf(logfile, "Allocating Memory(AD[%i] SZ[%i])\n", dearachnid[dearachnids - 1].pointy, dearachnid[dearachnids - 1].sizey);
    fclose(logfile);
    return pnt;*/
    return malloc(size);
}
int init_logging(void)
{
    FILE *logfile = fopen("Editlog.log", "a");
    
    time_t tval = time(NULL);
    struct tm *now = localtime(&tval);
    
    fputs("\n\n", logfile);
    fputs("============================================================\n", logfile);
    fputs("Super Metroid Classic Level Editor Process Log Dump\n", logfile);
    fputs("Date: ", logfile);
    fputs(asctime(now), logfile);
    fputs("============================================================\n\n", logfile);
    
    fclose(logfile);
    
    logfile = fopen("memory.log", "a");
    
    fputs("\n\n", logfile);
    fputs("============================================================\n", logfile);
    fputs("Super Metroid Classic Level Editor Memory Log Dump\n", logfile);
    fputs("Date: ", logfile);
    fputs(asctime(now), logfile);
    fputs("============================================================\n\n", logfile);
    
    fclose(logfile);
    return(0);
}
int logprintf(const char *format, ...)
{
    FILE *logfile = fopen("Editlog.log", "a");
    
    va_list argptr;
    short argcount = 0;
    for(short i = 0; 
        i < strlen(format); 
        i++)
    {
        if(format[i] == '%')
            argcount ++;
    }
    va_start(argptr, format);
        
    for(short i = 0; 
        i < strlen(format); 
        i++)
    {
        if(format[i] == '%')
        {
            short j = i + 1;
            char *tempString = (char*)qualloc(strlen(format)- i + 1);
            
            tempString[0] = format[i];
            
            while((format[j - 1] < 97 || format[j - 1] > 122) && j < strlen(format))
            {
                tempString[j - i] = format[j];
                j++;
            }
            
            tempString[j - i] = '\0';
            fprintf(logfile, tempString, va_arg(argptr, void*));
            printf(tempString, va_arg(argptr, void*));
            
            free(tempString);
            
            i += j - i - 1;
        }
        else if(format[i] == '\\')
        {
            // Write commands
            char tempString[2] = {format[i], format[i+1]};
            fputs(tempString, logfile);
            puts(tempString);
            i++;
        }
        else
        {
            // Write the character
            fputc(format[i], logfile);
            printf("%c", format[i]);
        }
    }
    
    va_end(argptr);
    
    fclose(logfile);
    
    return(0);
}
int logputs(const char *stringy)
{
    short blah;
    int yak;
    
    FILE *logfile = fopen("Editlog.log", "a");
    
    fputs(stringy, logfile);
    puts(stringy);
    
    fclose(logfile);
    
    return(0);
}
void Copy_Structure(unsigned char *objsrc, int size, unsigned char *objdest)//Does not check destination clipping
{
    for(int i = 0; i < size; i ++)
    {
        objdest[i] = objsrc[i];
    }
}
BITMAP *get_datafile_bmp(void * datafile)
{
    if(datafile == NULL)
        return NULL;
    
    BITMAP *dataBMP = (BITMAP*)datafile;
    BITMAP *tempBMP = create_bitmap(dataBMP->w, dataBMP->h);
    blit(dataBMP, tempBMP, 0, 0, 0, 0, dataBMP->w, dataBMP->h);
    
    bmp_alloc_amount ++;
    bmp_array = (BITMAP **)realloc(bmp_array, bmp_alloc_amount * sizeof(BITMAP *));
    bmp_array[bmp_alloc_amount - 1] = tempBMP;
    
    dataBMP = NULL;
    return(tempBMP);
}
BITMAP *swap_filed_bmp(BITMAP *currBMP, BITMAP *copyBMP)
{
    if(currBMP != NULL)
    {
        int position = -1;
        for(int i = 0; i < bmp_alloc_amount; i ++)
        {
            if(currBMP == bmp_array[i])
            {
                position = i;
                i = bmp_alloc_amount;
            }
        }
        if( position > -1 )
        {
            bmp_array[position] = bmp_array[bmp_alloc_amount - 1];
            bmp_alloc_amount --;
            bmp_array = (BITMAP **)realloc(bmp_array, bmp_alloc_amount * sizeof(BITMAP *));
            destroy_bitmap(currBMP);
            currBMP = copyBMP;
        }
    }
}
void free_datafile_bmps(void)
{
    for( bmp_alloc_amount ; bmp_alloc_amount > 0 ; bmp_alloc_amount -- )
    {
        if(bmp_array)
        {
            if(bmp_array[bmp_alloc_amount - 1])
            {
                destroy_bitmap(bmp_array[bmp_alloc_amount - 1]);
            }
        }
    }
    if(bmp_array)
    {
        free(bmp_array);
    }
}
void abort_NULL(void * pnt, const char error_code[])
{
    if(pnt == NULL) 
    {
		allegro_message("Errorn\n\nCode '%s'.\n\nAborting Program.", error_code);
		exit(1);
	}
}
void PrintLoc()
{
    printf("%i\n", ploc);
    ploc ++;
    readkey();
}

void quexit(int error)
{
    printf("\n\nOMG EXITING ERROR %i", error);
    readkey();
    exit(error);
}
