#include "commonheaders.h"
#include "cls-window.h"
#include "cls-windraw.h"

Window::Window(short xLocation, short yLocation, short winWidth, short winHeight, char *title, void (*funct)(void)) {
    mobile = true;
    hides = true;
    pushhide = false;
    visible = true;
    closes = true;
    returns = true;
    pushclose = false;
    active = true;
    xPos = xLocation;
    yPos = yLocation + 17;
    orixPos = xLocation;
    oriyPos = yLocation + 17;
    width = winWidth;
    height = winHeight;
    close = funct;
    grabX = -1;
    grabY = -1;
    label = (char *)qualloc(strlen(title)+1);
    Init_String(label, title, 0);
    labels = 0;
    buttons = 0;
    sliders = 0;
    selectors = 0;
    scrollboxes = 0;
    textboxes = 0;
    listboxes = 0;
    checkboxes = 0;
    viewports = 0;
    Labels = NULL;
    Buttons = NULL;
    Sliders = NULL;
    Selectors = NULL;
    ScrollBoxes = NULL;
    TextBoxes = NULL;
    ListBoxes = NULL;
    CheckBoxes = NULL;
    Viewports = NULL;
}
Window::~Window() {
    free(label);
    for(short i = 0; i < labels; i ++) {
        delete(Labels[i]);
    }
    for(short i = 0; i < buttons; i ++) {
        delete(Buttons[i]);
    }
    for(short i = 0; i < sliders; i ++) {
        delete(Sliders[i]);
    }
    for(short i = 0; i < selectors; i ++) {
        delete(Selectors[i]);
    }
    for(short i = 0; i < scrollboxes; i ++) {
        delete(ScrollBoxes[i]);
    }
    for(short i = 0; i < textboxes; i ++) {
        delete(TextBoxes[i]);
    }
    for(short i = 0; i < listboxes; i ++) {
        delete(ListBoxes[i]);
    }
    for(short i = 0; i < listboxes; i ++) {
        delete(CheckBoxes[i]);
    }
    for(short i = 0; i < viewports; i ++) {
        delete(Viewports[i]);
    }
}
bool Window::AddLabel(short xLocation, short yLocation, char *text) {
    //if(!strcmp(text, "Editing:")) { printf("\nedit");readkey(); }
    Labels = (Label **)realloc(Labels, sizeof(Label *) * (labels + 1));
    //if(!strcmp(text, "Editing:")) { printf("\nedit");readkey(); }
    Labels[labels] = new Label(xLocation + 4, yLocation + 17, text);
    if(Labels[labels] == NULL) {
        return false;
    }
    labels ++;
    return true;
}
bool Window::AddLabel(short xLocation, short yLocation, BITMAP *mainImage) {
    Labels = (Label **)qualloc(Labels, sizeof(Label *) * (labels + 1));
    Labels[labels] = new Label(xLocation + 4, yLocation + 17, mainImage);
    if(Labels[labels] == NULL) {
        return false;
    }
    labels ++;
    return true;
}
bool Window::AddButton(short xLocation, short yLocation, short winWidth, short winHeight, char *text, void (*funct)(void)) {
    Buttons = (Button **)qualloc(Buttons, sizeof(Button *) * (buttons + 1));
    Buttons[buttons] = new Button(xLocation + 4, yLocation + 17, winWidth, winHeight, text, funct);
    if(Buttons[buttons] == NULL) {
        return false;
    }
    buttons ++;
    return true;
}

bool Window::AddButton_D(short xLocation, short yLocation, short winWidth, short winHeight, char *text, void (*funct)(void)) {
    readkey();
    Buttons = (Button **)qualloc(Buttons, sizeof(Button *) * (buttons + 1));
    readkey();
    Buttons[buttons] = new Button(xLocation + 4, yLocation + 17, winWidth, winHeight, text, funct);
    readkey();
    if(Buttons[buttons] == NULL) {
        return false;
    }
    readkey();
    buttons ++;
    return true;
}

bool Window::AddButton(short xLocation, short yLocation, short winWidth, short winHeight, BITMAP *mainImage, void (*funct)(void)) {

    Buttons = (Button **)qualloc(Buttons, sizeof(Button *) * (buttons + 1));
    Buttons[buttons] = new Button(xLocation + 4, yLocation + 17, winWidth, winHeight, mainImage, funct);

    if(Buttons[buttons] == NULL) {
        return false;
    }
    buttons ++;
    return true;
}

bool Window::AddButton(short xLocation, short yLocation, short winWidth, short winHeight, BITMAP *mainImage, BITMAP *switchimage, void (*funct)(void)) {
    Buttons = (Button **)qualloc(Buttons, sizeof(Button *) * (buttons + 1));
    Buttons[buttons] = new Button(xLocation + 4, yLocation + 17, winWidth, winHeight, mainImage, switchimage, funct);
    if(Buttons[buttons] == NULL) {
        return false;
    }
    buttons ++;
    return true;
}
bool Window::AddSelector(short xLocation, short yLocation, short winWidth, short winHeight, char *text, short *refval, short triggerval) {
    if(refval != NULL) {
        Selectors = (Selector **)qualloc(Selectors, sizeof(Selector *) * (selectors + 1));
        Selectors[selectors] = new Selector(xLocation + 4, yLocation + 17, winWidth, winHeight, text, refval, triggerval);
        if(Selectors[selectors] == NULL) {
            return false;
        }
        selectors ++;
        return true;
    } else {
        return false;
    }
}
bool Window::AddSelector(short xLocation, short yLocation, short winWidth, short winHeight, BITMAP *mainImage, short *refval, short triggerval) {
    if(refval != NULL) {
        Selectors = (Selector **)qualloc(Selectors, sizeof(Selector *) * (selectors + 1));
        Selectors[selectors] = new Selector(xLocation + 4, yLocation + 17, winWidth, winHeight, mainImage, refval, triggerval);
        if(Selectors[selectors] == NULL) {
            return false;
        }
        selectors ++;
        return true;
    } else {
        return false;
    }
}
bool Window::AddSlider(short xLocation, short yLocation, short winWidth, short *refval, short lowval, short highval, short increment, bool marked) {
    if(refval != NULL) {
        Sliders = (Scroller **)qualloc(Sliders, sizeof(Scroller *) * (sliders + 1));
        Sliders[sliders] = new Scroller(xLocation + 4, yLocation + 17, winWidth, refval, lowval, highval, increment, marked);
        if(Sliders[sliders] == NULL) {
            return false;
        }
        sliders ++;
        return true;
    } else {
        return false;
    }
}
bool Window::AddScrollBox(short xLocation, short yLocation, short winWidth, bool dropdown, short *refval, short lowval, short highval, short increment) {
    ScrollBoxes = (ScrollBox **)qualloc(ScrollBoxes, sizeof(ScrollBox *) * (scrollboxes + 1));
    ScrollBoxes[scrollboxes] = new ScrollBox(xLocation + 4, yLocation + 17, winWidth, dropdown, 0, refval, lowval, highval, increment);
    if(ScrollBoxes[scrollboxes] == NULL) {
        return false;
    }
    scrollboxes ++;
    return true;
}
bool Window::AddListScrollBox(short xLocation, short yLocation, short winWidth, bool dropdown, short *refval, int args, ...) {
    ScrollBoxes = (ScrollBox **)qualloc(ScrollBoxes, sizeof(ScrollBox *) * (scrollboxes + 1));
    ScrollBoxes[scrollboxes] = new ScrollBox(xLocation + 4, yLocation + 17, winWidth, dropdown, 1, refval, 0, -1, 1);
    va_list argptr;
    va_start(argptr, args);
    if(ScrollBoxes[scrollboxes] == NULL) {
        return false;
    }
    for(short i = 0; i < args; i ++)
    {
        ScrollBoxes[scrollboxes]->AddItem(va_arg(argptr, char*));
    }
    scrollboxes ++;
    return true;
}
bool Window::AddTextBox(short xLocation, short yLocation, short winWidth, char **stringarray) {
    TextBoxes = (TextBox **)qualloc(TextBoxes, sizeof(TextBox *) * (textboxes + 1));
    TextBoxes[textboxes] = new TextBox(xLocation + 4, yLocation + 17, winWidth, stringarray);
    if(TextBoxes[textboxes] == NULL) {
        return false;
    }
    textboxes ++;
    return true;
}

bool Window::AddTextBox(short xLocation, short yLocation, short winWidth, bool clearbox, void (*funct)(char *)) {
    TextBoxes = (TextBox **)qualloc(TextBoxes, sizeof(TextBox *) * (textboxes + 1));
    TextBoxes[textboxes] = new TextBox(xLocation + 4, yLocation + 17, winWidth, clearbox, funct);
    if(TextBoxes[textboxes] == NULL) {
        return false;
    }
    textboxes ++;
    return true;
}
bool Window::AddListBox(short xLocation, short yLocation, short winWidth, short elements, short *refval, int args, ...) {
    ListBoxes = (ListBox **)qualloc(ListBoxes, sizeof(ListBox *) * (listboxes + 1));
    ListBoxes[listboxes] = new ListBox(xLocation + 4, yLocation + 17, winWidth, elements, refval);
    va_list argptr;
    va_start(argptr, args);
    if(ListBoxes[listboxes] == NULL) {
        return false;
    }
    for(short i = 0; i < args; i ++)
    {
        ListBoxes[listboxes]->AddItem(va_arg(argptr, char*));
    }
    listboxes ++;
    return true;
}
bool Window::AddCheckBox(short xLocation, short yLocation, char *texty, bool *refval) {
    CheckBoxes = (CheckBox **)qualloc(CheckBoxes, sizeof(CheckBox *) * (checkboxes + 1));
    CheckBoxes[checkboxes] = new CheckBox(xLocation + 4, yLocation + 17, texty, refval);
    if(CheckBoxes[checkboxes] == NULL) {
        return false;
    }
    checkboxes ++;
    return true;
}
bool Window::AddCheckBox(short xLocation, short yLocation, char *texty, void (*proc)(bool)) {
    CheckBoxes = (CheckBox **)qualloc(CheckBoxes, sizeof(CheckBox *) * (checkboxes + 1));
    CheckBoxes[checkboxes] = new CheckBox(xLocation + 4, yLocation + 17, texty, proc);
    if(CheckBoxes[checkboxes] == NULL) {
        return false;
    }
    checkboxes ++;
    return true;
}
bool Window::AddViewport(short xLocation, short yLocation, short xNum, short yNum, short grid) {
    Viewports = (Viewport **)qualloc(Viewports, sizeof(Viewport *) * (viewports + 1));
    Viewports[viewports] = new Viewport(xLocation + 4, yLocation + 17, xNum, yNum, grid);
    if(Viewports[viewports] == NULL) {
        return false;
    }
    viewports ++;
    return true;
}
char *Window::WindowTitle(void) {
    return label;
}
bool Window::AddListBoxItem(short box, char *string) {
    ListBoxes[box]->AddItem(string);
}
void Window::Mobile(void) {
    mobile = true;
}
void Window::Immobile(void) {
    mobile = false;
}
void Window::Shades(void) {
    hides = true;
}
void Window::NoShade(void) {
    hides = false;
}
void Window::Returns(void) {
    returns = true;
}
void Window::NoReturn(void) {
    returns = false;
}
void Window::Closes(void) {
    closes = true;
}
void Window::NoClose(void) {
    closes = false;
}
void Window::Open(void) {
    active = true;
}
void Window::Close(void) {
    active = false;
}
void Window::Set_Pos(short xLocation, short yLocation) {
    xPos = xLocation;
    yPos = yLocation;
}
void Window::In_Screen(void) {
    if(yPos < 17) yPos = 17;
    if(xPos < 0) xPos = 0;
    if(xPos + width > main_width - 1) xPos = main_width - width - 1;
    if(visible) {
        if(yPos + height > main_height - 1) yPos = main_height - height - 1;
    } else {
        if(yPos + 29 > main_height - 1) yPos = main_height - 19;
    }
}
int Window::Check(void) {
    short retint;
    retint = -1;
    if(active) {
        for(short i = 0; i < scrollboxes; i ++) {
            if(ScrollBoxes[i]) {
                waitingforinput = ScrollBoxes[i]->Check(xPos, yPos);
            }
        }
        for(short i = 0; i < textboxes; i ++) {
            if(TextBoxes[i]) {
                waitingforinput = TextBoxes[i]->Check(xPos, yPos);
            }
        }
        retint = 0;
        if(mouse_inarea(xPos, yPos, width, height) && !grab) {
            if(mouse_inarea(xPos, yPos + 17, width, height)) {
                if(visible) {
                    if(mouse_b & 1) {
                        retint = 1;
                    }
                    for(short i = 0; i < buttons; i ++) {
                        Buttons[i]->Check(xPos, yPos);
                    }
                    for(short i = 0; i < selectors; i ++) {
                        Selectors[i]->Check(xPos, yPos);
                    }
                    for(short i = 0; i < sliders; i ++) {
                        Sliders[i]->Check(xPos, yPos);
                    }
                    for(short i = 0; i < listboxes; i ++) {
                        ListBoxes[i]->Check(xPos, yPos);
                    }
                    for(short i = 0; i < checkboxes; i ++) {
                        CheckBoxes[i]->Check(xPos, yPos);
                    }
                    for(short i = 0; i < viewports; i ++) {
                        Viewports[i]->Check(xPos, yPos);
                    }
                }
            } else {
                if(mouse_b & 1) {
                    retint = 1;
                }
                if(mouse_inarea(xPos + width - 45, yPos + 2, 13, 12) && returns) {
                    if(mouse_b & 1 && !pushorigin) {
                        pushorigin = true;
                    }
                    if(!mouse_b & 1 && pushorigin) {
                        pushorigin = false;
                        xPos = orixPos;
                        yPos = oriyPos;
                    }
                } 
                if(mouse_inarea(xPos + width - 15, yPos + 2, 13, 12) && closes) {
                    if(mouse_b & 1 && !pushclose) {
                        pushclose = true;
                    }
                    if(!mouse_b & 1 && pushclose) {
                        pushclose = false;
                        active = false;
                        retint = -1;
                        close();
                    }
                } 
                if(mouse_inarea(xPos + width - 30, yPos + 2, 13, 12) && hides) {
                    if(mouse_b & 1 && !pushhide) {
                        pushhide = true;
                    }
                    if(!mouse_b & 1 && pushhide) {
                        pushhide = false;
                        if(visible) {
                            visible = false;
                        } else {
                            visible = true;
                            if(yPos + height > main_height) yPos = main_height - height - 1;
                        }
                    }
                } else if(mouse_b & 1 && mobile) {
                    if(!grab && !pushclose && !pushhide && !pushorigin) {
                        grabX = mouse_x - xPos;
                        grabY = mouse_y - yPos;
                        grab = true;
                    }
                } else {
                    if(pushclose) {
                        pushclose = false;
                    }
                    if(pushhide) {
                        pushhide = false;
                    }
                    if(pushorigin) {
                        pushorigin = false;
                    }
                }
            }
        }
        if(grab && mobile) {
            retint = 1;
            if(mouse_b & 1) {
                xPos = mouse_x - grabX;
                yPos = mouse_y - grabY;
                if(yPos < 17) yPos = 17;
                if(xPos < 0) xPos = 0;
                if(xPos + width > main_width - 1) xPos = main_width - width - 1;
                if(visible) {
                    if(yPos + height > main_height - 1) yPos = main_height - height - 1;
                } else {
                    if(yPos + 29 > main_height - 1) yPos = main_height - 19;
                }
            } else {
                grabX = -1;
                grabY = -1;
                grab = false;
            }
        }
    }
    return(retint);
}
void Window::Draw(BITMAP *output) {
    if(active) {
        if(visible) {
            gui_window(output, xPos, yPos, width, height, makecol(80, 80, 80));
            if(closes) {
                if(pushclose && mouse_inarea(xPos + width - 15, yPos + 2, 13, 12)) {
                    draw_sprite(output, WinClosePush, xPos + width - 15, yPos + 2);
                } else {
                    draw_sprite(output, WinClose, xPos + width - 15, yPos + 2);
                }
            }
            if(hides) {
                if(pushhide && mouse_inarea(xPos + width - 30, yPos + 2, 13, 12)) {
                    draw_sprite(output, WinShadePush, xPos + width - 30, yPos + 2);
                } else {
                    draw_sprite(output, WinShade, xPos + width - 30, yPos + 2);
                }
            }
            if(returns) {
                if(pushorigin && mouse_inarea(xPos + width - 45, yPos + 2, 13, 12)) {
                    draw_sprite(output, WinRestorePush, xPos + width - 45, yPos + 2);
                } else {
                    draw_sprite(output, WinRestore, xPos + width - 45, yPos + 2);
                }
            }
            textprintf(output, font, xPos + 5, yPos + 4, BLACK, label);
            textprintf(output, font, xPos + 4, yPos + 3, WHITE, label);
            short i;
            for(i = 0; i < buttons; i ++) {
                if(Buttons[i]) {
                    Buttons[i]->Draw(output, xPos, yPos);
                }
            }
            for(i = 0; i < selectors; i ++) {
                if(Selectors[i]) {
                    Selectors[i]->Draw(output, xPos, yPos);
                }
            }
            for(i = 0; i < sliders; i ++) {
                if(Sliders[i]) {
                    Sliders[i]->Draw(output, xPos, yPos);
                }
            }
            for(i = 0; i < scrollboxes; i ++) {
                if(ScrollBoxes[i]) {
                    ScrollBoxes[i]->Draw(output, xPos, yPos);
                }
            }
            for(i = 0; i < textboxes; i ++) {
                if(TextBoxes[i]) {
                    TextBoxes[i]->Draw(output, xPos, yPos);
                }
            }
            for(i = 0; i < listboxes; i ++) {
                if(ListBoxes[i]) {
                    ListBoxes[i]->Draw(output, xPos, yPos);
                }
            }
            for(i = 0; i < checkboxes; i ++) {
                if(CheckBoxes[i]) {
                    CheckBoxes[i]->Draw(output, xPos, yPos);
                }
            }
            for(i = 0; i < labels; i ++) {
                if(Labels[i]) {
                    Labels[i]->Draw(output, xPos, yPos);
                }
            }
            for(i = 0; i < viewports; i ++) {
                if(Viewports[i]) {
                    Viewports[i]->Draw(output, xPos, yPos);
                }
            }
        } else {
            winshade_window(output, xPos, yPos, width, 18);
            if(closes) {
                if(pushclose && mouse_inarea(xPos + width - 15, yPos + 2, 13, 12)) {
                    draw_sprite(output, WinClosePush, xPos + width - 15, yPos + 2);
                } else {
                    draw_sprite(output, WinClose, xPos + width - 15, yPos + 2);
                }
            }
            if(hides) {
                if(pushhide && mouse_inarea(xPos + width - 30, yPos + 2, 13, 12)) {
                    draw_sprite(output, WinShadePush, xPos + width - 30, yPos + 2);
                } else {
                    draw_sprite(output, WinShade, xPos + width - 30, yPos + 2);
                }
            }
            if(returns) {
                if(pushorigin && mouse_inarea(xPos + width - 45, yPos + 2, 13, 12)) {
                    draw_sprite(output, WinRestorePush, xPos + width - 45, yPos + 2);
                } else {
                    draw_sprite(output, WinRestore, xPos + width - 45, yPos + 2);
                }
            }
            textprintf(output, font, xPos + 5, yPos + 4, BLACK, label);
            textprintf(output, font, xPos + 4, yPos + 3, WHITE, label);
        }
    }
}
