#include "commonheaders.h"
#include "cls-window.h"
#include "cls-windraw.h"

Scroller::Scroller(short xLocation, short yLocation, short winWidth, short *refval, short lowval, short highval, short increment, bool marked) {
    xPos = xLocation;
    yPos = yLocation;
    width = winWidth;
    ref = refval;
    ticks = marked;
    left = false;
    right = false;
    barclick = false;
    
    low = lowval;
    high = highval;
    inc = increment;
    spacing = (width - 34);
    spacing /= (((high - low) / inc));
}
bool Scroller::Check(short xLocation, short yLocation) {
    if(mouse_inarea(xPos + 1 + xLocation, yPos + 1 + yLocation, 9, 10)) {
        if(mouse_b & 1 && !left) {
            left = true;
            right = false;
            if(*ref > low) *ref -= inc;
            if(*ref < low) *ref = low;
        }
    } else if (mouse_inarea(xPos + width - 11 + xLocation, yPos + 1 + yLocation, 9, 10)) {
        if(mouse_b & 1 && !right) {
            right = true;
            left = false;
            if(*ref < high) *ref += inc;
            if(*ref > high) *ref = high;
        }
    } else if(mouse_inarea(xPos + 14 + xLocation, yPos - 2 + yLocation, width - 28, 15)) {
        if(mouse_b & 1 && !barclick) {
            for(short i = 0; i <= ((high - low) / inc); i ++) {
                if(mouse_inarea(xPos + xLocation + (int)(i * spacing) - (int)(spacing / 2) + 16, yPos - 2 + yLocation, (int)(spacing) + 1, 15)) {
                    *ref = i * inc + low;
                }
            }
            right = false;
            left = false;
        }
    } else {
        left = false;
        right = false;
        barclick = false;
    }
    if(!(mouse_b & 1)) {
        left = false;
        right = false;
        barclick = false;
    }
    return false;
}
void Scroller::Draw(BITMAP *output, short xLocation, short yLocation) {
    
    if(!left) {
        draw_sprite(output, SliderEnd, xPos + xLocation, yPos + yLocation);
    } else {
        draw_sprite(output, SliderPush, xPos + xLocation, yPos + yLocation);
    }
    line(output, xPos + 15 + xLocation, yPos + 2 + yLocation, xPos + width - 16 + xLocation, yPos + 2 + yLocation, makecol(0,0,0));
    line(output, xPos + 15 + xLocation, yPos + 3 + yLocation, xPos + width - 16 + xLocation, yPos + 3 + yLocation, makecol(128,128,128));
    line(output, xPos + 15 + xLocation, yPos + 4 + yLocation, xPos + width - 16 + xLocation, yPos + 4 + yLocation, makecol(64,64,64));
    line(output, xPos + 15 + xLocation, yPos + 5 + yLocation, xPos + width - 16 + xLocation, yPos + 5 + yLocation, makecol(96,96,96));
    line(output, xPos + 15 + xLocation, yPos + 6 + yLocation, xPos + width - 16 + xLocation, yPos + 6 + yLocation, makecol(128,128,128));
    line(output, xPos + 15 + xLocation, yPos + 7 + yLocation, xPos + width - 16 + xLocation, yPos + 7 + yLocation, makecol(160,160,160));
    line(output, xPos + 15 + xLocation, yPos + 8 + yLocation, xPos + width - 16 + xLocation, yPos + 8 + yLocation, makecol(192,192,192));
    if(!right) {
        draw_sprite_h_flip(output, SliderEnd, xPos + width - 16 + xLocation, yPos + yLocation);
    } else {
        draw_sprite_h_flip(output, SliderPush, xPos + width - 16 + xLocation, yPos + yLocation);
    }
    if(ticks) {
        for(short i = 0; i <= ((high - low) / inc); i ++) {
            line(output, xPos + xLocation + 16 + (int)(i * spacing), yPos - 2 + yLocation, xPos + xLocation + 16 + (int)(i * spacing), yPos + yLocation, makecol(0,0,0));
        }
    }
    draw_sprite(output, Slider, xPos + xLocation + 14 + (int)((*ref - low) / inc * spacing), yPos + yLocation - 1);
}
