#include "commonheaders.h"
#include "classes-window.h"
#include "classes-window-drawing.h"

extern bool mouse_inarea(short window_lft_pos, short window_top_pos, short window_width, short window_height);
extern bool grab;
extern bool debug;
extern BITMAP *WinClose;
extern BITMAP *WinClosePush;
extern BITMAP *WinShade;
extern BITMAP *WinShadePush;

Label::Label(short xLocation, short yLocation, char *text) {
    xPos = xLocation;
    yPos = yLocation;
    label = (char *)calloc(strlen(text)+1, sizeof(char));
    strcpy(label, text);
    label[strlen(text)+1] = '\0';

    image = NULL;
}
Label::Label(short xLocation, short yLocation, BITMAP *mainImage) {
    xPos = xLocation;
    yPos = yLocation;
    image = mainImage;
    
    label = NULL;
}
void Label::SetText(char *text) {
    label = (char *)calloc(strlen(text)+1, sizeof(char));
    strcpy(label, text);
    label[strlen(text)+1] = '\0';
}
void Label::SetImage(BITMAP *mainImage) {
    image = mainImage;
}
void Label::Draw(BITMAP *output) {
    if(image == NULL) {
        textprintf(output, font, xPos + 1, yPos + 1, BLACK, label);
        textprintf(output, font, xPos, yPos, WHITE, label);
    } else {
        draw_sprite(output, image, xPos, yPos);
    }
}
void Label::Draw(BITMAP *output, short xLocation, short yLocation) {
    if(label != NULL) {
        textprintf(output, font, xPos + xLocation + 1, yPos + yLocation + 1, BLACK, label);
        textprintf(output, font, xPos + xLocation, yPos + yLocation, WHITE, label);
    } else {
        draw_sprite(output, image, xPos + xLocation, yPos + yLocation);
    }
}

Button::Button(short xLocation, short yLocation, short winWidth, short winHeight, char *text, void (*funct)(void)) {
    label = (char *)calloc(strlen(text)+1, sizeof(char));
    strcpy(label, text);
    label[strlen(text)+1] = '\0';
    xPos = xLocation;
    yPos = yLocation;
    width = winWidth;
    height = winHeight;
    pressed = false;
    this->funct = funct;
    
    image = NULL;
    pressimage = NULL;
}

Button::Button(short xLocation, short yLocation, short winWidth, short winHeight, BITMAP *mainImage, void (*funct)(void)) {
    xPos = xLocation;
    yPos = yLocation;
    width = winWidth;
    image = mainImage;
    height = winHeight;
    pressed = false;
    this->funct = funct;
    
    label = NULL;
    pressimage = NULL;
}

Button::Button(short xLocation, short yLocation, short winWidth, short winHeight, BITMAP *mainImage, BITMAP *switchimage, void (*funct)(void)) {
    xPos = xLocation;
    yPos = yLocation;
    width = winWidth;
    image = mainImage;
    height = winHeight;
    pressimage = switchimage;
    pressed = false;
    this->funct = funct;
    
    label = NULL;
}
bool Button::Check(void) {
    if(mouse_inarea(xPos, yPos, width, height)) {
        if(mouse_b & 1) {
            pressed = true;
        } else {
            if(pressed) {
                funct();
                pressed = false;
            }
        }
    } else {
        if(pressed) pressed = false;  
    }
    return false;
}
bool Button::Check(short xLocation, short yLocation) {
    if(mouse_inarea(xPos + xLocation, yPos + yLocation, width, height)) {
        if(mouse_b & 1) {
            pressed = true;
        } else {
            if(pressed) {
                funct();
                pressed = false;
            }
        }
    } else {
        if(pressed) pressed = false;  
    }
    return false;
}
void Button::Draw(BITMAP *output) {
    if(image == NULL) {
        button(output, xPos, yPos, width, height, makecol(96, 96, 96), pressed, NULL, label);
    } else {
        if(pressed && pressimage != NULL) {
            button(output, xPos, yPos, width, height, makecol(127, 127, 127), pressed, pressimage, NULL);
        } else {
            button(output, xPos, yPos, width, height, makecol(127, 127, 127), pressed, image, NULL);
        }
    }
}
void Button::Draw(BITMAP *output, short xLocation, short yLocation) {
    if(image == NULL) {
        button(output, xPos + xLocation, yPos + yLocation, width, height, makecol(96, 96, 96), pressed, NULL, label);
    } else {
        if(pressed && pressimage != NULL) {
            button(output, xPos + xLocation, yPos + yLocation, width, height, makecol(127, 127, 127), pressed, pressimage, NULL);
        } else {
            button(output, xPos + xLocation, yPos + yLocation, width, height, makecol(127, 127, 127), pressed, image, NULL);
        }
    }
}

Window::Window(short xLocation, short yLocation, short winWidth, short winHeight, char *title) {
    mobile = true;
    hides = true;
    pushhide = false;
    visible = true;
    closes = true;
    pushclose = false;
    active = true;
    xPos = xLocation;
    yPos = yLocation;
    width = winWidth;
    height = winHeight;
    grabX = -1;
    grabY = -1;
    label = (char *)calloc(strlen(title)+1, sizeof(char));
    strcpy(label, title);
    label[strlen(title)+1] = '\0';
    buttons = 0;
    labels = 0;
    Labels = (Label **)malloc(sizeof(Label *));
    Buttons = (Button **)malloc(sizeof(Button *));
}
bool Window::AddLabel(short xLocation, short yLocation, char *text) {
    Labels = (Label **)realloc(Labels, sizeof(Label *) * (labels + 1));
    Labels[labels] = new Label(xLocation, yLocation + 12, text);
    if(Labels[labels] == NULL) {
        return false;
    }
    labels ++;
    return true;
}
bool Window::AddLabel(short xLocation, short yLocation, BITMAP *mainImage) {
    Labels = (Label **)realloc(Labels, sizeof(Label *) * (labels + 1));
    Labels[labels] = new Label(xLocation, yLocation + 12, mainImage);
    if(Labels[labels] == NULL) {
        return false;
    }
    labels ++;
    return true;
}
bool Window::AddButton(short xLocation, short yLocation, short winWidth, short winHeight, char *text, void (*funct)(void)) {
    Buttons = (Button **)realloc(Buttons, sizeof(Button *) * (buttons + 1));
    Buttons[buttons] = new Button(xLocation, yLocation + 12, winWidth, winHeight, text, funct);
    if(Buttons[buttons] == NULL) {
        return false;
    }
    buttons ++;
    return true;
}

bool Window::AddButton(short xLocation, short yLocation, short winWidth, short winHeight, BITMAP *mainImage, void (*funct)(void)) {
    Buttons = (Button **)realloc(Buttons, sizeof(Button *) * (buttons + 1));
    Buttons[buttons] = new Button(xLocation, yLocation + 12, winWidth, winHeight, mainImage, funct);
    if(Buttons[buttons] == NULL) {
        return false;
    }
    buttons ++;
    return true;
}

bool Window::AddButton(short xLocation, short yLocation, short winWidth, short winHeight, BITMAP *mainImage, BITMAP *switchimage, void (*funct)(void)) {
    Buttons = (Button **)realloc(Buttons, sizeof(Button *) * (buttons + 1));
    Buttons[buttons] = new Button(xLocation, yLocation + 12, winWidth, winHeight, mainImage, switchimage, funct);
    if(Buttons[buttons] == NULL) {
        return false;
    }
    buttons ++;
    return true;
}
void Window::Mobile(void) {
    mobile = true;
}
void Window::Immobile(void) {
    mobile = false;
}
void Window::Shades(void) {
    hides = true;
}
void Window::NoShade(void) {
    hides = false;
}
void Window::Open(void) {
    active = true;
}
void Window::Close(void) {
    active = false;
}
int Window::Check(void) {
    short retint;
    retint = -1;
    if(active) {
        retint = 0;
        if(mouse_inarea(xPos, yPos, width, height) && !grab) {
            if(mouse_inarea(xPos, yPos + 14, width, height)) {
                if(visible) {
                    if(mouse_b & 1) {
                        retint = 1;
                    }
                    short i;
                    for(i = 0; i < buttons; i ++) {
                        Buttons[i]->Check(xPos, yPos);
                    }
                }
            } else {
                if(mouse_b & 1) {
                    retint = 1;
                }
                if(mouse_inarea(xPos + width - 15, yPos + 2, 13, 12) && closes) {
                    if(mouse_b & 1 && !pushclose) {
                        pushclose = true;
                    }
                    if(!mouse_b & 1 && pushclose) {
                        pushclose = false;
                        active = false;
                        retint = -1;
                    }
                } 
                if(mouse_inarea(xPos + width - 30, yPos + 2, 13, 12) && hides) {
                    if(mouse_b & 1 && !pushhide) {
                        pushhide = true;
                    }
                    if(!mouse_b & 1 && pushhide) {
                        pushhide = false;
                        if(visible) {
                            visible = false;
                        } else {
                            visible = true;
                            if(yPos + height > WIN_HEIGHT) yPos = WIN_HEIGHT - height - 1;
                        }
                    }
                } else if(mouse_b & 1 && mobile) {
                    if(!grab && !pushclose && !pushhide) {
                        grabX = mouse_x - xPos;
                        grabY = mouse_y - yPos;
                        grab = true;
                    }
                } else {
                    if(pushclose) {
                        pushclose = false;
                    }
                    if(pushhide) {
                        pushhide = false;
                    }
                }
            }
        }
        if(grab && mobile) {
            retint = 1;
            if(mouse_b & 1) {
                xPos = mouse_x - grabX;
                yPos = mouse_y - grabY;
                if(yPos < 17) yPos = 17;
                if(xPos < 0) xPos = 0;
                if(xPos + width > WIN_WIDTH) xPos = WIN_WIDTH - width - 1;
                if(visible) {
                    if(yPos + height > WIN_HEIGHT) yPos = WIN_HEIGHT - height - 1;
                } else {
                    if(yPos + 29 > WIN_HEIGHT) yPos = WIN_HEIGHT - 19;
                }
            } else {
                grabX = -1;
                grabY = -1;
                grab = false;
            }
        }
    }
    return(retint);
}
void Window::Draw(BITMAP *output) {
    if(debug) printf("Drawing Sequence:\n");
    if(active) {
        if(debug) printf("<Window Active>\n");
        if(visible) {
            if(debug) printf("<Window Visible>\n");
            if(debug) printf("Drawing outline...\n");
            gui_window(output, xPos, yPos, width, height, makecol(80, 80, 80));
            if(closes) {
                if(debug) printf("Drawing Close Button...\n");
                if(pushclose && mouse_inarea(xPos + width - 15, yPos + 2, 13, 12)) {
                    draw_sprite(output, WinClosePush, xPos + width - 15, yPos + 2);
                } else {
                    draw_sprite(output, WinClose, xPos + width - 15, yPos + 2);
                }
            }
            if(hides) {
                if(debug) printf("Drwaing Winshade Button...\n");
                if(pushhide && mouse_inarea(xPos + width - 30, yPos + 2, 13, 12)) {
                    draw_sprite(output, WinShadePush, xPos + width - 30, yPos + 2);
                } else {
                    draw_sprite(output, WinShade, xPos + width - 30, yPos + 2);
                }
            }
            if(debug) printf("Drawing Title...\n");
            textprintf(output, font, xPos + 5, yPos + 4, BLACK, label);
            textprintf(output, font, xPos + 4, yPos + 3, WHITE, label);
            short i;
            if(debug) printf("Drawing Labels...\n");
            for(i = 0; i < labels; i ++) {
                if(Labels[i]) {
                    Labels[i]->Draw(output, xPos, yPos);
                }
            }
            if(debug) printf("Drawing Buttons...\n");
            for(i = 0; i < buttons; i ++) {
                if(Buttons[i]) {
                    Buttons[i]->Draw(output, xPos, yPos);
                }
            }
        } else {
            winshade_window(output, xPos, yPos, width, 18);
            if(closes) {
                if(pushclose && mouse_inarea(xPos + width - 15, yPos + 2, 13, 12)) {
                    draw_sprite(output, WinClosePush, xPos + width - 15, yPos + 2);
                } else {
                    draw_sprite(output, WinClose, xPos + width - 15, yPos + 2);
                }
            }
            if(hides) {
                if(pushhide && mouse_inarea(xPos + width - 30, yPos + 2, 13, 12)) {
                    draw_sprite(output, WinShadePush, xPos + width - 30, yPos + 2);
                } else {
                    draw_sprite(output, WinShade, xPos + width - 30, yPos + 2);
                }
            }
            textprintf(output, font, xPos + 5, yPos + 4, BLACK, label);
            textprintf(output, font, xPos + 4, yPos + 3, WHITE, label);
        }
    }
}
