; Script generated by the Inno Setup Script Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!

[Setup]
AppName=Super Metroid Classic Patch
AppVerName=Super Metroid Classic Beta 0.8a Patch
AppPublisher=Justice Productions, Inc
AppPublisherURL=http://www.supermetroidclassic.com
AppSupportURL=http://www.supermetroidclassic.com
AppUpdatesURL=http://www.supermetroidclassic.com
DefaultDirName={code:InstPath}
DisableProgramGroupPage=yes
OutputDir=C:\Setup
OutputBaseFilename=smtcpatchbeta08a
SetupIconFile=C:\Dev-Cpp\Projects\SMTCLevelEdit\SMTC.ico
Compression=lzma
SolidCompression=yes
Uninstallable=no
DisableDirPage=yes
DisableReadyPage=yes

[Files]
Source: "C:\Setup\SMTC\SMTC.exe"; DestDir: "{app}"; Check: PathCheck; Flags: ignoreversion
; NOTE: Don't use "Flags: ignoreversion" on any shared system files

[Code]
function InstPath(Param: String): String;
var
  InstPathVal: String;
begin
    if not RegQueryStringValue(HKLM, 'Software\Justice Productions\SMTC', 'InstallPath', InstPathVal) then
    begin
      InstPathVal:= ExpandConstant('{pf}') + '\SMTC';
    end;
    Result := InstPathVal;
end;

function PathCheck(): Boolean;
var
  InstPathVal: String;
  RetVal: Boolean;
begin
  if RegQueryStringValue(HKLM, 'Software\Justice Productions\SMTC', 'InstallPath', InstPathVal) then
  begin
    RetVal := True;
  end else
    MsgBox('The install key could not be found in the registry.' + #13#10#13#10 + 'The patch will not be installed.', mbInformation, MB_OK);
    RetVal := False;
  Result := RetVal;
end;
