#include "larva.h"

larva::larva()
{
	frame=0;
}

larva::~larva()
{
}

int larva::get_frame()
{
	return frame;
}

void larva::change_state()
{
	frame=(frame+1)%LARVA_FRAMES;
}

void larva::move(board &b)
{
	int tempx, tempy, tempv;

	if( !(rand()%LARVA_CHANGE_RATE) ) this->change_state();
	if( !(rand()%LARVA_MOVE_RATE) )
	{
		tempv=rand()%4;
		switch(tempv)
		{
		case 0: tempx=this->x+1; tempy=this->y; break;
		case 1: tempx=this->x-1; tempy=this->y; break;
		case 2: tempy=this->y+1; tempx=this->x; break;
		case 3: tempy=this->y-1; tempx=this->x; break;
		}
		if( b.is_free_1x1(tempx,tempy) ) 
		{
			b.move_object(this->x,this->y,tempx,tempy,LARVA);
			this->x=tempx;
			this->y=tempy;
		}
	}
}

int larva::get_x()
{
	return x;
}

int larva::get_y()
{
	return y;
}

void larva::set_loc(int nx, int ny)
{
	this->x=nx;
	this->y=ny;
}

void larva::display_grid()
{
	/*SDL_Rect src, dest;
	src.x=SMALL_SIZE*(5+frame);
	src.y=0;
	dest.x=this->x*SMALL_SIZE;
	dest.y=this->y*SMALL_SIZE;
	dest.w=src.w=SMALL_SIZE;
	dest.h=src.h=SMALL_SIZE;
	SDL_BlitSurface(allS,&src,double_buffer,&dest);*/
    blit(allS,double_buffer,SMALL_SIZE*(5+frame),0,this->x*SMALL_SIZE,this->y*SMALL_SIZE,SMALL_SIZE,SMALL_SIZE);
}
