#include <vector>
#include "game.h"

game::game()
{
    the_score=0;
    mans=3;
    the_level=1;
}

game::~game()
{
	this->clear();
}

void game::clear()
{
	unsigned int i;

	for(i=(unsigned int)l.size(); i>0; i--)
	{
		if( l[i-1] ) delete l[i-1];
	}
	l.resize(0);

	for(i=(unsigned int)a.size(); i>0; i--)
	{
		if( a[i-1] ) delete a[i-1];
	}
	a.resize(0);

	for(i=(unsigned int)bx.size(); i>0; i--)
	{
		if( bx[i-1] ) delete bx[i-1];
	}
	bx.resize(0);

}

void game::setup()
{
	box *tempbx;
	for(int i=0; i<the_level; i++)
	{
        int tx, ty;
        do
        {
            tx=rand()%(BOARD_X_SIZE-7)+3;
            ty=rand()%(BOARD_Y_SIZE-7)+3;
        }
        while( b.is_free_2x2(tx,ty) == false );
  		tempbx = new box();      
  		tempbx->set_loc(tx,ty);
        bx.push_back(tempbx);
        b.set_object(tx,ty,BOX);
	}

	larva *templ;
	for(int i=0; i<30+the_level*10; i++)
	{
        int tx, ty;
        do
        {
            tx=rand()%(BOARD_X_SIZE-5)+3;
            ty=rand()%(BOARD_Y_SIZE-5)+3;
        }
  		while( b.is_free_1x1(tx,ty) == false );
        templ = new larva();
        templ->set_loc(tx,ty);
        l.push_back(templ);
        b.set_object(tx,ty,LARVA);
	}

	/*alien *tempa;
	for(int i=0; i<1; i++)
	{
		tempa = new alien();
		tempa->set_loc(rand()%(BOARD_X_SIZE-6)+2,rand()%(BOARD_Y_SIZE-6)+2);
		a.push_back(tempa);
	} */

	si.set_loc(2,2,DOWN);
    so.set_pos(0,0,DOWN);
}

void game::display()
{
	unsigned int i;
    char temp_string[80];

    so.display_grid();
	b.display(0,0);

	for(i=0; i<(unsigned int)l.size(); i++)
	{
		l[i]->display_grid();
	}
	for(i=0; i<(unsigned int)a.size(); i++)
	{
		a[i]->display_grid();
	}

	for(i=0; i<(unsigned int)bx.size(); i++)
	{
		bx[i]->display_grid();
	}

	si.display_grid();
    sprintf(temp_string,"Score: %d",this->the_score);//500,20
    textout(double_buffer,font,temp_string,500,20,5);//3,4,5,9
    sprintf(temp_string,"High Score: %d",high_score);
    textout(double_buffer,font,temp_string,500,30,5);
    sprintf(temp_string,"Mans: %d",this->mans);
    textout(double_buffer,font,temp_string,500,50,5);
    sprintf(temp_string,"Level: %d",this->the_level);
    textout(double_buffer,font,temp_string,500,70,5);
    sprintf(temp_string,"High Level: %d",high_level);
    textout(double_buffer,font,temp_string,500,80,5);
}

bool game::step()
{
	unsigned int i, j;

    if( a.size() == 0 && l.size() == 0 )
    {
        the_level++;
        clear();
        setup();
    }

    for(j=0; j<BOARD_Y_SIZE-1; j++)
    {
        for(i=0; i<BOARD_X_SIZE-1; i++)
        {
             if( b.is_cluster(i,j) == true )
             {
                  remove_larva(i,j);
                  remove_larva(i,j+1);
                  remove_larva(i+1,j);
                  remove_larva(i+1,j+1);
                  alien *newa = new alien();
                  newa->set_loc(i,j);
                  a.push_back(newa);
             }
        }
    }

    std::vector<box *>::iterator bxiter;
    for(bxiter=bx.begin(); bxiter!=bx.end(); bxiter++)
    {
        if( !(rand()%HATCH_RATE) )
        {
             (*bxiter)->decrement_state();
             if( (*bxiter)->get_frame() < 0 )
                 {
                 larva *t;
                 bx.erase(bxiter);
                 int tx, ty;
                 tx=(*bxiter)->get_x();
                 ty=(*bxiter)->get_y();
                 t = new larva();
                 t->set_loc(tx,ty);
                 l.push_back(t);
                 t = new larva();
                 t->set_loc(tx,ty+1);
                 l.push_back(t);
                 t = new larva();
                 t->set_loc(tx+1,ty+1);
                 l.push_back(t);
                 }
             break;
        }
    }

	b.clear();
	for(i=0; i<(unsigned int)l.size(); i++)
	{
		b.set_object(l[i]->get_x(),l[i]->get_y(),LARVA);
	}
	for(i=0; i<(unsigned int)a.size(); i++)
	{
		b.set_object(a[i]->get_x(),a[i]->get_y(),ALIEN);
	}
	for(i=0; i<(unsigned int)bx.size(); i++)
	{
		b.set_object(bx[i]->get_x(),bx[i]->get_y(),BOX);
	}
    b.set_object(si.get_x(),si.get_y(),SHIP);

	for(i=0; i<(unsigned int)l.size(); i++)
	{
		l[i]->move(b);
	}
	for(i=0; i<(unsigned int)a.size(); i++)
	{
		a[i]->move(b,si);
	}

    si.move(b,so);
	so.move(b);

    // check for a shot hit
    std::vector<larva *>::iterator liter;
    for(liter=l.begin(); liter!=l.end(); liter++)
    {
        if( so.get_x() == (*liter)->get_x() && so.get_y() == (*liter)->get_y() )
        {
             so.set_pos(0,0,DOWN);
             l.erase(liter);
             the_score+=1;
             break;
        }
    }
    std::vector<alien *>::iterator aiter;
    for(aiter=a.begin(); aiter!=a.end(); aiter++)
    {
        if( (so.get_x() == (*aiter)->get_x() && so.get_y() == (*aiter)->get_y()) ||
            (so.get_x() == (*aiter)->get_x()+1 && so.get_y() == (*aiter)->get_y()) ||
            (so.get_x() == (*aiter)->get_x() && so.get_y() == (*aiter)->get_y()+1) ||
            (so.get_x() == (*aiter)->get_x()+1 && so.get_y() == (*aiter)->get_y()+1) )
        {
             if( (*aiter)->got_hit() == true )
             {
                 so.set_pos(0,0,DOWN);
                 a.erase(aiter);
                 the_score+=4;
                 break;
             }
             else
             {
                 so.set_pos(0,0,DOWN);
                 break;
             }
        }
    }
    //vector<box *>::iterator bxiter;
    for(bxiter=bx.begin(); bxiter!=bx.end(); bxiter++)
    {
        if( (so.get_x() == (*bxiter)->get_x() && so.get_y() == (*bxiter)->get_y()) ||
            (so.get_x() == (*bxiter)->get_x()+1 && so.get_y() == (*bxiter)->get_y()) ||
            (so.get_x() == (*bxiter)->get_x() && so.get_y() == (*bxiter)->get_y()+1) ||
            (so.get_x() == (*bxiter)->get_x()+1 && so.get_y() == (*bxiter)->get_y()+1) )
        {
            so.set_pos(0,0,DOWN);
            break;
        }
    }
    if( so.get_x() <= 1 || so.get_x() >= BOARD_X_SIZE-2 || so.get_y() <= 1 || so.get_y() >= BOARD_Y_SIZE-2 )
    {
         so.set_pos(0,0,DOWN);
    }

    // check for the ship as an alien meal
    for(aiter=a.begin(); aiter!=a.end(); aiter++)
    {
        if( (si.get_x() == (*aiter)->get_x() && si.get_y() == (*aiter)->get_y()) ||
            (si.get_x() == (*aiter)->get_x()+1 && si.get_y() == (*aiter)->get_y()) ||
            (si.get_x() == (*aiter)->get_x() && si.get_y() == (*aiter)->get_y()+1) ||
            (si.get_x() == (*aiter)->get_x()+1 && si.get_y() == (*aiter)->get_y()+1) )
        {                
            mans--;
            reset_ship();
        }
    }

    if( the_score > high_score ) high_score=the_score;
    if( the_level > high_level ) high_level=the_level;
    if( mans >= 0 ) return true;
    else return false;
}

void game::remove_larva(int x, int y)
{
    std::vector<larva *>::iterator liter;
    for(liter=l.begin(); liter!=l.end(); liter++)
    {
        if( x == (*liter)->get_x() && y == (*liter)->get_y() )
        {
             l.erase(liter);
             break;
        }
    }
}

void game::reset_ship()
{
    int tx, ty, trc;
    char temp_string[80];

    tx=si.get_x();
    ty=si.get_y();
    sprintf(temp_string,"Alien Eat You!");
    textout(screen,font,temp_string,tx*SMALL_SIZE+SMALL_SIZE/2-4-7*8,ty*SMALL_SIZE+SMALL_SIZE/2-4,1);
    mike_wait(150);

    if( mans >= 0 )
    {
        do
        {
              tx=rand()%(BOARD_X_SIZE-5)+3;
              ty=rand()%(BOARD_Y_SIZE-5)+3;
        }
        while( !(b.is_free_1x1(tx,ty)) );
        si.set_loc(tx,ty,0);

        circle(screen,tx*SMALL_SIZE+SMALL_SIZE/2,ty*SMALL_SIZE+SMALL_SIZE/2,20,24);
        mike_wait(10);
        circle(screen,tx*SMALL_SIZE+SMALL_SIZE/2,ty*SMALL_SIZE+SMALL_SIZE/2,17,24);
        mike_wait(10);
        circle(screen,tx*SMALL_SIZE+SMALL_SIZE/2,ty*SMALL_SIZE+SMALL_SIZE/2,14,24);
        mike_wait(10);
        circle(screen,tx*SMALL_SIZE+SMALL_SIZE/2,ty*SMALL_SIZE+SMALL_SIZE/2,11,24);
        mike_wait(10);
        circle(screen,tx*SMALL_SIZE+SMALL_SIZE/2,ty*SMALL_SIZE+SMALL_SIZE/2,8,24);
        mike_wait(10);
        circle(screen,tx*SMALL_SIZE+SMALL_SIZE/2,ty*SMALL_SIZE+SMALL_SIZE/2,5,24);
        mike_wait(100);
    }
    else
    {
        sprintf(temp_string,"Game Done!");
        textout(screen,font,temp_string,tx*SMALL_SIZE+SMALL_SIZE/2-4-7*8,ty*SMALL_SIZE+SMALL_SIZE/2-4+10,1);
        mike_wait(150);
    }
}
