#include "board.h"

board::board()
{
	this->clear();
}

board::~board()
{
}

void board::clear()
{
	for(int i=0; i<BOARD_X_SIZE; i++)
	{
		for(int j=0; j<BOARD_Y_SIZE; j++)
		{
			if( i == 0 || i == 1 || i == BOARD_X_SIZE-1 || i == BOARD_X_SIZE-2 || j == 0 || j == 1 || j == BOARD_Y_SIZE-1 || j == BOARD_Y_SIZE-2 )
				grid[i][j]=WALL;
			else grid[i][j]=FREE;
		}
	}
}

bool board::is_free_1x1(int x, int y)
{
	if( grid[x][y] == FREE ) return true;
	else return false;
}

bool board::is_free_2x2(int x, int y)
{
	if( grid[x][y+1] == FREE && grid[x+1][y+1] == FREE && grid[x+1][y] == FREE && grid[x][y] == FREE ) return true;
	else return false;
}

bool board::is_free_2x2_alien(int x, int y, int dir)
{
	if( dir == DOWN )
	{
		if( grid[x][y+1] <= SHIP && grid[x+1][y+1] <= SHIP ) return true;
		else return false;
	}
	if( dir == UP )
	{
		if( grid[x][y] <= SHIP && grid[x+1][y] <= SHIP ) return true;
		else return false;
	}
	if( dir == LEFT )
	{
		if( grid[x][y] <= SHIP && grid[x][y+1] <= SHIP ) return true;
		else return false;
	}
	if( dir == RIGHT )
	{
		if( grid[x+1][y] <= SHIP && grid[x+1][y+1] <= SHIP ) return true;
		else return false;
	}
	return false;
}

bool board::is_cluster(int x, int y)
{
    if( grid[x][y] == LARVA && grid[x][y+1] == LARVA && grid[x+1][y] == LARVA && grid[x+1][y+1] ) return true;
	else return false;
}

void board::display(int x, int y)
{
	//SDL_Rect dest, src;
	int v;
	for(int i=0; i<BOARD_X_SIZE; i++)
	{
		for(int j=0; j<BOARD_Y_SIZE; j++)
		{
			v=this->grid[i][j];
			if( v ) 
			{
			/*src.x=0;
			src.y=0;
			src.w=UNIT_BLOCK_WIDTH;
			src.h=UNIT_BLOCK_HEIGHT;
			dest.x=x+i*UNIT_BLOCK_WIDTH;
			dest.y=y+j*UNIT_BLOCK_HEIGHT;
			dest.w=UNIT_BLOCK_WIDTH;
			dest.h=UNIT_BLOCK_HEIGHT;  */
			if( v == WALL )// SDL_BlitSurface(allS,&src,double_buffer,&dest);
                        blit(allS,double_buffer,0,0,x+i*UNIT_BLOCK_WIDTH,y+j*UNIT_BLOCK_HEIGHT,UNIT_BLOCK_WIDTH,UNIT_BLOCK_HEIGHT);
			}
		}
	}
}

void board::set_object(int x, int y, int type)
{
	switch(type)
	{
	case SHIP: grid[x][y]=SHIP; break;
	case LARVA: grid[x][y]=LARVA; break;
	case ALIEN: grid[x][y]=ALIEN; grid[x][y+1]=ALIEN; grid[x+1][y]=ALIEN; grid[x+1][y+1]=ALIEN; break;
    case BOX: grid[x][y]=BOX; grid[x][y+1]=BOX; grid[x+1][y]=BOX; grid[x+1][y+1]=BOX; break;
	}
}

void board::move_object(int ox, int oy, int nx, int ny, int type)
{
	if( type == LARVA || type == SHIP )
	{
		grid[ox][oy]=FREE;
		grid[nx][ny]=type;
	}
	if( type == ALIEN )
	{
		grid[ox][oy]=FREE;
		grid[ox+1][oy]=FREE;
		grid[ox+1][oy+1]=FREE;
		grid[ox][oy+1]=FREE;

		grid[nx][ny]=type;
		grid[nx+1][ny]=type;
		grid[nx+1][ny+1]=type;
		grid[nx][ny+1]=type;
	}
}
