#include "alien.h"

alien::alien()
{
    hits=0;
}

alien::~alien()
{
}

int alien::get_frame()
{
	return frame;
}

void alien::change_state()
{
	frame=(frame+1)%ALIEN_FRAMES;
}

void alien::move(board b, ship &si)
{
	int tempx, tempy, tempv, tempdir;

	if( !(rand()%ALIEN_CHANGE_RATE) ) this->change_state();
	if( !(rand()%ALIEN_MOVE_RATE) )
	{
        if( si.get_x() == this->x )
        {
            if( si.get_y() > this->y ) tempv=2;
            if( si.get_y() < this->y ) tempv=3;
            else tempv=rand()%4;
        }
        else if( si.get_y() == this->y )
        {
            if( si.get_x() > this->x ) tempv=0;
            if( si.get_x() < this->x ) tempv=1;
            else tempv=rand()%4;
        }
		else if( rand()%2 )
        {
            if( si.get_x() > this->x ) tempv=0;
            else tempv=1;
        }
        else
        {
            if( si.get_y() > this->y ) tempv=2;
            else tempv=3;
        }
		switch(tempv)
		{
		case 0: tempx=this->x+1; tempy=this->y; tempdir=RIGHT; break;
		case 1: tempx=this->x-1; tempy=this->y; tempdir=LEFT; break;
		case 2: tempy=this->y+1; tempx=this->x; tempdir=DOWN; break;
		case 3: tempy=this->y-1; tempx=this->x; tempdir=UP; break;
		}
		if( b.is_free_2x2_alien(tempx,tempy,tempdir) )
		{
			b.move_object(this->x,this->y,tempx,tempy,ALIEN);
			this->x=tempx;
			this->y=tempy;
		}
	}
}

int alien::get_x()
{
	return x;
}

int alien::get_y()
{
	return y;
}

bool alien::got_hit()
{
	hits++;
	if( hits >= ALIEN_HITS ) return true;
	else return false;
}

void alien::set_loc(int nx, int ny)
{
	this->x=nx;
	this->y=ny;
}

void alien::display_grid()
{
	/*SDL_Rect src, dest;
	src.x=LARGE_SIZE*frame;
	src.y=SMALL_SIZE;
	dest.x=this->x*SMALL_SIZE;
	dest.y=this->y*SMALL_SIZE;
	dest.w=src.w=LARGE_SIZE;
	dest.h=src.h=LARGE_SIZE;
	SDL_BlitSurface(allS,&src,double_buffer,&dest);*/
    blit(allS,double_buffer,LARGE_SIZE*frame,SMALL_SIZE,this->x*SMALL_SIZE,this->y*SMALL_SIZE,LARGE_SIZE,LARGE_SIZE);
}
