/**\file snowattack.c
*
*  snowattack function file for Christmas Hack 2007
*
*\author Castagnier Mickal aka Gull Ra Driel
*
*\version 1.0
*
*\date 15/12/2007
*
*/


#include "main.h"


int proceed_snowattak( GAME_ENV **game , int *DONE )
{
	BITMAP *workshop = NULL ,
		   *santa[2] ={ NULL , NULL } ,
		   *snow = NULL ,
		   *snowmini = NULL ,
		   *canon = NULL ,
		   *ice = NULL ;

    int collision_point[2] , collide = 0 ;

    PARTICLE *p_iter_1 = NULL ;
    PARTICLE *p_iter_2 = NULL ;


    int x1 = 0 , y1 = 0 , x2 = 0 , y2 = 0 ,
        it = 0 , it1 = 0 , direction = 0 ,
        clicked = 0 ;


    double angle = 0 , itx = 0 , ity = 0 , ax = 0 , ay = 0 ,droptime = 0 , level_start = 5000000 , ice_fall_time = 0 ;

    PMASK *snowmask = NULL ,
          *canonmask = NULL ,
		  *santamask[2] = { NULL , NULL } ,
		  *icemask = NULL ;

    PARTICLE_SYSTEM *little_snow = NULL , *mad_balls = NULL , *bullets = NULL , *FX = NULL , *ice_fall = NULL ;

    SAMPLE *shoot = load_sample("DATA/SOUNDS/shoot.wav");

    if (!shoot)
    {
        allegro_message("Couldn't load sample shoot.wav!");
        exit( 1 );
    }

    SAMPLE *busted = load_sample("DATA/SOUNDS/busted.wav");
    if (!busted)
    {
        allegro_message("Couldn't load sample shoot.wav!");
        exit( 1 );
    }

	workshop = load_bitmap( "DATA/GFX/workshop.bmp" , NULL );
	santa[0] = load_bitmap( "DATA/GFX/SantaFight.bmp" , NULL );
	santa[1] = create_bitmap( santa[ 0 ] -> w , santa[ 0 ] -> h );
    clear_to_color( santa[ 1 ] , makecol( 255  , 0 , 255 ) );
    draw_sprite_h_flip( santa[ 1 ] , santa[ 0 ] , 0 , 0 );


	snow = load_bitmap( "DATA/GFX/madsnowballs.bmp" , NULL );
    snowmini = load_bitmap( "DATA/GFX/snow.bmp" , NULL );
	ice = load_bitmap( "DATA/GFX/ice.bmp" , NULL );
    canon = load_bitmap( "DATA/GFX/canonballmini.bmp" , NULL );

	init_particle_system( &little_snow , 3000  ,  (*game) -> scrbuf -> w / 2 , -50 , 0 );
	init_particle_system( &mad_balls , 3000  ,  (*game) -> scrbuf -> w / 2 , -100 , 0 );
	init_particle_system( &bullets , 3000  ,  (*game) -> position + (*game) -> scrbuf -> w / 2 - santa[ 0 ] -> w / 2 + 10 , (*game) -> scrbuf -> h - santa[ 0 ] -> h - workshop -> h , 0 );
    init_particle_system( &FX , 2000  , 0 , 0 , 0 );
	init_particle_system( &ice_fall , 100  , 0 , -100 , 0 );

    snowmask = create_allegro_pmask( snow );
    canonmask = create_allegro_pmask( canon );
    santamask[0] = create_allegro_pmask( santa[ 0 ] );
    santamask[1] = create_allegro_pmask( santa[ 1 ] );

    icemask = create_allegro_pmask( ice );


	/* GAME LOOP */
   start_HiTimer( &(*game) ->game_timer );

	ice_fall_time = 1500000 * ( 11 - (*game) -> level ) ;

   do
    {
        (*game) -> loop_time   = get_usec( &(*game) -> game_timer );
        (*game) -> draw_time  -= (*game) -> loop_time;
        (*game) -> logic_time -= (*game) -> loop_time;

		ice_fall_time -= (*game) -> loop_time ;

        if( level_start > 0 )
            level_start -= (*game) -> loop_time;

        droptime -= (*game) -> loop_time;

        if( (*game) -> logic_time <= 0 )
        {
            (*game) -> logic_time += (*game) -> LOGIC_RATE ;

            if( (*game) -> logic_time <= 0 ) /* avoiding bad timing */
                (*game) -> logic_time = (*game) -> LOGIC_RATE ;

		    if( (*game) -> wait_for_slowing_down_cpu == 0 )
                (*game) -> wait_for_slowing_down_cpu = 1;

			if( ice_fall_time < 0 )
			{
				ice_fall_time = 1500000 * ( 11 - (*game) -> level ) ;

				add_particle( ice_fall , ice , NORMAL_PART , (*game) -> scrbuf -> w / 2 + (*game) -> position , 0 , 20000 , 0 ,
					  0 , 70+10*rand()%((*game)-> level*8) , 0 ,
			     0 , 0 , 0 );
			}

			if( droptime < 0 )
			{
			     add_particle( mad_balls , snow , NORMAL_PART , (350-rand()%800) , 0 , 20000 , 0 ,
					  10-rand()%20 , 70+rand()%((*game)-> level*4) , 0 ,
			     0 , 0 , 0 );
                 if( (*game)->level < 10 )
                    droptime += 85000 * (11 - (*game) -> level );
                 else
                    droptime = 30000 ;
			}
			add_particle( little_snow , NULL , SINUS_PART , (512-rand()%1024) , 0 , 20000 , makecol( 240 + rand()%15 , 240 + rand()%15 , 240 + rand()%15 ) ,
					  rand()%40 , 20+rand()%40 , 0 ,
					  2-(4.0*rand()/(RAND_MAX+1.0)) , 2-(4.0*rand()/(RAND_MAX+1.0))  , 2-(4.0*rand()/(RAND_MAX+1.0)) );

			manage_particle( little_snow );
			manage_particle( bullets );
			manage_particle( mad_balls );
            manage_particle( FX );
			manage_particle( ice_fall );

			p_iter_1 = bullets->list_start ;

            while( p_iter_1 != NULL )
            {
                p_iter_2 = mad_balls->list_start;
                collide = 0 ;

                x1 = p_iter_1 -> x ;
                y1 = p_iter_1 -> y ;

                if( p_iter_1 -> mode == SINUS_PART )
                {
                    if( p_iter_1 -> vx != 0 )
						x1 = x1 + p_iter_1 -> vx * sin( (p_iter_1 -> x/p_iter_1 -> vx) );
					else
						x1 = x1 + p_iter_1 -> vx * sin( p_iter_1 -> x);

					if( p_iter_1 -> vy != 0 )
					    y1 = y1 + p_iter_1 -> vy * cos( (p_iter_1 -> y/p_iter_1 -> vy) );
					else
					    y1 = y1 + p_iter_1 -> vy * cos( p_iter_1 -> y );
                }

                while( p_iter_2 != NULL && p_iter_1 != NULL )
                {
                    x2 = p_iter_2 -> x ;
                    y2 = p_iter_2 -> y ;

                    if( p_iter_2 -> mode == SINUS_PART )
                    {
                        if( p_iter_2 -> vx != 0 )
							x2 = x2 + p_iter_2 -> vx * sin( (p_iter_2 -> x/p_iter_2 -> vx) );
						else
							x2 = x2 + p_iter_2 -> vx * sin( p_iter_2 -> x);

						if( p_iter_2 -> vy != 0 )
							y2 = y2 + p_iter_2 -> vy * cos( (p_iter_2 -> y/p_iter_2 -> vy) );
						else
							y2 = y2 + p_iter_2 -> vy * cos( p_iter_2 -> y );
                    }

                    if( check_pmask_collision_position( canonmask , snowmask , x1 + (canon -> w/2) , y1 + (canon -> h/2) , x2 , y2 , collision_point ) )
                    {
                             play_sample(busted, 255, 128, 1000, 0);

                             (*game) -> busted ++ ;

                            if( (*game) -> shooted > 0 )
                                (*game) -> score += ( ((*game) -> level+1) * 2 ) * ( (*game) -> busted * 100 / (*game) -> shooted );

                            if( (*game) -> level == 10 )
                            {
                                if( (*game) -> busted > 700 )
                                {
                                    (*game) -> level ++ ;
                                    return 0;
                                }
                            }
                            else
                            {
                                if( (*game) -> busted > ((*game) -> level + 1 ) * 15 )
                                {
                                    (*game) -> level ++ ;(*game) -> busted =(*game) ->shooted = 0 ;
                                    return 0;
                                }
                            }

                            for( it = 0 ; it < 50 ; it ++ )
                            {
                                it1 = sqrt( (( x1 - x2 )*( x1 - x2 )) + (( y1 - y2 )*( y1 - y2 )) );
                                if( it1 == 0 )
                                    it1 = 1 ;

                                itx = - ( 50 * ( x1 - x2 ) )/it1;
                                ity = - ( 50 * ( y1 - y2 ) )/it1;

                                itx = itx + 10 - rand() %20 ;
                                ity = ity + 10 - rand() %20 ;


                                ax = (itx * rand() / ( RAND_MAX + 1.0 ))/2 ;
								ay = (ity * rand() / ( RAND_MAX + 1.0 ))/2 ;

								add_particle( FX , snowmini  , NORMAL_PART , collision_point[ 0 ] - snow -> w / 2  , collision_point[ 1 ] - snow -> h / 2 , 1000 + rand()%1000 ,
                                0 ,
                                itx , ity , 0 ,
                                ax , ay , 0 );
                            }

                            free_particle( mad_balls , &p_iter_2 );
                            free_particle( bullets , &p_iter_1 );

                            collide = 1 ;
                    }
                    else
                    {
                        if( p_iter_2 != NULL )
                            p_iter_2 = p_iter_2 -> next ;
                    }

                }
                if( collide == 0 && p_iter_1 != NULL )
                    p_iter_1 = p_iter_1 -> next ;
            }

            p_iter_1 = bullets -> list_start ;
            while( p_iter_1 )
            {
                if( p_iter_1 -> y < 0 ||  p_iter_1 -> y > SCREEN_H || p_iter_1 -> x < 0 || p_iter_1 -> x > SCREEN_W )
                {
                    free_particle( bullets , &p_iter_1 );
                }else
                p_iter_1 = p_iter_1 -> next ;
            }

            p_iter_2 = mad_balls->list_start ;

            x1 = (*game) -> position + (*game) -> scrbuf -> w / 2 ;
			y1 = (*game) -> scrbuf -> h - santa[ direction ] -> h - workshop -> h ;

			while( p_iter_2 )
            {
                x2 = p_iter_2 -> x ;
                y2 = p_iter_2 -> y ;

                if( p_iter_2 -> mode == SINUS_PART )
                {
                     if( p_iter_2 -> vx != 0 )
						x2 = x2 + p_iter_2 -> vx * sin( (p_iter_2 -> x/p_iter_2 -> vx) );
					else
						x2 = x2 + p_iter_2 -> vx * sin( p_iter_2 -> x);

					if( p_iter_2 -> vy != 0 )
						y2 = y2 + p_iter_2 -> vy * cos( (p_iter_2 -> y/p_iter_2 -> vy) );
					else
						y2 = y2 + p_iter_2 -> vy * cos( p_iter_2 -> y );
                }

			    if( (y2 + snow->h/2) > (SCREEN_H - workshop -> h)  ||
				     check_pmask_collision_position( santamask[ direction ] , snowmask ,
													 (*game) -> scrbuf -> w / 2 + (*game) -> position - santa[ direction ] -> w / 2 , (*game) -> scrbuf -> h - workshop -> h - santa[ direction ] -> h ,
													 x2- snow -> w/2 , y2 - snow -> h/2 , collision_point ) )
                {
                    play_sample(busted, 255, 128, 1000, 0);

                    (*game) -> lifes -- ;
                    if( (*game) -> lifes < 0 )
                        return 1 ;

                    for( it = 0 ; it < 50 ; it ++ )
                    {
                            itx =  20 - rand() %40 ;
                            ity =  -1 - rand() %20 ;

                            ax = (itx *( rand() / ( RAND_MAX + 1.0 ) ))/2;
							ay = (ity *( rand() / ( RAND_MAX + 1.0 ) ))/2;

                            add_particle( FX , snowmini , NORMAL_PART , x2  , y2 + snowmini -> h  , 1000 + rand()%500 ,
                            0 ,
                            itx , ity , 0 ,
                            ax , ay , 0 );
                    }
                    free_particle( mad_balls , &p_iter_2 );
                }
                else
                {
                    if( x2 <  snow -> w / 2 )
                    {
                        p_iter_2 -> vx = 20 + rand()%20 ;
                    }
                    if( x2 > (SCREEN_W - (snow -> w/2 ) ) )
                    {
                        p_iter_2 -> vx = -20 - rand()%20 ;
                    }
                        p_iter_2 = p_iter_2 -> next ;
                }
            }



			x1 = (*game) -> position + (*game) -> scrbuf -> w / 2 ;
			y1 = (*game) -> scrbuf -> h - santa[ direction ] -> h - workshop -> h ;

			p_iter_1 = ice_fall -> list_start ;

			while( p_iter_1 )
			{
				x1 = p_iter_1 -> x ;
                y1 = p_iter_1 -> y ;

                if( p_iter_1 -> mode == SINUS_PART )
                {
                     if( p_iter_1 -> vx != 0 )
						x1 = x1 + p_iter_1 -> vx * sin( (p_iter_1 -> x/p_iter_1 -> vx) );
					else
						x1 = x1 + p_iter_1 -> vx * sin( p_iter_1 -> x);

					if( p_iter_1 -> vy != 0 )
						y1 = y1 + p_iter_1 -> vy * cos( (p_iter_1 -> y/p_iter_1 -> vy) );
					else
						y1 = y1 + p_iter_1 -> vy * cos( p_iter_1 -> y );
                }

			    if( (y1 + ice->h/2) > (SCREEN_H - workshop -> h) )
				{
					for( it = 0 ; it < 70 ; it ++ )
					{
						it1 = sqrt( (( x1 - x2 )*( x1 - x2 )) + (( y1 - y2 )*( y1 - y2 )) );
						if( it1 == 0 )
							it1 = 1 ;

						ity = - ( 50 * ( y1 - y2 ) )/it1;

						itx = 20 - rand() %40 ;
						ity = ity + 10 - rand() %20 ;


						ax = itx * rand() / ( RAND_MAX + 1.0 ) ;
						ay = ity * rand() / ( RAND_MAX + 1.0 ) ;

						add_particle( FX , NULL , NORMAL_PART , x1  , y1 , 1000 + rand()%500 ,
						makecol( 0 , 0 , 200 + rand()%55 ) ,
						itx , ity , 0 ,
						ax , ay , 0 );
					}

					free_particle( ice_fall , &p_iter_1 );
				}
				else
				{
					if( check_pmask_collision_position( santamask[ direction ] , icemask ,
						     						 (*game) -> scrbuf -> w / 2 + (*game) -> position - santa[ direction ] -> w / 2 , (*game) -> scrbuf -> h - workshop -> h - santa[ direction ] -> h ,
													 x1- ice -> w/2 , y1 - ice -> h/2 , collision_point ) )
					{
	                    play_sample(busted, 255, 128, 1000, 0);

	                    (*game) -> lifes -- ;
	                    if( (*game) -> lifes < 0 )
	                        return 1 ;

	                    for( it = 0 ; it < 70 ; it ++ )
	                    {
	                            itx =  10 - ( 21 * rand() / ( RAND_MAX + 1.0 ) );
	                            ity = -60 -( 60 * rand() / ( RAND_MAX + 1.0 ) );


	                            ax = itx * rand() / ( RAND_MAX + 1.0 ) ;
								ay = -ity/( 10 - 3 * rand() / ( RAND_MAX + 1.0 ) );

	                            add_particle( FX , NULL , NORMAL_PART , x1 , y1 + ice->h , 1500 + rand()%1500 ,
	                            makecol( 200 + rand()%55 , 0 , 0) ,
	                            itx , ity , 0 ,
	                            ax , ay , 0 );
	                    }
	                    free_particle( ice_fall , &p_iter_1 );
	                }
	                else
	                {
	                    p_iter_1 = p_iter_1 -> next ;
	                }
				}
			}


			if( key[KEY_S] && key[KEY_T])
			{
				while( key[KEY_S] ||key[KEY_T]){};
				(*game) -> level = 10 ;
			}

			if( key[ KEY_LEFT ] && (*game) -> position > (-SCREEN_W/2) )
			{
				(*game) -> position -=10;
				direction = 0 ;
			}
			if( key[ KEY_RIGHT ] && (*game) -> position < (SCREEN_W/2)  )
			{
				(*game) -> position +=10;
				direction = 1;
			}

			if( clicked >= 0 )
                clicked = clicked - (*game) -> logic_time ;

			if( mouse_b&1 )
			{
				if( clicked < 0 )
				{
					play_sample(shoot, 255, 128, 1000, 0);

                    (*game) -> shooted ++ ;

					itx = (double)(mouse_x - ( (*game) -> position + ((*game) -> scrbuf -> w / 2) + (santa[ direction ] -> w / 2) - 20 ) ) ;
					ity = (double)( mouse_y - ( (*game) -> scrbuf -> h - santa[ direction ] -> h - workshop -> h )  ) ;
					if( itx == 0)
					{
						while( itx == 0 )
						itx = 2-rand()%5;
					}
					if( ity == 0)
					{
						while( ity == 0 )
						ity = 2-rand()%5;
					}
					while( abs( itx ) < 2 )
						itx *= 2 ;
					while( abs( ity ) < 2 )
						ity *= 2 ;

					ax = itx / ( 35 / (*game)->level ) ;
					ay = ity / ( 35 / (*game)->level ) ;

					if( direction == -1 )
                    {
                        add_particle( bullets , canon , 0 , (*game) -> position + (santa[ direction ] -> w / 2) , 0 , 10000 , makecol( 240 + rand()%15 , 240 + rand()%15 , 240 + rand()%15 ) ,
					    itx, ity , 0 ,
						ax , ay , 0 );
                        if( (*game)->level >= 10 )
                        {
                            add_particle( bullets , canon , NORMAL_PART , 40+(*game) -> position + (santa[ direction ] -> w / 2) , 0 , 10000 , makecol( 240 + rand()%15 , 240 + rand()%15 , 240 + rand()%15 ) ,
                            itx, ity , 0 ,
                            ax , ay , 0 );
                            add_particle( bullets , canon , NORMAL_PART , -40+(*game) -> position + (santa[ direction ] -> w / 2) , 0 , 10000 , makecol( 240 + rand()%15 , 240 + rand()%15 , 240 + rand()%15 ) ,
                            itx, ity , 0 ,
                            ax , ay , 0 );
                        }
                    }
                    else
                    {
                        add_particle( bullets , canon , 0 , (*game) -> position + (santa[ direction ] -> w / 2) -20 , 0 , 10000 , makecol( 240 + rand()%15 , 240 + rand()%15 , 240 + rand()%15 ) ,
					    itx, ity , 0 ,
						itx/2 , ity/2 , 0 );
						if( (*game)->level >= 10 )
                        {
                             add_particle( bullets , canon , NORMAL_PART , 40+(*game) -> position + (santa[ direction ] -> w / 2) -20 , 0 , 10000 , makecol( 240 + rand()%15 , 240 + rand()%15 , 240 + rand()%15 ) ,
                            itx, ity , 0 ,
                            ax , ay , 0 );
                            add_particle( bullets , canon , NORMAL_PART , -40+(*game) -> position + (santa[ direction ] -> w / 2) -20 , 0 , 10000 , makecol( 240 + rand()%15 , 240 + rand()%15 , 240 + rand()%15 ) ,
                            itx, ity , 0 ,
                            ax , ay , 0 );
                        }
                    }

				if( (*game)->level < 10 )
                    clicked = 80000 * (10 - (*game) -> level );
                else
                    clicked = 30000 ;

				}
			}
			else
			{
				if( !mouse_b&1)
				{
				    clicked = 0 ;

				}
			}

		} /* if( logic_time ... ) */


        if( (*game) -> draw_time <= 0 )
        {
            if( (*game) -> draw_time == (*game) -> GFX_UPDATE_RATE )
                (*game) -> draw_time += 1 ;

            if( ( (*game) -> GFX_UPDATE_RATE - (*game) -> draw_time ) > 1000000 )
                (*game) -> real_framerate = ( (*game) -> GFX_UPDATE_RATE - (*game) -> draw_time ) / 1000000;
            else
                (*game) -> real_framerate = 1000000 / ( (*game) -> GFX_UPDATE_RATE - (*game) -> draw_time );

            (*game) -> draw_time += (*game) -> GFX_UPDATE_RATE ;

            if( (*game) -> draw_time <= 0 )
                (*game) -> draw_time = (*game) -> GFX_UPDATE_RATE;

            if( (*game) -> BLUR == 1 )
            {
                drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
                set_alpha_blender();
                rectfill( (*game) -> scrbuf , 0 , 0 , (*game) -> scrbuf -> w , (*game) -> scrbuf -> h , makeacol( 0 , 0 , 0 , (*game) -> fade_value ));
                drawing_mode(DRAW_MODE_SOLID, NULL, 0, 0);
            }
            else
                clear( (*game) -> scrbuf );

			draw_particle( (*game) -> scrbuf , little_snow );
			draw_particle( (*game) -> scrbuf , mad_balls );


            masked_blit( workshop , (*game) -> scrbuf , 0 , 0 , (*game) -> scrbuf -> w / 2 - workshop -> w / 2, (*game) -> scrbuf -> h - workshop -> h , workshop -> w , workshop -> h );
			masked_blit( santa[ direction ] , (*game) -> scrbuf , 0 , 0 , (*game) -> position + (*game) -> scrbuf -> w / 2 - santa[ direction ] -> w / 2, (*game) -> scrbuf -> h - workshop -> h -santa[ direction ] -> h, santa[ direction ] -> w , santa[ direction ] -> h );

			draw_particle( (*game) -> scrbuf , ice_fall );
			draw_particle( (*game) -> scrbuf , bullets );
			draw_particle( (*game) -> scrbuf , FX );

			textprintf_ex( (*game) -> scrbuf , font , 2, 2 , makecol( 255 , 10 , 0) , -1 ,
			"Score: %d , Lifes: %d, Level: %d" , (*game) -> score , (*game) -> lifes , (*game) -> level ) ;
			if( (*game) -> shooted > 0 )
			{
            textprintf_ex( (*game) -> scrbuf , font , 2, 13 , makecol( 255 , 10 , 0) , -1 ,
			"Shots:%d , Busted: %d , %d %%" , (*game) -> shooted , (*game) -> busted  , (100 * (*game) -> busted )/(*game) -> shooted)   ;
			}
			line( (*game) -> scrbuf , mouse_x -10 , mouse_y , mouse_x + 10 , mouse_y , makecol( 255 , 0 , 0 ));
			line( (*game) -> scrbuf , mouse_x , mouse_y-10 , mouse_x  , mouse_y +10, makecol( 255 , 0 , 0 ));
			circle( (*game) -> scrbuf , mouse_x , mouse_y , 6 , makecol( 255 , 0 , 0 ) );

            if( level_start > 0 )
             {
                if( (*game) -> level < 10 )
                {
                     textprintf_centre_ex( (*game) -> scrbuf , font , SCREEN_W/2, SCREEN_H/2 , makecol( 255 , 10 , 0) , -1 ,
			"LEVEL %d ! AIM WITH MOUSE ,CLICK FOR FIRE, MOVE WITH ARROW KEYS !" , (*game) -> level )   ;

                }
                else
                {
                    textprintf_centre_ex( (*game) -> scrbuf , font , SCREEN_W/2, SCREEN_H/2 - 20 , makecol( 255 , 10 , 0) , -1 ,
			"SPECIAL LEVEL !"  )   ;
			  textprintf_centre_ex( (*game) -> scrbuf , font , SCREEN_W/2, SCREEN_H/2 , makecol( 255 , 10 , 0) , -1 ,
			"SPECIAL ! LEVEL %d ! SPECIAL !" , (*game) -> level )   ;
			  textprintf_centre_ex( (*game) -> scrbuf , font , SCREEN_W/2, SCREEN_H/2 + 20, makecol( 255 , 10 , 0) , -1 ,
			"SPECIAL LEVEL !"  )   ;
                }
             }

			rectfill( (*game) -> scrbuf , SCREEN_W-22 , 30 , SCREEN_W-10 , SCREEN_H-155 , makecol( 0 , 0 , 255 ));
            rectfill( (*game) -> scrbuf , SCREEN_W-18 , SCREEN_H-160-4*(*game)->lifes , SCREEN_W-12 , SCREEN_H-160 , makecol( 255 , 0 , 0 ));

            if( (*game) -> level < 10 )
                it = ((*game) -> busted * 100 ) /(((*game) -> level + 1 ) * 15 );
            else
                it = ((*game) -> busted * 100 ) /700;


            it = (it * ( SCREEN_H -155-30 )) / 100 ;
            rectfill( (*game) -> scrbuf , SCREEN_W-22 , SCREEN_H -155 , SCREEN_W-32 , SCREEN_H -155- it , makecol( 255 , 255 , 0 ));



			blit( (*game) -> scrbuf , screen ,0 , 0  , 0 , 0 , (*game) -> scrbuf -> w , (*game) -> scrbuf -> h );

            if( gfx_status( GET , 0 ) == MODE_OGL )
            {
                allegro_gl_flip();
            }

            if( (*game) -> wait_for_slowing_down_cpu == 1 )
                (*game) -> wait_for_slowing_down_cpu = 2;
        }

        if( (*game) -> wait_for_slowing_down_cpu == 2 && ( (*game) -> CPU_MODE != CPU_USE_FULL ) )
        {
            (*game) -> wait_for_slowing_down_cpu = 0;
            rest( (*game) -> CPU_MODE );
        }

    }while( !key[ KEY_ESC ] && !(*DONE) );

	destroy_bitmap( workshop );
	destroy_bitmap( santa[ 0 ] );
	destroy_bitmap( santa[ 1 ] );
	destroy_bitmap( snow );
	destroy_bitmap( snowmini );
	destroy_bitmap( canon );
	destroy_bitmap( ice );

    destroy_pmask( snowmask );
    destroy_pmask( canonmask );
	destroy_pmask( santamask[ 0 ] );
    destroy_pmask( santamask[ 1 ] );
    destroy_pmask( icemask );

	destroy_sample( shoot );
    destroy_sample( busted );

	free_particle_system( &mad_balls );
    free_particle_system( &little_snow );
    free_particle_system( &bullets );
    free_particle_system( &FX );
	free_particle_system( &ice_fall );

	return 1 ;

	}
