/**\file particle.h
*
*  particle header file for Christmas Hack 2007
*
*\author Castagnier Mickal aka Gull Ra Driel
*
*\version 1.0
*
*\date 15/12/2007
*
*/



#ifndef PARTICLE_HEADER_FOR_CHRISTMASHACK
    #define PARTICLE_HEADER_FOR_CHRISTMASHACK

    #ifdef __cplusplus
       extern "C" {
    #endif

	#include "main.h"

	#define NORMAL_PART 0
	#define SINUS_PART 1
    #define TRANS_PART 2


	typedef struct PARTICLE
	{
		double x , y , z ,
			   ax , ay , az ,
			   vx , vy , vz ;

		BITMAP *sprite ;

		int mode ,
			off_x , off_y ,
			lifetime ,
			color;

		struct PARTICLE *next ,
				 *prev ;

	} PARTICLE ;

	typedef struct PARTICLE_SYSTEM
	{
		PARTICLE *list_start , *list_end ;

		double x , y , z ;

		N_TIME timer ;

		int max_particles,
			nb_particles ;

	}PARTICLE_SYSTEM ;

	int init_particle_system( PARTICLE_SYSTEM **psys , int max , double x , double y , double z );

	int add_particle( PARTICLE_SYSTEM *psys , BITMAP *spr , int mode , int off_x , int off_y , int lifetime , int color ,
					  double vx , double vy , double vz ,
					  double ax , double ay , double az );

	int manage_particle( PARTICLE_SYSTEM *psys);

	int draw_particle( BITMAP *bmp , PARTICLE_SYSTEM *psys );

	int free_particle( PARTICLE_SYSTEM *psys , PARTICLE **ptr );

	int free_particle_system( PARTICLE_SYSTEM **psys);

	#ifdef __cplusplus
		}
	#endif
#endif /* PARTICLE_HEADER_FOR_CHRISTMASHACK */

