/**\file main.c
*
*  Santa's Fight main file for Christmas Hack 2007
*
*\author Castagnier Mickal aka Gull Ra Driel
*
*\version 1.0
*
*\date 15/12/06
*
*/

#include "main.h"

int init_game_env( GAME_ENV **game )
{
	(*game) -> BLUR = 1 ;
	(*game) -> fade_value = 20 ;
	(*game) -> DONE = 0 ;
	(*game) -> GFX_CONFIG_MODE = GFX_OPENGL_WINDOWED ;
	(*game) -> CPU_MODE = CPU_USE_FULL ;
	(*game) -> loop_time = 0 ;
	(*game) -> draw_time = 0 ;
	(*game) -> logic_time = 0 ;
	(*game) -> wait_for_slowing_down_cpu = 0 ;
	(*game) -> GFX_UPDATE_RATE = 20000 ;
	(*game) -> LOGIC_RATE = 10000 ;
	(*game) -> real_framerate = 0 ;
	(*game) -> next_move_delay = 0 ;
	(*game) -> draw_time = 0 ;
	(*game) -> score = 0 ;
	(*game) -> lifes = 100 ;
	(*game) -> level = 1 ;
	(*game) -> position = 0 ,
	(*game) -> shooted = 0 ,
	(*game) -> busted = 0 ;
	(*game) -> scrbuf = NULL ;

	return TRUE;
}

GAME_ENV *game = NULL ;

int DONE = 0 ;

/* Close callback handler */
void close_callback( void )
{
    DONE = 1;
} /* close_callback(...) */

/* file for getting some config*/
FILE *config;
/* for some string manipulations */
char strbuf[ 1024 ];

MIDI *music = NULL;

/* CH STARTS HERE ;-) */
int main( void )
{
	Malloc( game , GAME_ENV , 1 );

	init_game_env( &game );

	/* CONFIGURATION STAGE */
    config = fopen( "config.txt" , "rt" );

    if( !config )
    {
        allegro_message( "FATAL ERROR: Can not open config.txt file ! \n");
        exit( FALSE );
    }

    fill_str( strbuf , 0 , 1024 ); /* for some strange reasons, I like having my string filled by zero before using them */

    if( fgets( strbuf , 1024 , config ) == NULL ) /*error reading comment*/
    {
        allegro_message( "FATAL ERROR: Can not read comment ( line 1 ) in config.txt file ! \n");
        exit( FALSE );
    }

    if( fgets( strbuf , 1024 , config ) == NULL )
    {
        allegro_message( "FATAL ERROR: Can not read GFX_CONFIG_MODE in config.txt file ! \n");
        exit( FALSE );
    }

    if( strncmp( strbuf , "GFX_AUTODETECT" , 14 ) == 0 )
        game -> GFX_CONFIG_MODE = GFX_AUTODETECT;
    else
        if( strncmp( strbuf , "GFX_DIRECTX_WIN" , 15 ) == 0 )
            game -> GFX_CONFIG_MODE = GFX_DIRECTX_WIN;
        else
            if( strncmp( strbuf , "GFX_DIRECTX" , 11 ) == 0 )
                game -> GFX_CONFIG_MODE = GFX_DIRECTX;
            else
                if( strncmp( strbuf , "GFX_OPENGL_WINDOWED" , 19 ) == 0 )
                    game -> GFX_CONFIG_MODE = GFX_OPENGL_WINDOWED;
                else
                    if( strncmp( strbuf , "GFX_OPENGL_FULLSCREEN" , 21 ) == 0 )
                        game -> GFX_CONFIG_MODE = GFX_OPENGL_FULLSCREEN;
                    else
                        allegro_message( "WARNING: NO USABLE GFX_MODE LOADED FROM CONFIG FILE ! USING DEFAULT GFX_OPENGL_WINDOWED !\n" );

    if( fgets( strbuf , 1024 , config ) == NULL ) /*error reading comment*/
    {
        allegro_message( "FATAL ERROR: Can not read comment ( line 3 ) in config.txt file ! \n");
        exit( FALSE );
    }

    if( fgets( strbuf , 1024 , config ) == NULL )
    {
        allegro_message( "FATAL ERROR: Can not read CPU_MODE in config.txt file ! \n");
        exit( FALSE );
    }

    if( strncmp( strbuf , "CPU_USE_FULL" , 12 ) == 0 )
        game -> CPU_MODE = CPU_USE_FULL;
    else
        if( strncmp( strbuf , "CPU_USE_NICE" , 12 ) == 0 )
            game -> CPU_MODE = CPU_USE_NICE;
        else
            if( strncmp( strbuf , "CPU_USE_LESS" , 12 ) == 0 )
                game -> CPU_MODE = CPU_USE_LESS;
            else
                allegro_message( "WARNING: NO USABLE CPU_MODE LOADED FROM CONFIG FILE ! USING DEFAULT CPU_FULL_USE !\n" );

    if( fgets( strbuf , 1024 , config ) == NULL ) /*error reading comment*/
    {
        allegro_message( "FATAL ERROR: Can not read comment ( line 7 ) in config.txt file ! \n");
        exit( FALSE );
    }

    if( fgets( strbuf , 1024 , config ) == NULL )
    {
        allegro_message( "FATAL ERROR: Can not read DRAWING_UPDATE_RATE in config.txt file !");
        exit( FALSE );
    }

    game -> GFX_UPDATE_RATE = strtol( strbuf , NULL , 10 );

    if( game -> GFX_UPDATE_RATE < 0 )
    {
        allegro_message( "WARNING: You can not have a negative or zero GFX_UPDATE_RATE\nDefault value ( 20000 ) will be used" );
        game -> GFX_UPDATE_RATE = 20000;
    }
    else
        if( game -> GFX_UPDATE_RATE > 1000000 )
        {
            allegro_message( "WARNING: You would not want to have a 1 second GFX_UPDATE_RATE, no ?\nDefault value ( 20000 ) will be used" );
            game -> GFX_UPDATE_RATE = 20000;
        }

    if( fgets( strbuf , 1024 , config ) == NULL ) /*error reading comment*/
    {
        allegro_message( "FATAL ERROR: Can not read comment ( line 9 ) in config.txt file ! \n");
        exit( FALSE );
    }

    if( fgets( strbuf , 1024 , config ) == NULL )
    {
        allegro_message( "FATAL ERROR: Can not read LOGIC_RATE in config.txt file !");
        exit( FALSE );
    }

    game -> LOGIC_RATE = strtol( strbuf , NULL , 10 );

    if( game -> LOGIC_RATE < 0 )
    {
        allegro_message( "WARNING: You can not have a negative or zero LOGIC_RATE\nDefault value ( 10000 ) will be used" );
        game -> LOGIC_RATE = 10000;
    }
    else
        if( game -> LOGIC_RATE > 1000000 )
        {
            allegro_message( "WARNING: You would not want to have a 1 second LOGIC_RATE, no ?\nDefault value ( 10000 ) will be used" );
            game -> LOGIC_RATE = 20000;
        }
    /* END OF CONFIGURATION STAGE */


    /* INIT STAGE */
    allegro_init();
    set_uformat( U_ASCII );
    install_timer();
    install_mouse();
    /* install a MIDI sound driver */
   if (install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL) != 0) {
      allegro_message("Error initialising sound system\n%s\n", allegro_error);
      return 1;
   }
    install_keyboard();



    music = load_midi("DATA/SOUNDS/music.mid");

    if (!music)
    {
        allegro_message("Error loading midi: %s ", allegro_error);
      return 1;
   }
    play_midi(music, TRUE);

    set_window_title( "Santa's Fight" );
    set_close_button_callback( close_callback );

    if( gfx_mode( game -> GFX_CONFIG_MODE , 800 , 600 , 0 , 0 , 32 , 0.0 , 0.0 , 0.0 , 1.0 ) == FALSE )
    {
        allegro_exit();
        exit( FALSE );
    }

    if( gfx_status( GET , 0 ) == MODE_OGL )
    {
        glClear( GL_COLOR_BUFFER_BIT );
        allegro_gl_flip();
        glClear( GL_COLOR_BUFFER_BIT );
        allegro_gl_flip();
        allegro_gl_set_allegro_mode();
    }

    game -> scrbuf = create_bitmap( SCREEN_W , SCREEN_H );

    if( !game -> scrbuf )
    {
        if( gfx_status( GET , 0 ) == MODE_OGL )
            allegro_gl_unset_allegro_mode();
        set_gfx_mode( GFX_TEXT , 0 , 0 , 0 , 0 );
        allegro_message( "Error creating screen buffer.\nExiting with %s\n" , allegro_error );
        allegro_exit();
        exit( FALSE );
    }

    clear( game -> scrbuf );

    install_pmask();

    /* INTRO */
	proceed_intro( game -> scrbuf , &DONE );

    /* The two minigame loop ( only one is already done )*/
	while( !DONE && !key[KEY_ESC] && game -> lifes > 0 && game -> level <= 10 )
	{
		game -> position = 0 ;

		DONE = proceed_snowattak( &game , &DONE );

    }
        clear( game -> scrbuf );

        /* END OF GAME LOOP */
        if( game -> lifes <= 0 || key[KEY_ESC] || DONE==1 )
        {
        textprintf_centre_ex( game -> scrbuf , font , SCREEN_W/2, 40 , makecol( 255 , 0 , 0) , -1 ,
			"YOU LOOSE ! SANTAS WORKSHOP IS GONE !" );
        textprintf_centre_ex( game -> scrbuf , font , SCREEN_W/2, 80 , makecol( 255 , 0 , 0) , -1 ,
			"LEVEL: %d , SCORE: %d , LIFE:%d", game -> level , game -> score ,game -> lifes);
        textprintf_centre_ex( game -> scrbuf , font , SCREEN_W/2, 120 , makecol( 255 , 0 , 0) , -1 ,
			"SHOOTED: %d , MISSED: %d, SUCCESS RATE: %d %%", game -> shooted , game -> busted , ( 100  * (game -> busted +1))/ (game -> shooted +1));
        textprintf_centre_ex( game -> scrbuf , font , SCREEN_W/2, 160 , makecol( 255 , 0 , 0) , -1 ,
			"!!!! TRY AGAIN !!!!");
        textprintf_centre_ex( game -> scrbuf , font , SCREEN_W/2,SCREEN_H-30 , makecol( 255 , 0 , 0) , -1 ,
			"___ ___ ___ PRESS ___ ESC ___ ___ ___" );
        }
        else
        {
		game -> level -- ;
        clear( game -> scrbuf );
        textprintf_centre_ex( game -> scrbuf , font , SCREEN_W/2, 40 , makecol( 255 , 0 , 0) , -1 ,
			"YOU WIIIIIIIIIIIIIN ! SANTAS WORKSHOP IS SAVED !" );
        textprintf_centre_ex( game -> scrbuf , font , SCREEN_W/2, 80 , makecol( 255 , 0 , 0) , -1 ,
			"LEVEL: %d , SCORE: %d", game -> level , game -> score );
        textprintf_centre_ex( game -> scrbuf , font , SCREEN_W/2, 120 , makecol( 255 , 0 , 0) , -1 ,
			"SHOOTED: %d , MISSED: %d, SUCCESS RATE: %d %%", game -> shooted , game -> busted , ( 100  * (game -> busted +1))/ (game -> shooted +1));
        textprintf_centre_ex( game -> scrbuf , font , SCREEN_W/2, 160 , makecol( 255 , 0 , 0) , -1 ,
			"!!!! YOU CAN TRY AGAIN !!!!");

        textprintf_centre_ex( game -> scrbuf , font , SCREEN_W/2,SCREEN_H-30 , makecol( 255 , 0 , 0) , -1 ,
			"___ ___ ___ PRESS ___ ESC ___ ___ ___" );



        }

            blit( game -> scrbuf , screen , 0 , 0 , 0 , 0 , game -> scrbuf -> w , game -> scrbuf -> h );

            if( gfx_status( GET , 0 ) == MODE_OGL )
            {
                allegro_gl_flip();
            }

            do{
                rest( 10 );
            }while( key[ KEY_ESC] );
            do{
                rest( 10 );
            }while( !key[ KEY_ESC] );

	/* TODO SAVE HIGHSCORES */

    /* EXITING ... */
    destroy_bitmap( game -> scrbuf );

    if( gfx_status( GET , 0 ) == MODE_OGL )
            allegro_gl_unset_allegro_mode();

     destroy_midi(music);

     allegro_exit();


    return TRUE;

}END_OF_MAIN()
