/**\file intro.c
*
*  Intro function file for Christmas Hack 2007
*
*\author Castagnier Mickal aka Gull Ra Driel
*
*\version 1.0
*
*\date 15/12/2007
*
*/

#include "main.h"


/*!\fn proceed_intro()
  *
  *\brief Intro function
  *
  *\param bmp Where to draw the intro
  *
  *\return TRUE
  */
int proceed_intro( BITMAP *bmp , int *DONE )
{
	PARTICLE_SYSTEM *pleft = NULL , *pright = NULL , *pltop = NULL , *prtop = NULL;

	POSITION pos[ 9 ];
	int it = 0 ;

	init_particle_system( &pleft , 100  , 0 , bmp -> h , 0 );
	init_particle_system( &pright , 100 , bmp -> w , bmp -> h , 0 );
	init_particle_system( &pltop , 100  , 0 , 0 , 0 );
	init_particle_system( &prtop , 100 , bmp -> w ,0 , 0 );


	for( it = 0 ; it < 9 ; it ++ )
	{
		pos[ it ] . x = bmp -> w /2 ;

		if( it == 0 )
			pos[ it ] . y = -10 * it ;
		else
			pos[ it ] . y = pos[ it - 1 ] . y - 20 - rand()%50 ;

		pos[ it ] . mx = 0 ;
		pos[ it ] . width = 20 + rand()%40 ;
		add_particle( pleft , NULL , 0 , 0 , 0 , 10000 + rand()%10000, makecol( 255 , 0 , 0 ) ,
					  rand()%40 , -rand()%40 , 0 ,
					  1-(2.0*rand()/(RAND_MAX+1.0)) , 1-(2.0*rand()/(RAND_MAX+1.0))  , 1-(2.0*rand()/(RAND_MAX+1.0))  );
		add_particle( pright , NULL , 0 , 0 , 0 , 10000 + rand()%10000 , makecol( 0 , 250 , 0 ) ,
					  -rand()%40 , -rand()%40 , 0 ,
					  1-(2.0*rand()/(RAND_MAX+1.0)) , 1-(2.0*rand()/(RAND_MAX+1.0))  , 1-(2.0*rand()/(RAND_MAX+1.0))  ); 
		add_particle( pltop , NULL , 0 , 0 , 0 , 10000 + rand()%10000, makecol( 0 , 0 , 250 ) ,
					  rand()%40 , rand()%40 , 0 ,
					  1-(2.0*rand()/(RAND_MAX+1.0)) , 1-(2.0*rand()/(RAND_MAX+1.0))  , 1-(2.0*rand()/(RAND_MAX+1.0))  ); 
		add_particle( prtop , NULL , 0 , 0 , 0 , 10000 + rand()%10000 , makecol( 255 , 250 , 0 ) ,
					  -rand()%40 , rand()%40 , 0 ,
					  1-(2.0*rand()/(RAND_MAX+1.0)) , 1-(2.0*rand()/(RAND_MAX+1.0))  , 1-(2.0*rand()/(RAND_MAX+1.0))  ); 
	}

	do
	{
		for( it = 0 ; it < 9 ; it ++ )
		{


			add_particle( pleft , NULL , SINUS_PART , 0 , 0 , 10000 + rand()%10000, makecol( 255 , 0 , 0 ) ,
					  rand()%40 , -rand()%40 , 0 ,
					  1-(2.0*rand()/(RAND_MAX+1.0)) , 1-(2.0*rand()/(RAND_MAX+1.0))  , 1-(2.0*rand()/(RAND_MAX+1.0))  ); 
			add_particle( pright , NULL , SINUS_PART , 0 , 0 , 10000 + rand()%10000 , makecol( 0 , 250 , 0 ) ,
						  -rand()%40 , -rand()%40 , 0 ,
						  1-(2.0*rand()/(RAND_MAX+1.0)) , 1-(2.0*rand()/(RAND_MAX+1.0))  , 1-(2.0*rand()/(RAND_MAX+1.0))  );
			add_particle( pltop , NULL , SINUS_PART , 0 , 0 , 10000 + rand()%10000, makecol( 0 , 0 , 250 ) ,
						  rand()%40 , rand()%40 , 0 ,
						  1-(2.0*rand()/(RAND_MAX+1.0)) , 1-(2.0*rand()/(RAND_MAX+1.0))  , 1-(2.0*rand()/(RAND_MAX+1.0))  ); 
			add_particle( prtop , NULL , SINUS_PART , 0 , 0 , 10000 + rand()%10000 , makecol( 255 , 250 , 0 ) ,
						  -rand()%40 , rand()%40 , 0 ,
						  1-(2.0*rand()/(RAND_MAX+1.0)) , 1-(2.0*rand()/(RAND_MAX+1.0))  , 1-(2.0*rand()/(RAND_MAX+1.0))  );


			pos[ it ] . mx = pos[ it ] . width * sin( ((double)pos[ it ] . y/30) );

			textprintf_centre_ex( bmp , font , pos[ it ] . mx + pos[ it ] . x , pos[ it ] . y - 3 , makecol( 255 , 0 , 0  ) , -1 , "%s" , intro_text[ it ] );
			textprintf_centre_ex( bmp , font , pos[ it ] . mx + pos[ it ] . x , pos[ it ] . y - 2 , makecol( 255 , 0 , 0  ) , -1 , "%s" , intro_text[ it ] );
			textprintf_centre_ex( bmp , font , pos[ it ] . mx + pos[ it ] . x , pos[ it ] . y - 1 , makecol( 0 , 0 , 0  ) , -1 , "%s" , intro_text[ it ] );
		    textprintf_centre_ex( bmp , font , pos[ it ] . mx + pos[ it ] . x , pos[ it ] . y  , makecol( 255 , 255 , 255 ) , -1 , "%s" , intro_text[ it ] );

			pos[ it ] . y++;
		}

		if( pos[ 7 ] . y > bmp -> h )
		{
			for( it = 0 ; it < 8 ; it ++ )
			{
				pos[ it ] . x = bmp -> w /2 ;

				if( it == 0 )
					pos[ it ] . y = -10 * it ;
				else
					pos[ it ] . y = pos[ it - 1 ] . y - 20 - rand()%50 ;

				pos[ it ] . mx = 0 ;
				pos[ it ] . width = 20 + rand()%40 ;
			}
		}

		manage_particle( pleft );
		manage_particle( pright );
		manage_particle( pltop );
		manage_particle( prtop );

		draw_particle( bmp ,pleft );
		draw_particle( bmp ,pright);
		draw_particle( bmp ,pltop );
		draw_particle( bmp ,prtop);

		drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
		set_alpha_blender();
		rectfill( bmp , 0 , 0 , bmp -> w , bmp -> h , makeacol( 0 , 0 , 0 , 20 ));
		drawing_mode(DRAW_MODE_SOLID, NULL, 0, 0);

		blit( bmp , screen , 0 , 0 , 0 , 0 , bmp -> w , bmp -> h );

		if( gfx_status( GET , 0 ) == MODE_OGL )
		{
			allegro_gl_flip();
		}

		rest( 10 );

	}while( !key[ KEY_ESC ] && !(*DONE) );

	free_particle_system( &pleft );
	free_particle_system( &pright );

	rest( 1000 );

	return TRUE;
} /* proceed_intro(...) */
