/**\file nilorea.h
*
*  Header to include for use with libnilorea
*
*\author Castagnier Mickal
*
*\version 1.0
*
*\date 24/03/05
*/



#ifndef __NILOREA_Unified_Library__

    #define __NILOREA_Unified_Library__

    /* Some usefull definitions. No need to comment ... I think ! */

    /* #define LINUX */

    /* #define NOALLEGRO   */
    /* #define NOSOUND     */
    /* #define NOPTHREAD   */
    /* #define NONETWORK   */
    /* #define NOISOENGINE */
    /* #define NOSTR       */
    /* #define NETW_DEBUG  */
    /* #define NOGRAFIC    */
    /* #define DEBUGMODE   */



    #define _N_ENGINE_VER_ "2.0 a"



    /*common C including: socket, thread, ...
      ( I like C, it is sooo ... hugly, isn't it ;-P ) */

    #include "n_common.h"

    /* Nilorea Library API */



    #ifndef NOSTR

        /*header for string routine*/
        #include "n_str.h"

        /*header for string doubly linked list*/
        #include "n_strlist.h"

    #endif /*#ifndef NOSTR*/



    #ifndef NONETWORK

        #ifdef NOSTR
            #error You must use N_STR parts for network engine
        #endif

        /*header for network*/
        #include "n_network.h"
        /* User management */
        #include "n_user.h"


    #endif /*#ifndef NONETWORK*/



    #ifndef NOISOENGINE

        #ifdef NOSOUND
            #error You must use sound for map look like some real ones
        #endif

        #ifdef NOALLEGRO
            #error You must include allegro for using iso engine
        #endif

        #ifdef NOGRAFIC
            #error You are a kidding boy you know ! NO ISO MAP WITHOUT GRAFIC !
        #endif

        /* gfx mode */
        #include <alleggl.h>

        #include "n_grafic.h"

        /* iso engine */
        #include "n_anim.h"

        #include "n_sound.h"

        #include "n_iso_engine.h"

        #include "n_object.h"

    #endif /*#ifndef NOISOENGINE*/

#endif /*#ifndef __NILOREA_Unified_Library__*/
