/**\file n_strlist.h
*
*  N_STR linked list declaration
*
*  Everything you need to create, delete , append list is here
*
*\author Castagnier Mickal
*
*\version 1.0
*
*\date 24/03/05
*
*\warning Never forget to init_list(...) before using a N_STRLIST *LIST object
*/



#ifndef STRLIST

    #define STRLIST

    #ifdef __cplusplus
        extern "C"
        {
    #endif



        /*!
         * Use this to make a list with a 'big' capacity
         */

        #define HUGELIST 1048576



        /*!
         * Use this to swith Get_Seeker to get_next
         */

        #define NEXT 0

        /*!
         * Use this to swith Get_Seeker to get_prev
         */

        #define PREV 1



        /*!
         * A double linked box including a string and his lenght
         */

        typedef struct N_STR
        {
            /*! the string */
            char *data;
            /*! length of string (in case we wanna keep information after the 0 end of string value) */
            int length;
            /*! pointer to the next item of the list */
            struct N_STR *next;
            /*! pointer to the previous item of the list */
            struct N_STR *prev;

        } N_STR;



        /*!
         * A doubly linked list prototype of N_STR item
         */

        typedef struct N_STRLIST
        {
            N_STR  /*!start of list*/
            *start,
            /*!end of list*/
            *end;

            int   /*!number of item*/
            nb_item,
            /*!maximum of item in the list, -1 for undeterminated*/
            nb_max_item;

        } N_STRLIST;



        /*
         * Init function for lists
         */

        int init_list( N_STRLIST **LIST , int max );



        /*
         *To add an item at the begin of the list
         */

        int add_first( N_STRLIST *LIST , char *item , int length );



        /*
         *To add an item before the aimed position
         */

        int add_before( N_STRLIST *LIST , char *item , int length , int pos );



        /*
         *To add an item after the aimed position
         */

        int add_after( N_STRLIST *LIST , char *item , int length , int pos );



        /*
         *To add an item at the end of the list
         */

        int add_last( N_STRLIST *LIST , char *item , int length );



        /*
         * To get an aim on the first list element
         */

        N_STR *get_first( N_STRLIST *LIST );



        /*
         * To get an aim on the first list element
         */

        N_STR *get_last( N_STRLIST *LIST );



        /*
         * To get the previous list element
         */

        int get_prev( N_STR **STR );



        /*
         * To get the next list element
         */

        int get_next( N_STR **STR );



        /*
         * To get a pointer on 'pos' element in list
         */

        N_STR *SeekAt( N_STRLIST *LIST , int pos );



        /*
         * To kill the first item of a list
         */

        int kill_first_item( N_STRLIST *LIST );



        /*
         * To kill an item at 'pos'
         */

        int kill_item_at( N_STRLIST *LIST , int pos );



        /*
         * To kill the last item in list
         */
        int kill_last_item( N_STRLIST *LIST );



        /*
         * To empty the list
         */

        int empty_list( N_STRLIST *LIST );



        /*
         * Convert a char into a N_STR
         */

        int char_to_str( char *from , int nboct , N_STR **to );


        /*
         * Free a N_STR structure
         */

        int free_str( N_STR **ptr );


    #ifdef __cplusplus
        }
    #endif



#endif /* #ifndef N_STRLIST */


