/**\file n_str.h
*
*  string declaration
*
*  Everything you need to use string is here
*
*\author Castagnier Mickal
*
*\version 1.0
*
*\date 01/04/05
*
*\warning be carefull with 'low-level' functions
*/



#ifndef N_STRFUNC
    #define N_STRFUNC

    #ifdef __cplusplus
        extern "C"
        {
    #endif

        /*Clearing text screen*/
        #ifdef LINUX
            #define CLEAR system("clear");
        #else
            #define CLEAR system("cls");
        #endif



        /*
         *  Copy nboct
         */

        int Strcpy( char *from , char *to , int nboct );



        /*
         * copy from[start to end] on to[0 to (end-start)] skipping char 'skip'
         */

        int Strncpy( char *from , char *to , int start , int end , char skip );



        /*
         *fill a string by 'value'
         */

        int fill_str( char *string , char value , int length );



        /*
         * Skip character from string while string[iterator] == toskip step inc
         */

        int Skipw( char *string , char toskip , int *iterator , int inc );



        /*
         * Skip character from string while string[iterator] != toskip step inc
         */

        int Skipu( char *string , char toskip , int *iterator , int inc );



        /*
         * Upper case a string
         */

        int strup( char *string , char *dest );



        /*
         * Lower case a string
         */

        int strlo( char *string , char *dest );



    #ifdef __cplusplus
        }
    #endif



#endif /*#ifndef N_STR*/
