/**\file n_sound.h
*
*  Header to include sounds
*
*\author Castagnier Mickal
*
*\version 1.0
*
*\date 24/03/05
*
*/



#ifndef N_SOUND_SYSTEM

    #define N_SOUND_SYSTEM

    #ifdef __cplusplus
        extern "C"
        {
    #endif

        /*!
         * There is no sample
         */

        #define NONE 100



        /*!
         * The sample is IDLE, doing nothing
         */

        #define IDLE 111



        /*!
         * The sample is playing one time
         */

        #define PLAYING 222



        /*!
         * The sample is looping
         */

        #define LOOPING 333



        /*!
         * The sample is fading in when starting
         */

        #define FADING_IN 444



        /*!
         * The sample is fading out before stopping
         */

        #define FADING_OUT 555



        /*!
         * Type of a SOUND object
         */

        typedef struct SOUND
        {
            /*! Sound Data */
            SAMPLE *sample;

            /*! Sound name */
            char *name;

            /*! State of the song, could be IDLE,PLAYING,LOOPING,FADING_IN,FADING_OUT */
            int state;

        } SOUND;



        /*!
         * Type of a library of sound object
         */

        typedef struct LIBSOUND
        {
            /*! array of sound data */
            SOUND *data;

            /*! name of the library */
            char *name;

            /*! current highter sample */
            int current,
            /*! nb max sample in this library */
            max;

        } LIBSOUND;



        /*
         * Create a library of sounds
         */

        int create_libsound( LIBSOUND **lib , char *name , int max );



        /*
         * Free a library of sounds
         */

        int destroy_libsound( LIBSOUND **lib );



        /*
         * Add a sample to a library
         */

        int add_sample_to_lib( LIBSOUND **lib , SAMPLE *sample , char *name );



        /*
         * Replace id's sample by given sample in a library
         */

        int replace_sample( LIBSOUND **lib , int id , SAMPLE *sample );



        /*
         * Remove a sample from a library
         */

        int remove_sample_from( LIBSOUND **lib , int id );



        /*
         * Save sample in an opened datafile
         */

        int save_sample_in_datafile( SAMPLE *spl , PACKFILE *f );



        /*
         * Save a library of sound in an opened datafile
         */

        int save_libsound( LIBSOUND *lib , PACKFILE *file );



        /*
         * Load a sample from a datafile
         */

        SAMPLE *load_sample_from_datafile( PACKFILE *f );



        /*
         * Load a library of sounds from a datafile
         */

        int load_libsound( LIBSOUND **lib , PACKFILE *file );



        /*
         * Search for a sample in a lib
         */

        int search_sample_in( LIBSOUND *lib , char *name );



    #ifdef __cplusplus
        }
    #endif


#endif /* #ifndef N_SOUND_SYSTEM */
