/**\file iso_object.h
 *
 *  object definitions
 *
 *\author Castagnier Mickal
 *
 *\version 1.0
 *
 *\date 04/07/05
 *
 */

#ifndef ISO_OBJECT_FOR_NILOREA_LIBRARY



    #define ISO_OBJECT_FOR_NILOREA_LIBRARY



    #ifdef __cplusplus
       extern "C"
       {
    #endif



        /*! Positioning system */
        typedef struct N_COORD
        {
            double  /*! X position */
                    X,
                    /*! Y position */
                    Y,
                    /*! X speed */
                    spd_x,
                    /*! Y speed */
                    spd_y,
                    /*! X acceleration */
                    acc_x,
                    /*! Y accelertion */
                    acc_y;
        } N_COORD;



        /*! an OBJECT */
        typedef struct OBJECT
        {

            N_COORD /*! Current position */
                    cur_pos,
                    /*! Aimed position */
                    aim_pos;

            double /*! type */
                   type ,
                   /*! action */
                   action ,
                   /*! ident */
                   id ,
                   /*! time stamp */
                   time_stamp ,
                   /*! timeout */
                   timeout ,
                   /*! current time */
                   curr_time ;

            /*! pointer to next object */
            struct OBJECT *next ;
            /*! pointer to previous object */
            struct OBJECT *prev ;

        } OBJECT;



        /*! a list of OBJECT */
        typedef struct OBJECT_LIST
        {
            /*! first */
            OBJECT *start ,
            /*! last */
                   *end ;

            /*! number of objects */
            int nb_items,
            /*! maximum number of objects */
                nb_max_items;

        }OBJECT_LIST;



        /*
         * Initialize an OBJECT list
         */

        int init_object_list( OBJECT_LIST **objlst , int max );



        /*
         * Remove an OBJECT list
         */

        int destroy_object_list( OBJECT_LIST **objlist );


        /*
         * Add a new object or update and existing object
         */

        int add_object( OBJECT_LIST **objlist , double type , double action , double id , double X , double Y , double speed_x , double speed_y , double acc_x , double acc_y , double time_stamp , double timeout );



        /*
         * Remove an object
         */

        int rem_object( OBJECT_LIST *objlist , int id );



        /*
         * Remove timed out entries
         */

        int refresh_list_of_object( OBJECT_LIST **objlst );



        /*
         * Sort the list of object from 0 to SCREEN_W and from 0 to SCREEN_H ( ready to display );
         */

        int sort_list_of_object( OBJECT_LIST *list );



    #ifdef __cplusplus
        }
    #endif



#endif /* ISO_OBJECT_FOR_NILOREA_LIBRARY */
