#include "view.h"

View::View()
{	
	
		WORLD_X=100; 
	WORLD_Y=100;
	
	selected= false;
		GRID_WIDTH=20;
		GRID_HEIGHT=15;
		screen_pos_x=60;
		screen_pos_y=42;
		scroll_x=0;
		scroll_y=0;
		buffer = create_bitmap(SCREEN_W,SCREEN_H);
}

// scroll the map in the given direction
void View::do_scroll(int d)
{
	if (d==UP)
	{
		if (screen_pos_y>1) 
		{
			scroll_y-=8;
			if (scroll_y<0)
			{
				screen_pos_y--;
				scroll_y+=TILESIZE;
			}
		}
	}
	if (d==DOWN)
	{
		if (screen_pos_y<(WORLD_Y-GRID_HEIGHT)-2) 
		{
			scroll_y+=8;
			if (scroll_y>TILESIZE)
			{
				screen_pos_y++;
				scroll_y-=TILESIZE;
			}
		}
	}
	if (d==LEFT)
	{
		if (screen_pos_x>1) 
		{
			scroll_x-=8;
			if (scroll_x<0)
			{
				screen_pos_x--;
				scroll_x+=TILESIZE;
			}
		}
	}
	if (d==RIGHT)
	{
		if (screen_pos_x<(WORLD_X-GRID_HEIGHT)-2) 
		{
			scroll_x+=8;
			if (scroll_x>TILESIZE)
			{
				screen_pos_x++;
				scroll_x-=TILESIZE;
			}
		}
	}
}


// move the map with the mouse as the center
void View::move_view(int x, int y)
{
	screen_pos_x=(x-508)-(GRID_WIDTH/2);
	screen_pos_y=(y-360)-(GRID_WIDTH/2);

	if (screen_pos_x<1) screen_pos_x=1;
	if (screen_pos_x>(WORLD_X-GRID_WIDTH-1)) screen_pos_x=(WORLD_X-GRID_WIDTH-1);
	if (screen_pos_y<1) screen_pos_y=1;
	if (screen_pos_y>(WORLD_Y-GRID_HEIGHT-1)) screen_pos_y=(WORLD_Y-GRID_HEIGHT-1);
}


//view gets
int View::get_screen_pos_x()
{
return screen_pos_x;
}
int View::get_screen_pos_y()
{
return screen_pos_y;
}
int View::get_GRID_HEIGHT()
{
return GRID_HEIGHT;
}
int View::get_GRID_WIDTH()
{
return GRID_WIDTH;
}
int View::get_scroll_x()
{
return scroll_x;
}
int View::get_scroll_y()
{
return scroll_y;
}
BITMAP *View::get_buffer()
{
return buffer;
}
//view sets

 void View::set_screen_pos_x(int pos_x)
 {
screen_pos_x = pos_x;
 }
 void View::set_screen_pos_y(int pos_y)
{
screen_pos_y = pos_y;
 }
void View::set_GRID_WIDTH(int newGRID_WIDTH)
 {
GRID_WIDTH = newGRID_WIDTH;
 }
 void View::set_GRID_HEIGHT(int newGRID_HEIGHT)
{
GRID_HEIGHT = newGRID_HEIGHT;
 }

 void View::set_scroll_x(int pos_x)
{
scroll_x = pos_x;
 }
 void View::set_scroll_y(int pos_y)
{
scroll_y = pos_y;
 }
 void View::set_buffer(BITMAP * bmp)
{
buffer = bmp;
 }